/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.ddl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.modelbase.sql.expressions.QueryExpression;
import org.eclipse.datatools.modelbase.sql.expressions.QueryExpressionDefault;
import org.eclipse.datatools.modelbase.sql.expressions.SQLExpressionsPackage;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;

public class SybaseASEDdlParser {
    private DatabaseDefinition def;

    public SybaseASEDdlParser() {
    }

    public SybaseASEDdlParser(DatabaseDefinition def) {
        this.def = def;
    }

    public void parseView(ViewTable view, String viewText) {
        DataModelElementFactory factory = this.def.getDataModelElementFactory();
        String body = viewText;
        Pattern pattern = Pattern.compile(".*[\\s]+?AS[\\s]+?([(\\s]*SELECT.*)", 34);
        Matcher matcher = pattern.matcher(viewText);
        if (matcher.matches()) {
            body = matcher.group(1);
            pattern = Pattern.compile("(.*)[ \t]+?WITH[ \t]+?.*", 34);
            matcher = pattern.matcher(body);
            if (matcher.matches()) {
                body = matcher.group(1).trim();
            }
        }
        QueryExpression queryExpression = (QueryExpression)factory.create(SQLExpressionsPackage.eINSTANCE.getQueryExpressionDefault());
        ((QueryExpressionDefault)queryExpression).setSQL(body);
        view.setQueryExpression(queryExpression);
    }

    public String parseDefaultRuleStatement(String deftStr) {
        String body = deftStr;
        Pattern pattern = Pattern.compile(".*[\\s]+?AS[\\s]+?([(\\s]*.*)", 34);
        Matcher matcher = pattern.matcher(deftStr);
        if (matcher.matches()) {
            body = matcher.group(1);
        }
        return body.trim();
    }

    public String parseInlineDefault(String deftStr) {
        String body = deftStr;
        Pattern pattern = Pattern.compile(".*DEFAULT[\\s]+?([(\\s]*.*)", 34);
        Matcher matcher = pattern.matcher(deftStr);
        if (matcher.matches()) {
            body = matcher.group(1);
        }
        return body.trim();
    }

    public static void main(String[] args) {
        System.out.println(new SybaseASEDdlParser(null).parseInlineDefault("  default 999"));
    }
}

