/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.catalog;

import java.sql.Connection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalog;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogUtils;
import org.eclipse.datatools.enablement.ase.ddl.SybaseASEDdlParser;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.AccessRuleType;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.impl.SybaseASERuleImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASECatalogRule
extends SybaseASERuleImpl
implements ICatalogObject,
IAdaptable {
    private static final long serialVersionUID = 1595704824083450799L;
    private Boolean isStatementLoaded = Boolean.FALSE;
    private Boolean isAccessRuleLoaded = Boolean.FALSE;
    private Boolean isAccessTypeLoaded = Boolean.FALSE;
    private static final String PARSE_ACCESS_RULE = "CREATE[\\s]+?(((AND[\\s]+?)|(OR[\\s]+?))??ACCESS).*";

    public Database getCatalogDatabase() {
        return this.getSchema().getCatalog().getDatabase();
    }

    public Connection getConnection() {
        SybaseASECatalog catalog = (SybaseASECatalog)this.getSchema().getCatalog();
        return catalog.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (this.isNeedRefresh()) {
            Boolean bl = this.isStatementLoaded;
            synchronized (bl) {
                this.isStatementLoaded = Boolean.FALSE;
                super.setStatement(null);
            }
            bl = this.isAccessRuleLoaded;
            synchronized (bl) {
                this.isAccessRuleLoaded = Boolean.FALSE;
                super.setAccessRule(false);
            }
            bl = this.isAccessTypeLoaded;
            synchronized (bl) {
                this.isAccessTypeLoaded = Boolean.FALSE;
                super.setAccessType(null);
            }
            RefreshManager.getInstance().referesh((ICatalogObject)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatement() {
        Boolean bl = this.isStatementLoaded;
        synchronized (bl) {
            if (!this.isStatementLoaded.booleanValue()) {
                this.loadRuleStatement();
            }
        }
        return super.getStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAccessRule() {
        Boolean bl = this.isAccessRuleLoaded;
        synchronized (bl) {
            if (!this.isAccessRuleLoaded.booleanValue()) {
                this.loadRuleAccess();
            }
        }
        return super.isAccessRule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessRuleType getAccessType() {
        Boolean bl = this.isAccessTypeLoaded;
        synchronized (bl) {
            if (!this.isAccessTypeLoaded.booleanValue()) {
                this.loadRuleAccessType();
            }
        }
        return super.getAccessType();
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 9) {
            this.getStatement();
        } else if (id == 10) {
            this.isAccessRule();
        } else if (id == 11) {
            this.getAccessType();
        }
        return super.eIsSet(eFeature);
    }

    private void loadRuleStatement() {
        if (this.isStatementLoaded.booleanValue()) {
            return;
        }
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        String text = SybaseASECatalogUtils.getCompiledObjectText((SQLObject)this, connection, this.getSchema().getCatalog().getName());
        this.setStatement(new SybaseASEDdlParser().parseDefaultRuleStatement(text));
        this.eSetDeliver(deliver);
        this.isStatementLoaded = Boolean.TRUE;
    }

    private void loadRuleAccess() {
        if (this.isAccessRuleLoaded.booleanValue()) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        String stmt = SybaseASECatalogUtils.getCompiledObjectText((SQLObject)this, this.getConnection(), this.getSchema().getCatalog().getName());
        Pattern pattern = Pattern.compile(PARSE_ACCESS_RULE, 34);
        Matcher matcher = pattern.matcher(stmt);
        if (matcher.matches()) {
            if (matcher.group(1) != null) {
                this.setAccessRule(true);
            } else {
                this.setAccessRule(false);
            }
        }
        this.eSetDeliver(deliver);
        this.isAccessRuleLoaded = Boolean.TRUE;
    }

    private void loadRuleAccessType() {
        if (this.isAccessTypeLoaded.booleanValue()) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        String stmt = SybaseASECatalogUtils.getCompiledObjectText((SQLObject)this, this.getConnection(), this.getSchema().getCatalog().getName());
        Pattern pattern = Pattern.compile(PARSE_ACCESS_RULE, 34);
        Matcher matcher = pattern.matcher(stmt);
        if (matcher.matches() && matcher.group(1) != null && (matcher = (pattern = Pattern.compile("((AND[\\s]+?)|(OR[\\s]+?))??ACCESS", 34)).matcher(matcher.group(1))).matches()) {
            if (matcher.group(1) == null) {
                this.setAccessType(AccessRuleType.DEF_LITERAL);
            } else if (matcher.group(1).trim().equalsIgnoreCase("AND")) {
                this.setAccessType(AccessRuleType.AND_LITERAL);
            } else if (matcher.group(1).trim().equalsIgnoreCase("OR")) {
                this.setAccessType(AccessRuleType.OR_LITERAL);
            }
        }
        this.eSetDeliver(deliver);
        this.isAccessTypeLoaded = Boolean.TRUE;
    }

    public Object getAdapter(Class adapter) {
        Object adapterObject = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (adapterObject == null) {
            adapterObject = Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }
        return adapterObject;
    }

    private boolean isNeedRefresh() {
        return this.isStatementLoaded != false || this.isAccessRuleLoaded != false || this.isAccessTypeLoaded != false;
    }
}

