/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.statistics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfLostEvent;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.statistics.ITmfStatistics;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

@Deprecated
public class TmfEventsStatistics
implements ITmfStatistics {
    private static final int SCALE = -9;
    private final ITmfTrace fTrace;
    private StatsTotalRequest fTotalRequest = null;
    private StatsPerTypeRequest fPerTypeRequest = null;

    public TmfEventsStatistics(ITmfTrace trace) {
        this.fTrace = trace;
    }

    @Override
    public void dispose() {
        this.cancelOngoingRequests();
    }

    @Override
    public List<@NonNull Long> histogramQuery(long[] timeRequested) {
        HistogramQueryRequest req = new HistogramQueryRequest(timeRequested, timeRequested[timeRequested.length - 1]);
        this.sendAndWait(req);
        return new ArrayList<Long>(req.getResults());
    }

    private void cancelOngoingRequests() {
        this.killTotalRequestAndReplace(null);
        this.killPerTypeRequestAndReplace(null);
    }

    private synchronized void killPerTypeRequestAndReplace(StatsPerTypeRequest request) {
        if (this.fPerTypeRequest != null && this.fPerTypeRequest.isRunning()) {
            this.fPerTypeRequest.cancel();
        }
        this.fPerTypeRequest = request;
    }

    private synchronized void killTotalRequestAndReplace(StatsTotalRequest request) {
        if (this.fTotalRequest != null && this.fTotalRequest.isRunning()) {
            this.fTotalRequest.cancel();
        }
        this.fTotalRequest = request;
    }

    @Override
    public long getEventsTotal() {
        StatsTotalRequest request = new StatsTotalRequest(this.fTrace, TmfTimeRange.ETERNITY);
        this.killTotalRequestAndReplace(request);
        this.sendAndWait(request);
        return request.getResult();
    }

    @Override
    public Map<@NonNull String, @NonNull Long> getEventTypesTotal() {
        StatsPerTypeRequest request = new StatsPerTypeRequest(this.fTrace, TmfTimeRange.ETERNITY);
        this.killPerTypeRequestAndReplace(request);
        this.sendAndWait(request);
        return request.getResults();
    }

    @Override
    public long getEventsInRange(long start, long end) {
        ITmfTimestamp startTS = TmfTimestamp.create(start, -9);
        ITmfTimestamp endTS = TmfTimestamp.create(end, -9);
        TmfTimeRange range = new TmfTimeRange(startTS, endTS);
        StatsTotalRequest request = new StatsTotalRequest(this.fTrace, range);
        this.killTotalRequestAndReplace(request);
        this.sendAndWait(request);
        return request.getResult();
    }

    @Override
    public Map<String, Long> getEventTypesInRange(long start, long end) {
        ITmfTimestamp startTS = TmfTimestamp.create(start, -9);
        ITmfTimestamp endTS = TmfTimestamp.create(end, -9);
        TmfTimeRange range = new TmfTimeRange(startTS, endTS);
        StatsPerTypeRequest request = new StatsPerTypeRequest(this.fTrace, range);
        this.killPerTypeRequestAndReplace(request);
        this.sendAndWait(request);
        return request.getResults();
    }

    private void sendAndWait(TmfEventRequest request) {
        this.fTrace.sendRequest(request);
        try {
            request.waitForCompletion();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private class HistogramQueryRequest
    extends TmfEventRequest {
        private final TreeMap<Long, @NonNull Long> results;

        public HistogramQueryRequest(long[] borders, long endTime) {
            super(TmfEventsStatistics.this.fTrace.getEventType(), new TmfTimeRange(TmfTimestamp.create(borders[0], -9), TmfTimestamp.create(endTime, -9)), 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
            this.results = new TreeMap();
            long[] lArray = borders;
            int n = borders.length;
            int n2 = 0;
            while (n2 < n) {
                long border = lArray[n2];
                this.results.put(border, 0L);
                ++n2;
            }
        }

        public Collection<@NonNull Long> getResults() {
            return this.results.values();
        }

        @Override
        public void handleData(ITmfEvent event) {
            long ts;
            Long key;
            super.handleData(event);
            if (Objects.equals(event.getTrace(), TmfEventsStatistics.this.fTrace) && (key = this.results.ceilingKey(ts = event.getTimestamp().toNanos())) != null) {
                this.results.merge(key, 1L, Long::sum);
            }
        }
    }

    private class StatsPerTypeRequest
    extends TmfEventRequest {
        private final Map<@NonNull String, @NonNull Long> stats;

        public StatsPerTypeRequest(ITmfTrace trace, TmfTimeRange range) {
            super(trace.getEventType(), range, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
            this.stats = new HashMap<String, Long>();
        }

        public Map<@NonNull String, @NonNull Long> getResults() {
            return this.stats;
        }

        @Override
        public void handleData(ITmfEvent event) {
            super.handleData(event);
            if (event.getTrace() == TmfEventsStatistics.this.fTrace) {
                String eventType = event.getName();
                if (event instanceof ITmfLostEvent) {
                    ITmfLostEvent le = (ITmfLostEvent)event;
                    this.incrementStats(eventType, le.getNbLostEvents());
                    return;
                }
                this.incrementStats(eventType, 1L);
            }
        }

        private void incrementStats(@NonNull String key, long count) {
            this.stats.merge(key, count, Long::sum);
        }
    }

    private class StatsTotalRequest
    extends TmfEventRequest {
        private long total;

        public StatsTotalRequest(ITmfTrace trace, TmfTimeRange range) {
            super(trace.getEventType(), range, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
            this.total = 0L;
        }

        public long getResult() {
            return this.total;
        }

        @Override
        public void handleData(ITmfEvent event) {
            super.handleData(event);
            if (!(event instanceof ITmfLostEvent) && Objects.equals(event.getTrace(), TmfEventsStatistics.this.fTrace)) {
                ++this.total;
            }
        }
    }
}

