/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.operations.RemoteProjectFolder;
import org.eclipse.team.internal.ccvs.ui.wizards.ICVSWizard;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public abstract class CVSWizardPage
extends WizardPage {
    protected static final int LABEL_WIDTH_HINT = 400;
    protected static final int LABEL_INDENT_WIDTH = 32;
    protected static final int LIST_HEIGHT_HINT = 100;
    protected static final int SPACER_HEIGHT = 8;
    private ICVSWizard wizard;

    public CVSWizardPage(String pageName) {
        super(pageName);
    }

    public CVSWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public CVSWizardPage(String pageName, String title, ImageDescriptor titleImage, String description) {
        super(pageName, title, titleImage);
        this.setDescription(description);
    }

    protected Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        button.setLayoutData((Object)data);
        return button;
    }

    protected Combo createCombo(Composite parent) {
        Combo combo = new Combo(parent, 8);
        GridData data = new GridData(768);
        data.widthHint = 200;
        combo.setLayoutData((Object)data);
        return combo;
    }

    protected Composite createComposite(Composite parent, int numColumns, boolean grabExcess) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(numColumns, false));
        composite.setLayoutData((Object)new GridData(4, 4, grabExcess, grabExcess));
        return composite;
    }

    public static Label createLabel(Composite parent, String text) {
        return CVSWizardPage.createIndentedLabel(parent, text, 0);
    }

    public static Label createIndentedLabel(Composite parent, String text, int indent) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.horizontalIndent = indent;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Label createWrappingLabel(Composite parent, String text, int indent) {
        return this.createWrappingLabel(parent, text, indent, 1);
    }

    protected Label createWrappingLabel(Composite parent, String text, int indent, int horizontalSpan) {
        Label label = new Label(parent, 16448);
        label.setText(text);
        GridData data = new GridData(4, 1, true, false);
        data.horizontalIndent = indent;
        data.horizontalSpan = horizontalSpan;
        data.widthHint = 400;
        label.setLayoutData((Object)data);
        return label;
    }

    public static Text createTextField(Composite parent) {
        Text text = new Text(parent, 2052);
        return CVSWizardPage.layoutTextField(text);
    }

    public static Text createPasswordField(Composite parent) {
        Text text = new Text(parent, 0x400804);
        return CVSWizardPage.layoutTextField(text);
    }

    public static Text layoutTextField(Text text) {
        GridData data = new GridData(768);
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        data.widthHint = 200;
        text.setLayoutData((Object)data);
        return text;
    }

    protected Button createRadioButton(Composite parent, String label, int span) {
        Button button = new Button(parent, 16);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = span;
        button.setLayoutData((Object)data);
        return button;
    }

    protected TreeViewer createResourceSelectionTree(Composite composite, int types, int span) {
        TreeViewer tree = new TreeViewer(composite, 2816);
        tree.setUseHashlookup(true);
        tree.setContentProvider((IContentProvider)this.getResourceProvider(types));
        tree.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), CVSUIPlugin.getPlugin().getWorkbench().getDecoratorManager().getLabelDecorator()));
        tree.setComparator((ViewerComparator)new ResourceComparator(1));
        GridData data = new GridData(1808);
        data.heightHint = 100;
        data.horizontalSpan = span;
        tree.getControl().setLayoutData((Object)data);
        return tree;
    }

    protected ITreeContentProvider getResourceProvider(final int resourceType) {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof IContainer) {
                    IResource[] members = null;
                    try {
                        members = ((IContainer)o).members();
                    }
                    catch (CoreException coreException) {
                        return new Object[0];
                    }
                    ArrayList<IResource> results = new ArrayList<IResource>();
                    IResource[] iResourceArray = members;
                    int n = members.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource member = iResourceArray[n2];
                        if ((member.getType() & resourceType) > 0) {
                            results.add(member);
                        }
                        ++n2;
                    }
                    return results.toArray();
                }
                return super.getChildren(o);
            }
        };
    }

    protected ICVSWizard getCVSWizard() {
        if (this.wizard != null) {
            return this.wizard;
        }
        IWizard wizard = this.getWizard();
        if (wizard instanceof ICVSWizard) {
            return (ICVSWizard)wizard;
        }
        return null;
    }

    public void setCVSWizard(ICVSWizard wizard) {
        this.wizard = wizard;
    }

    public IWizardPage getNextPage() {
        ICVSWizard w = this.getCVSWizard();
        if (w != null) {
            return w.getNextPage((IWizardPage)this, true);
        }
        return super.getNextPage();
    }

    public boolean canFlipToNextPage() {
        ICVSWizard w = this.getCVSWizard();
        if (w != null) {
            return this.isPageComplete() && w.getNextPage((IWizardPage)this, false) != null;
        }
        return super.canFlipToNextPage();
    }

    protected static String getPreferredFolderName(ICVSRemoteFolder folder) {
        RemoteProjectFolder rpf;
        if (CVSUIPlugin.getPlugin().isUseProjectNameOnCheckout() && folder instanceof RemoteProjectFolder && (rpf = (RemoteProjectFolder)folder).hasProjectName()) {
            return rpf.getProjectName();
        }
        return folder.getName();
    }
}

