/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.tags;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.tags.MultiFolderTagSource;
import org.eclipse.team.internal.ccvs.ui.tags.SingleFileTagSource;
import org.eclipse.team.internal.ccvs.ui.tags.SingleFolderTagSource;

public abstract class TagSource {
    public static final int BASE = -1;
    public static final TagSource EMPTY = new TagSource(){

        @Override
        public void commit(CVSTag[] tags, boolean replace, IProgressMonitor monitor) throws CVSException {
        }

        @Override
        public ICVSRepositoryLocation getLocation() {
            return null;
        }

        @Override
        public String getShortDescription() {
            return "Empty";
        }

        @Override
        public CVSTag[] getTags(int type) {
            return new CVSTag[0];
        }

        @Override
        public CVSTag[] refresh(boolean bestEffort, IProgressMonitor monitor) throws TeamException {
            return new CVSTag[0];
        }

        @Override
        public ICVSResource[] getCVSResources() {
            return new ICVSResource[0];
        }
    };
    private ListenerList<ITagSourceChangeListener> listeners = new ListenerList(1);

    public static int[] convertIncludeFlaqsToTagTypes(int includeFlags) {
        ArrayList<Integer> types = new ArrayList<Integer>();
        if ((includeFlags & 4) > 0) {
            types.add(1);
        }
        if ((includeFlags & 8) > 0) {
            types.add(2);
        }
        if ((includeFlags & 1) > 0) {
            types.add(0);
        }
        if ((includeFlags & 0x10) > 0) {
            types.add(3);
        }
        if ((includeFlags & 2) > 0) {
            types.add(-1);
        }
        int[] result = new int[types.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (Integer)types.get(i);
            ++i;
        }
        return result;
    }

    public static TagSource create(ICVSFolder[] folders) {
        if (folders.length == 1) {
            return new SingleFolderTagSource(folders[0]);
        }
        return new MultiFolderTagSource(folders);
    }

    public static TagSource create(ICVSResource[] resources) {
        if (resources.length == 1 && !resources[0].isFolder()) {
            return new SingleFileTagSource((ICVSFile)resources[0]);
        }
        return TagSource.create(TagSource.getFolders(resources));
    }

    private static ICVSFolder[] getFolders(ICVSResource[] resources) {
        HashSet<ICVSFolder> result = new HashSet<ICVSFolder>();
        ICVSResource[] iCVSResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            ICVSResource resource = iCVSResourceArray[n2];
            result.add(TagSource.getFirstFolder(resource));
            ++n2;
        }
        return result.toArray(new ICVSFolder[result.size()]);
    }

    public static TagSource create(IResource[] resources) {
        return TagSource.create(TagSource.getCVSResources(TagSource.getProjects(resources)));
    }

    public static TagSource create(ResourceMapping[] mappers) {
        return TagSource.create(TagSource.getCVSResources(TagSource.getProjects(mappers)));
    }

    private static IResource[] getProjects(ResourceMapping[] mappers) {
        HashSet<IProject> projects = new HashSet<IProject>();
        ResourceMapping[] resourceMappingArray = mappers;
        int n = mappers.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapper = resourceMappingArray[n2];
            projects.addAll(Arrays.asList(mapper.getProjects()));
            ++n2;
        }
        return projects.toArray(new IResource[projects.size()]);
    }

    private static IResource[] getProjects(IResource[] resources) {
        HashSet<IProject> result = new HashSet<IProject>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            result.add(resource.getProject());
            ++n2;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public static TagSource create(ICVSRemoteFolder remote) {
        return new SingleFolderTagSource((ICVSFolder)remote);
    }

    private static ICVSResource[] getCVSResources(IResource[] resources) {
        ArrayList<ICVSResource> cvsResources = new ArrayList<ICVSResource>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            cvsResources.add(CVSWorkspaceRoot.getCVSResourceFor((IResource)resource));
            ++n2;
        }
        return cvsResources.toArray(new ICVSResource[cvsResources.size()]);
    }

    private static ICVSFolder getFirstFolder(ICVSResource resource) {
        if (resource.isFolder()) {
            return (ICVSFolder)resource;
        }
        return resource.getParent();
    }

    public CVSTag[] getTags(int type) {
        switch (type) {
            case -1: {
                return new CVSTag[]{CVSTag.BASE};
            }
            case 0: {
                return new CVSTag[]{CVSTag.DEFAULT};
            }
        }
        return new CVSTag[0];
    }

    public CVSTag[] getTags(int[] types) {
        if (types.length == 0) {
            return new CVSTag[0];
        }
        if (types.length == 1) {
            return this.getTags(types[0]);
        }
        ArrayList<CVSTag> result = new ArrayList<CVSTag>();
        int i = 0;
        while (i < types.length) {
            int type = types[i];
            CVSTag[] tags = this.getTags(type);
            result.addAll(Arrays.asList(tags));
            ++i;
        }
        return result.toArray(new CVSTag[result.size()]);
    }

    public abstract CVSTag[] refresh(boolean var1, IProgressMonitor var2) throws TeamException;

    public abstract ICVSRepositoryLocation getLocation();

    public abstract String getShortDescription();

    public abstract void commit(CVSTag[] var1, boolean var2, IProgressMonitor var3) throws CVSException;

    public void addListener(ITagSourceChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(ITagSourceChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void fireChange() {
        Object[] list;
        Object[] objectArray = list = this.listeners.getListeners();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            final ITagSourceChangeListener listener = (ITagSourceChangeListener)o;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.tagsChanged(TagSource.this);
                }
            });
            ++n2;
        }
    }

    public abstract ICVSResource[] getCVSResources();

    public static interface ITagSourceChangeListener {
        public void tagsChanged(TagSource var1);
    }
}

