/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.ui.CVSHistoryPage;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.history.HistoryPageCompareEditorInput;
import org.eclipse.team.ui.history.HistoryPageSource;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryPageSource;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IWorkbenchPage;

public class CompareWithRevisionAction
extends WorkspaceAction {
    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        this.run(monitor -> {
            if (this.isShowInDialog()) {
                IFile file = (IFile)this.getSelectedResources()[0];
                this.showCompareInDialog(this.getShell(), file);
            } else {
                IHistoryView view = TeamUI.showHistoryFor((IWorkbenchPage)TeamUIPlugin.getActivePage(), (Object)this.getSelectedResources()[0], null);
                IHistoryPage page = view.getHistoryPage();
                if (page instanceof CVSHistoryPage) {
                    CVSHistoryPage cvsHistoryPage = (CVSHistoryPage)page;
                    cvsHistoryPage.setClickAction(true);
                }
            }
        }, false, 2);
    }

    protected void showCompareInDialog(Shell shell, Object object) {
        IHistoryPageSource pageSource = HistoryPageSource.getHistoryPageSource((Object)object);
        if (pageSource != null && pageSource.canShowHistoryFor(object)) {
            CompareConfiguration cc = new CompareConfiguration();
            cc.setLeftEditable(true);
            cc.setRightEditable(false);
            HistoryPageCompareEditorInput input = new HistoryPageCompareEditorInput(cc, pageSource, object){

                public void saveChanges(IProgressMonitor monitor) throws CoreException {
                    super.saveChanges(monitor);
                    ((CVSHistoryPage)this.getHistoryPage()).saveChanges(monitor);
                    this.setDirty(false);
                }
            };
            CompareUI.openCompareDialog((CompareEditorInput)input);
        }
    }

    protected String getActionTitle() {
        return CVSUIMessages.CompareWithRevisionAction_4;
    }

    @Override
    protected String getErrorTitle() {
        return CVSUIMessages.CompareWithRevisionAction_compare;
    }

    @Override
    protected boolean isEnabledForCVSResource(ICVSResource cvsResource) throws CVSException {
        return !cvsResource.isFolder() && super.isEnabledForCVSResource(cvsResource);
    }

    @Override
    protected boolean isEnabledForMultipleResources() {
        return false;
    }

    @Override
    protected boolean isEnabledForAddedResources() {
        return true;
    }

    @Override
    protected boolean isEnabledForUnmanagedResources() {
        return true;
    }

    @Override
    protected boolean isEnabledForIgnoredResources() {
        return true;
    }

    protected boolean isShowInDialog() {
        return CVSUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_show_compare_revision_in_dialog");
    }
}

