/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.ui;

import java.net.URL;
import java.util.Collections;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.reddeer.ui";
    public static final String REDDEER_ICON = "reddeer_icon";
    public static final String REDDEER_RUNNER = "reddeer_runner";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void log(Exception e, String message) {
        Status status = new Status(4, PLUGIN_ID, message, (Throwable)e);
        plugin.getLog().log((IStatus)status);
    }

    public static void log(Throwable e) {
        Status status = new Status(4, PLUGIN_ID, e.getLocalizedMessage(), e);
        plugin.getLog().log((IStatus)status);
    }

    public static void logWarning(String message) {
        Status status = new Status(2, PLUGIN_ID, message);
        plugin.getLog().log((IStatus)status);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        this.initializeImageRegistry(reg, REDDEER_ICON);
        this.initializeImageRegistry(reg, REDDEER_RUNNER);
    }

    private void initializeImageRegistry(ImageRegistry reg, String icon) {
        Path iconPath = new Path("resources/" + icon + ".png");
        URL iconURL = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)iconPath, Collections.emptyMap());
        reg.put(icon, ImageDescriptor.createFromURL((URL)iconURL));
    }
}

