/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.editors;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.ui.CommonUiUtil;
import org.eclipse.mylyn.commons.ui.GradientCanvas;
import org.eclipse.mylyn.commons.workbench.editors.CommonTextSupport;
import org.eclipse.mylyn.commons.workbench.forms.CommonFormUtil;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.ITaskListRunnable;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.core.data.ITaskDataManagerListener;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManagerEvent;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.ClearOutgoingAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.DeleteTaskEditorAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.NewSubTaskAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.OpenWithBrowserAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.SynchronizeEditorAction;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorSection;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.FocusTracker;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskAttachmentDropListener;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorActionContributor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorActionPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorAttachmentPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorAttributePart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorCommentPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorContributionExtensionReader;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorDescriptionPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorFindSupport;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorNewCommentPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorOutlineNode;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorOutlinePage;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorPeoplePart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorPlanningPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorRichTextPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorSummaryPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskMigrator;
import org.eclipse.mylyn.internal.tasks.ui.editors.ToolBarButtonContribution;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.core.data.TaskDataModelEvent;
import org.eclipse.mylyn.tasks.core.data.TaskDataModelListener;
import org.eclipse.mylyn.tasks.core.data.TaskRelation;
import org.eclipse.mylyn.tasks.core.sync.SubmitJob;
import org.eclipse.mylyn.tasks.core.sync.SubmitJobEvent;
import org.eclipse.mylyn.tasks.core.sync.SubmitJobListener;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorToolkit;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorPartDescriptor;
import org.eclipse.mylyn.tasks.ui.editors.TaskFormPage;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class AbstractTaskEditorPage
extends TaskFormPage
implements ISelectionProvider,
ISelectionChangedListener {
    private final ITaskDataManagerListener TASK_DATA_LISTENER = new ITaskDataManagerListener(){

        public void taskDataUpdated(TaskDataManagerEvent event) {
            ITask task = event.getTask();
            if (task.equals(AbstractTaskEditorPage.this.getTask()) && event.getTaskDataUpdated()) {
                this.refresh(task);
            }
        }

        private void refresh(final ITask task) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (AbstractTaskEditorPage.this.refreshDisabled || AbstractTaskEditorPage.this.busy) {
                        return;
                    }
                    if (!AbstractTaskEditorPage.this.isDirty() && task.getSynchronizationState() == ITask.SynchronizationState.SYNCHRONIZED) {
                        AbstractTaskEditorPage.this.refresh();
                    } else {
                        AbstractTaskEditorPage.this.getTaskEditor().setMessage(Messages.AbstractTaskEditorPage_Task_has_incoming_changes, 2, (IHyperlinkListener)new HyperlinkAdapter(){

                            public void linkActivated(HyperlinkEvent e) {
                                AbstractTaskEditorPage.this.refresh();
                            }
                        });
                        AbstractTaskEditorPage.this.setSubmitEnabled(false);
                    }
                }
            });
        }

        public void editsDiscarded(TaskDataManagerEvent event) {
            if (event.getTask().equals(AbstractTaskEditorPage.this.getTask())) {
                this.refresh(event.getTask());
            }
        }
    };
    private static final String ERROR_NOCONNECTIVITY = Messages.AbstractTaskEditorPage_Unable_to_submit_at_this_time;
    public static final String ID_PART_ACTIONS = "org.eclipse.mylyn.tasks.ui.editors.parts.actions";
    public static final String ID_PART_ATTACHMENTS = "org.eclipse.mylyn.tasks.ui.editors.parts.attachments";
    public static final String ID_PART_ATTRIBUTES = "org.eclipse.mylyn.tasks.ui.editors.parts.attributes";
    public static final String ID_PART_COMMENTS = "org.eclipse.mylyn.tasks.ui.editors.parts.comments";
    public static final String ID_PART_DESCRIPTION = "org.eclipse.mylyn.tasks.ui.editors.parts.descriptions";
    public static final String ID_PART_NEW_COMMENT = "org.eclipse.mylyn.tasks.ui.editors.parts.newComment";
    public static final String ID_PART_PEOPLE = "org.eclipse.mylyn.tasks.ui.editors.parts.people";
    public static final String ID_PART_PLANNING = "org.eclipse.mylyn.tasks.ui.editors.parts.planning";
    public static final String ID_PART_SUMMARY = "org.eclipse.mylyn.tasks.ui.editors.parts.summary";
    public static final String PATH_ACTIONS = "actions";
    public static final String PATH_ASSOCIATIONS = "associations";
    public static final String PATH_ATTACHMENTS = "attachments";
    public static final String PATH_ATTRIBUTES = "attributes";
    public static final String PATH_COMMENTS = "comments";
    public static final String PATH_HEADER = "header";
    public static final String PATH_PEOPLE = "people";
    public static final String PATH_PLANNING = "planning";
    private AttributeEditorFactory attributeEditorFactory;
    private AttributeEditorToolkit attributeEditorToolkit;
    private AbstractRepositoryConnector connector;
    private final String connectorKind;
    private StructuredSelection defaultSelection;
    private Composite editorComposite;
    private ScrolledForm form;
    private boolean busy;
    private ISelection lastSelection;
    private TaskDataModel model;
    private boolean needsAddToCategory;
    private boolean reflow;
    private volatile boolean refreshDisabled;
    private final ListenerList selectionChangedListeners;
    private SynchronizeEditorAction synchronizeEditorAction;
    private ITask task;
    private TaskData taskData;
    private FormToolkit toolkit;
    private TaskEditorOutlinePage outlinePage;
    private TaskAttachmentDropListener defaultDropListener;
    private CommonTextSupport textSupport;
    private Composite partControl;
    private GradientCanvas footerComposite;
    private boolean needsFooter;
    private Button submitButton;
    private boolean submitEnabled;
    private boolean needsSubmit;
    private boolean needsSubmitButton;
    private boolean needsPrivateSection;
    private FocusTracker focusTracker;
    private TaskEditorFindSupport findSupport;

    public AbstractTaskEditorPage(TaskEditor editor, String id, String label, String connectorKind) {
        super((FormEditor)editor, id, label);
        Assert.isNotNull((Object)connectorKind);
        this.connectorKind = connectorKind;
        this.reflow = true;
        this.selectionChangedListeners = new ListenerList();
        this.submitEnabled = true;
        this.needsSubmit = true;
    }

    public AbstractTaskEditorPage(TaskEditor editor, String connectorKind) {
        this(editor, "id", "label", connectorKind);
    }

    public TaskEditor getEditor() {
        return (TaskEditor)super.getEditor();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public void appendTextToNewComment(String text) {
        AbstractTaskEditorPart newCommentPart = this.getPart(ID_PART_NEW_COMMENT);
        if (newCommentPart instanceof TaskEditorRichTextPart) {
            ((TaskEditorRichTextPart)newCommentPart).appendText(text);
            newCommentPart.setFocus();
        }
    }

    public boolean canPerformAction(String actionId) {
        if (this.findSupport != null && actionId.equals(ActionFactory.FIND.getId())) {
            return true;
        }
        return CommonTextSupport.canPerformAction((String)actionId, (Control)EditorUtil.getFocusControl((IFormPage)this));
    }

    public void close() {
        if (Display.getCurrent() != null) {
            this.getSite().getPage().closeEditor((IEditorPart)this.getTaskEditor(), false);
        } else {
            Display activeDisplay = this.getSite().getShell().getDisplay();
            activeDisplay.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (AbstractTaskEditorPage.this.getSite() != null && AbstractTaskEditorPage.this.getSite().getPage() != null && !AbstractTaskEditorPage.this.getManagedForm().getForm().isDisposed()) {
                        if (AbstractTaskEditorPage.this.getTaskEditor() != null) {
                            AbstractTaskEditorPage.this.getSite().getPage().closeEditor((IEditorPart)AbstractTaskEditorPage.this.getTaskEditor(), false);
                        } else {
                            AbstractTaskEditorPage.this.getSite().getPage().closeEditor((IEditorPart)AbstractTaskEditorPage.this, false);
                        }
                    }
                }
            });
        }
    }

    protected AttributeEditorFactory createAttributeEditorFactory() {
        return new AttributeEditorFactory(this.getModel(), this.getTaskRepository(), (IServiceLocator)this.getEditorSite());
    }

    AttributeEditorToolkit createAttributeEditorToolkit() {
        return new AttributeEditorToolkit(this.textSupport);
    }

    public void createPartControl(Composite parent) {
        parent.addListener(11, (Listener)new ParentResizeHandler());
        if (this.needsFooter()) {
            this.partControl = this.getEditor().getToolkit().createComposite(parent);
            GridLayout partControlLayout = new GridLayout(1, false);
            partControlLayout.marginWidth = 0;
            partControlLayout.marginHeight = 0;
            partControlLayout.verticalSpacing = 0;
            this.partControl.setLayout((Layout)partControlLayout);
            super.createPartControl(this.partControl);
            this.getManagedForm().getForm().setLayoutData((Object)new GridData(4, 4, true, true));
            this.footerComposite = new GradientCanvas(this.partControl, 0);
            this.footerComposite.setSeparatorVisible(true);
            this.footerComposite.setSeparatorAlignment(128);
            GridLayout headLayout = new GridLayout();
            headLayout.marginHeight = 0;
            headLayout.marginWidth = 0;
            headLayout.horizontalSpacing = 0;
            headLayout.verticalSpacing = 0;
            headLayout.numColumns = 1;
            this.footerComposite.setLayout((Layout)headLayout);
            this.footerComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            FormColors colors = this.getEditor().getToolkit().getColors();
            Color top = colors.getColor("org.eclipse.ui.forms.H_GRADIENT_END");
            Color bottom = colors.getColor("org.eclipse.ui.forms.H_GRADIENT_START");
            this.footerComposite.setBackgroundGradient(new Color[]{bottom, top}, new int[]{100}, true);
            this.footerComposite.putColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1", colors.getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1"));
            this.footerComposite.putColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2", colors.getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2"));
            this.footerComposite.putColor("org.eclipse.ui.forms.H_H_HOVER_LIGHT", colors.getColor("org.eclipse.ui.forms.H_H_HOVER_LIGHT"));
            this.footerComposite.putColor("org.eclipse.ui.forms.H_H_HOVER_FULL", colors.getColor("org.eclipse.ui.forms.H_H_HOVER_FULL"));
            this.footerComposite.putColor("org.eclipse.ui.forms.TB_TOGGLE", colors.getColor("org.eclipse.ui.forms.TB_TOGGLE"));
            this.footerComposite.putColor("org.eclipse.ui.forms.TB_TOGGLE_HOVER", colors.getColor("org.eclipse.ui.forms.TB_TOGGLE_HOVER"));
            this.footerComposite.setLayoutData((Object)new GridData(4, 1024, true, false));
            this.createFooterContent((Composite)this.footerComposite);
        } else {
            super.createPartControl(parent);
        }
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.form = managedForm.getForm();
        this.toolkit = managedForm.getToolkit();
        this.registerDefaultDropListener((Control)this.form);
        CommonFormUtil.disableScrollingOnFocus((ScrolledForm)this.form);
        try {
            this.setReflow(false);
            this.editorComposite = this.form.getBody();
            GridLayout editorLayout = new GridLayout();
            editorLayout.verticalSpacing = 0;
            this.editorComposite.setLayout((Layout)editorLayout);
            this.editorComposite.setMenu(this.getTaskEditor().getMenu());
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(this.getConnectorKind());
            if (connectorUi == null) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractTaskEditorPage.this.getTaskEditor().setMessage(Messages.AbstractTaskEditorPage_Synchronize_to_update_editor_contents, 1, (IHyperlinkListener)new HyperlinkAdapter(){

                            public void linkActivated(HyperlinkEvent e) {
                                AbstractTaskEditorPage.this.refresh();
                            }
                        });
                    }
                });
            }
            if (this.taskData != null) {
                this.createFormContentInternal();
            }
            this.updateHeaderMessage();
        }
        catch (Throwable throwable) {
            this.setReflow(true);
            boolean reflowRequired = this.calculateReflowRequired(this.form);
            if (reflowRequired) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractTaskEditorPage.this.reflow();
                    }
                });
            }
            throw throwable;
        }
        this.setReflow(true);
        boolean reflowRequired = this.calculateReflowRequired(this.form);
        if (reflowRequired) {
            Display.getCurrent().asyncExec(new /* invalid duplicate definition of identical inner class */);
        }
    }

    private boolean calculateReflowRequired(ScrolledForm form) {
        Composite stopComposite = this.getEditor().getEditorParent().getParent().getParent();
        Composite composite = form.getParent();
        while (composite != null) {
            Rectangle clientArea = composite.getClientArea();
            if (clientArea.width > 1) {
                return false;
            }
            if (composite == stopComposite) {
                return true;
            }
            composite = composite.getParent();
        }
        return true;
    }

    private void createFormContentInternal() {
        if (this.attributeEditorToolkit != null) {
            this.attributeEditorToolkit.dispose();
        }
        if (this.attributeEditorFactory == null) {
            this.attributeEditorFactory = this.createAttributeEditorFactory();
            Assert.isNotNull((Object)this.attributeEditorFactory);
        }
        this.attributeEditorToolkit = this.createAttributeEditorToolkit();
        Assert.isNotNull((Object)this.attributeEditorToolkit);
        this.attributeEditorToolkit.setMenu(this.editorComposite.getMenu());
        this.attributeEditorFactory.setEditorToolkit(this.attributeEditorToolkit);
        this.createParts();
        this.focusTracker = new FocusTracker();
        this.focusTracker.track(this.editorComposite);
    }

    protected TaskDataModel createModel(TaskEditorInput input) throws CoreException {
        ITaskDataWorkingCopy taskDataState;
        try {
            taskDataState = TasksUi.getTaskDataManager().getWorkingCopy(this.task);
        }
        catch (OperationCanceledException e) {
            taskDataState = TasksUi.getTaskDataManager().getWorkingCopy(this.task);
        }
        TaskRepository taskRepository = TasksUi.getRepositoryManager().getRepository(taskDataState.getConnectorKind(), taskDataState.getRepositoryUrl());
        return new TaskDataModel(taskRepository, input.getTask(), taskDataState);
    }

    protected Set<TaskEditorPartDescriptor> createPartDescriptors() {
        LinkedHashSet<TaskEditorPartDescriptor> descriptors = new LinkedHashSet<TaskEditorPartDescriptor>();
        descriptors.add(new TaskEditorPartDescriptor(ID_PART_SUMMARY){

            @Override
            public AbstractTaskEditorPart createPart() {
                return new TaskEditorSummaryPart();
            }
        }.setPath(PATH_HEADER));
        descriptors.add(new TaskEditorPartDescriptor(ID_PART_ATTRIBUTES){

            @Override
            public AbstractTaskEditorPart createPart() {
                return new TaskEditorAttributePart();
            }
        }.setPath(PATH_ATTRIBUTES));
        if (!this.taskData.isNew() && this.connector.getTaskAttachmentHandler() != null && (AttachmentUtil.canDownloadAttachment(this.task) || AttachmentUtil.canUploadAttachment(this.task))) {
            descriptors.add(new TaskEditorPartDescriptor(ID_PART_ATTACHMENTS){

                @Override
                public AbstractTaskEditorPart createPart() {
                    return new TaskEditorAttachmentPart();
                }
            }.setPath(PATH_ATTACHMENTS));
        }
        if (this.needsPrivateSection() || this.taskData.isNew()) {
            descriptors.add(new TaskEditorPartDescriptor(ID_PART_PLANNING){

                @Override
                public AbstractTaskEditorPart createPart() {
                    return new TaskEditorPlanningPart();
                }
            }.setPath(PATH_PLANNING));
        }
        descriptors.add(new TaskEditorPartDescriptor(ID_PART_DESCRIPTION){

            @Override
            public AbstractTaskEditorPart createPart() {
                TaskEditorDescriptionPart part = new TaskEditorDescriptionPart();
                if (AbstractTaskEditorPage.this.getModel().getTaskData().isNew()) {
                    part.setExpandVertically(true);
                    part.setSectionStyle(320);
                }
                return part;
            }
        }.setPath(PATH_COMMENTS));
        if (!this.taskData.isNew()) {
            descriptors.add(new TaskEditorPartDescriptor(ID_PART_COMMENTS){

                @Override
                public AbstractTaskEditorPart createPart() {
                    return new TaskEditorCommentPart();
                }
            }.setPath(PATH_COMMENTS));
        }
        descriptors.add(new TaskEditorPartDescriptor(ID_PART_NEW_COMMENT){

            @Override
            public AbstractTaskEditorPart createPart() {
                return new TaskEditorNewCommentPart();
            }
        }.setPath(PATH_COMMENTS));
        descriptors.add(new TaskEditorPartDescriptor(ID_PART_ACTIONS){

            @Override
            public AbstractTaskEditorPart createPart() {
                return new TaskEditorActionPart();
            }
        }.setPath(PATH_ACTIONS));
        descriptors.add(new TaskEditorPartDescriptor(ID_PART_PEOPLE){

            @Override
            public AbstractTaskEditorPart createPart() {
                return new TaskEditorPeoplePart();
            }
        }.setPath(PATH_PEOPLE));
        descriptors.addAll(this.getContributionPartDescriptors());
        return descriptors;
    }

    private Collection<TaskEditorPartDescriptor> getContributionPartDescriptors() {
        return TaskEditorContributionExtensionReader.getRepositoryEditorContributions();
    }

    protected void createParts() {
        LinkedList<TaskEditorPartDescriptor> descriptors = new LinkedList<TaskEditorPartDescriptor>(this.createPartDescriptors());
        this.createParts(PATH_HEADER, this.editorComposite, descriptors);
        this.createParts(PATH_ASSOCIATIONS, this.editorComposite, descriptors);
        this.createParts(PATH_ATTRIBUTES, this.editorComposite, descriptors);
        this.createParts(PATH_ATTACHMENTS, this.editorComposite, descriptors);
        this.createParts(PATH_PLANNING, this.editorComposite, descriptors);
        this.createParts(PATH_COMMENTS, this.editorComposite, descriptors);
        Composite bottomComposite = this.toolkit.createComposite(this.editorComposite);
        bottomComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)bottomComposite);
        this.createParts(PATH_ACTIONS, bottomComposite, descriptors);
        this.createParts(PATH_PEOPLE, bottomComposite, descriptors);
        bottomComposite.pack(true);
    }

    private void createParts(String path, final Composite parent, final Collection<TaskEditorPartDescriptor> descriptors) {
        Iterator<TaskEditorPartDescriptor> it = descriptors.iterator();
        while (it.hasNext()) {
            final TaskEditorPartDescriptor descriptor = it.next();
            if (path != null && !path.equals(descriptor.getPath())) continue;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Error creating task editor part: \"" + descriptor.getId() + "\"", e));
                }

                public void run() throws Exception {
                    AbstractTaskEditorPart part = descriptor.createPart();
                    part.setPartId(descriptor.getId());
                    AbstractTaskEditorPage.this.initializePart(parent, part, descriptors);
                }
            });
            it.remove();
        }
    }

    private void createSubParts(final AbstractTaskEditorSection parentPart, Collection<TaskEditorPartDescriptor> descriptors) {
        for (final TaskEditorPartDescriptor descriptor : descriptors) {
            int i;
            String path = descriptor.getPath();
            if (path == null || (i = path.indexOf("/")) == -1) continue;
            String parentId = path.substring(0, i);
            final String subPath = path.substring(i + 1);
            if (!parentId.equals(parentPart.getPartId())) continue;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Error creating task editor part: \"" + descriptor.getId() + "\"", e));
                }

                public void run() throws Exception {
                    AbstractTaskEditorPart part = descriptor.createPart();
                    part.setPartId(descriptor.getId());
                    AbstractTaskEditorPage.this.getManagedForm().addPart((IFormPart)part);
                    part.initialize(AbstractTaskEditorPage.this);
                    parentPart.addSubPart(subPath, part);
                }
            });
        }
    }

    public void dispose() {
        if (this.textSupport != null) {
            this.textSupport.dispose();
        }
        if (this.attributeEditorToolkit != null) {
            this.attributeEditorToolkit.dispose();
        }
        TasksUiPlugin.getTaskDataManager().removeListener(this.TASK_DATA_LISTENER);
        super.dispose();
    }

    public void doAction(String actionId) {
        if (this.findSupport != null && actionId.equals(ActionFactory.FIND.getId())) {
            this.findSupport.toggleFind();
        }
        CommonTextSupport.doAction((String)actionId, (Control)EditorUtil.getFocusControl((IFormPage)this));
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.isDirty()) {
            return;
        }
        this.getManagedForm().commit(true);
        if (this.model.isDirty()) {
            try {
                this.model.save(monitor);
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Error saving task", (Throwable)e));
                this.getTaskEditor().setMessage(Messages.AbstractTaskEditorPage_Could_not_save_task, 3, (IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent event) {
                        TasksUiInternal.displayStatus(Messages.AbstractTaskEditorPage_Save_failed, e.getStatus());
                    }
                });
            }
        }
        if (this.getTask().getSynchronizationState() == ITask.SynchronizationState.OUTGOING_NEW) {
            final String summary = this.connector.getTaskMapping(this.model.getTaskData()).getSummary();
            try {
                TasksUiPlugin.getTaskList().run(new ITaskListRunnable(){

                    public void execute(IProgressMonitor monitor) throws CoreException {
                        AbstractTaskEditorPage.this.task.setSummary(summary);
                    }
                });
                TasksUiPlugin.getTaskList().notifyElementChanged((IRepositoryElement)this.task);
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to set summary for task \"" + this.task + "\"", (Throwable)e));
            }
        }
        TasksUiPlugin.getTaskList().addTaskIfAbsent(this.task);
        this.updateHeaderMessage();
        this.getManagedForm().dirtyStateChanged();
        this.getTaskEditor().updateHeaderToolBar();
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    public void doSubmit() {
        if (!this.submitEnabled || !this.needsSubmit()) {
            return;
        }
        try {
            this.showEditorBusy(true);
            this.doSave((IProgressMonitor)new NullProgressMonitor());
            TaskAttribute newCommentAttribute = this.getModel().getTaskData().getRoot().getMappedAttribute("task.common.comment.new");
            boolean expandLastComment = newCommentAttribute != null && this.getModel().getChangedAttributes().contains(newCommentAttribute);
            SubmitJob submitJob = TasksUiInternal.getJobFactory().createSubmitTaskJob(this.connector, this.getModel().getTaskRepository(), this.task, this.getModel().getTaskData(), this.getModel().getChangedOldAttributes());
            submitJob.addSubmitJobListener((SubmitJobListener)new SubmitTaskJobListener(this.getAttachContext(), expandLastComment));
            submitJob.schedule();
        }
        catch (RuntimeException e) {
            this.showEditorBusy(false);
            throw e;
        }
        TasksUiPlugin.getTaskList().addTaskIfAbsent(this.task);
    }

    @Override
    public void fillToolBar(IToolBarManager toolBarManager) {
        TaskRepository taskRepository;
        TaskRepository taskRepository2 = taskRepository = this.model != null ? this.getModel().getTaskRepository() : null;
        if (this.taskData == null) {
            this.synchronizeEditorAction = new SynchronizeEditorAction();
            this.synchronizeEditorAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getTaskEditor()));
            toolBarManager.appendToGroup("repository", (IAction)this.synchronizeEditorAction);
        } else {
            if (this.taskData.isNew()) {
                DeleteTaskEditorAction deleteAction = new DeleteTaskEditorAction(this.getTask());
                deleteAction.setImageDescriptor(CommonImages.CLEAR);
                toolBarManager.appendToGroup("new", (IAction)deleteAction);
            } else if (taskRepository != null) {
                String historyUrl;
                AbstractRepositoryConnectorUi connectorUi;
                ClearOutgoingAction clearOutgoingAction = new ClearOutgoingAction(Collections.singletonList(this.task));
                clearOutgoingAction.setTaskEditorPage(this);
                if (clearOutgoingAction.isEnabled()) {
                    toolBarManager.appendToGroup("new", (IAction)clearOutgoingAction);
                }
                if (this.task.getSynchronizationState() != ITask.SynchronizationState.OUTGOING_NEW) {
                    this.synchronizeEditorAction = new SynchronizeEditorAction();
                    this.synchronizeEditorAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getTaskEditor()));
                    toolBarManager.appendToGroup("repository", (IAction)this.synchronizeEditorAction);
                }
                NewSubTaskAction newSubTaskAction = new NewSubTaskAction();
                newSubTaskAction.selectionChanged((IAction)newSubTaskAction, (ISelection)new StructuredSelection((Object)this.task));
                if (newSubTaskAction.isEnabled()) {
                    toolBarManager.appendToGroup("new", (IAction)newSubTaskAction);
                }
                if ((connectorUi = TasksUiPlugin.getConnectorUi(this.taskData.getConnectorKind())) != null && (historyUrl = connectorUi.getTaskHistoryUrl(taskRepository, this.task)) != null) {
                    final Action historyAction = new Action(){

                        public void run() {
                            TasksUiUtil.openUrl(historyUrl);
                        }
                    };
                    historyAction.setText(Messages.AbstractTaskEditorPage_History);
                    historyAction.setImageDescriptor(TasksUiImages.TASK_REPOSITORY_HISTORY);
                    historyAction.setToolTipText(Messages.AbstractTaskEditorPage_History);
                    if (this.getEditor().openWithBrowserAction != null) {
                        this.getEditor().openWithBrowserAction.setMenuCreator(new MenuCreator(this){

                            @Override
                            protected void initialize(MenuManager menuManager) {
                                OpenWithBrowserAction openWithBrowserAction = new OpenWithBrowserAction();
                                openWithBrowserAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)task));
                                menuManager.add((IAction)openWithBrowserAction);
                                menuManager.add((IContributionItem)new Separator());
                                menuManager.add((IAction)historyAction);
                            }
                        });
                    } else {
                        toolBarManager.prependToGroup("open", (IAction)historyAction);
                    }
                }
            }
            if (this.needsSubmitButton()) {
                ToolBarButtonContribution submitButtonContribution = new ToolBarButtonContribution("org.eclipse.mylyn.tasks.toolbars.submit"){

                    @Override
                    protected Control createButton(Composite composite) {
                        AbstractTaskEditorPage.this.submitButton = new Button(composite, 0x800000);
                        AbstractTaskEditorPage.this.submitButton.setText(String.valueOf(Messages.TaskEditorActionPart_Submit) + " ");
                        AbstractTaskEditorPage.this.submitButton.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.REPOSITORY_SUBMIT));
                        AbstractTaskEditorPage.this.submitButton.setBackground(null);
                        AbstractTaskEditorPage.this.submitButton.addListener(13, new Listener(){

                            public void handleEvent(Event e) {
                                AbstractTaskEditorPage.this.doSubmit();
                            }
                        });
                        return AbstractTaskEditorPage.this.submitButton;
                    }
                };
                submitButtonContribution.marginLeft = 10;
                toolBarManager.add((IContributionItem)submitButtonContribution);
            }
            if (this.findSupport != null) {
                this.findSupport.addFindAction(toolBarManager);
            }
        }
    }

    protected void fireSelectionChanged(ISelection selection) {
        Object[] listeners;
        final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] objectArray = listeners = this.selectionChangedListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            final ISelectionChangedListener l = (ISelectionChangedListener)listener;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++n2;
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContentOutlinePage.class) {
            this.updateOutlinePage();
            return this.outlinePage;
        }
        if (adapter == CommonTextSupport.class) {
            return this.textSupport;
        }
        return super.getAdapter(adapter);
    }

    private void updateOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = new TaskEditorOutlinePage();
            this.outlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ISelection selection = event.getSelection();
                    if (selection instanceof StructuredSelection) {
                        Object select = ((StructuredSelection)selection).getFirstElement();
                        AbstractTaskEditorPage.this.selectReveal(select);
                        AbstractTaskEditorPage.this.getEditor().setActivePage(AbstractTaskEditorPage.this.getId());
                    }
                }
            });
        }
        if (this.getModel() != null) {
            TaskEditorOutlineNode node = TaskEditorOutlineNode.parse(this.getModel().getTaskData(), false);
            this.outlinePage.setInput(this.getTaskRepository(), node);
        } else {
            this.outlinePage.setInput(null, null);
        }
    }

    private boolean getAttachContext() {
        AbstractTaskEditorPart actionPart = this.getPart(ID_PART_ACTIONS);
        if (actionPart instanceof TaskEditorActionPart) {
            return ((TaskEditorActionPart)actionPart).getAttachContext();
        }
        return false;
    }

    public AttributeEditorFactory getAttributeEditorFactory() {
        return this.attributeEditorFactory;
    }

    public AttributeEditorToolkit getAttributeEditorToolkit() {
        return this.attributeEditorToolkit;
    }

    public AbstractRepositoryConnector getConnector() {
        return this.connector;
    }

    public String getConnectorKind() {
        return this.connectorKind;
    }

    public Composite getEditorComposite() {
        return this.editorComposite;
    }

    public TaskDataModel getModel() {
        return this.model;
    }

    public AbstractTaskEditorPart getPart(String partId) {
        Assert.isNotNull((Object)partId);
        if (this.getManagedForm() != null) {
            IFormPart[] iFormPartArray = this.getManagedForm().getParts();
            int n = iFormPartArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractTaskEditorPart taskEditorPart;
                IFormPart part = iFormPartArray[n2];
                if (part instanceof AbstractTaskEditorPart && partId.equals((taskEditorPart = (AbstractTaskEditorPart)part).getPartId())) {
                    return taskEditorPart;
                }
                ++n2;
            }
        }
        return null;
    }

    public ISelection getSelection() {
        return this.lastSelection;
    }

    public ITask getTask() {
        return this.task;
    }

    public TaskEditor getTaskEditor() {
        return this.getEditor();
    }

    public TaskRepository getTaskRepository() {
        return this.getModel().getTaskRepository();
    }

    protected void handleTaskSubmitted(SubmitJobEvent event) {
        IStatus status = event.getJob().getStatus();
        if (status != null && status.getSeverity() != 8) {
            this.handleSubmitError(event.getJob());
        }
    }

    private void handleSubmitError(SubmitJob job) {
        if (this.form != null && !this.form.isDisposed()) {
            final IStatus status = job.getStatus();
            String message = null;
            if (status.getCode() == 9) {
                TasksUiInternal.displayStatus(Messages.AbstractTaskEditorPage_Comment_required, status);
                AbstractTaskEditorPart newCommentPart = this.getPart(ID_PART_NEW_COMMENT);
                if (newCommentPart != null) {
                    newCommentPart.setFocus();
                }
                return;
            }
            if (status.getCode() == 3) {
                if (TasksUiUtil.openEditRepositoryWizard(this.getTaskRepository()) == 0) {
                    this.submitEnabled = true;
                    this.doSubmit();
                    return;
                }
                message = this.getMessageFromStatus(status);
            } else {
                message = status.getCode() == 5 ? ERROR_NOCONNECTIVITY : this.getMessageFromStatus(status);
            }
            this.getTaskEditor().setMessage(message, 3, (IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    TasksUiInternal.displayStatus(Messages.AbstractTaskEditorPage_Submit_failed, status);
                }
            });
        }
    }

    private String getMessageFromStatus(IStatus status) {
        String message = status.getMessage().length() > 0 ? (status.getMessage().length() < 256 ? String.valueOf(Messages.AbstractTaskEditorPage_Submit_failed_) + status.getMessage() : String.valueOf(Messages.AbstractTaskEditorPage_Submit_failed_) + status.getMessage().substring(0, 256) + "...") : Messages.AbstractTaskEditorPage_Submit_failed;
        return message.replaceAll("\n", " ").replaceAll("\r", " ");
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        TaskEditorInput taskEditorInput = (TaskEditorInput)input;
        this.task = taskEditorInput.getTask();
        this.defaultSelection = new StructuredSelection((Object)this.task);
        this.lastSelection = this.defaultSelection;
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.textSupport = new CommonTextSupport(handlerService);
        this.textSupport.setSelectionChangedListener((ISelectionChangedListener)this);
        this.createFindSupport();
        this.initModel(taskEditorInput);
        TasksUiPlugin.getTaskDataManager().addListener(this.TASK_DATA_LISTENER);
    }

    private void initModel(TaskEditorInput input) {
        Assert.isTrue((this.model == null ? 1 : 0) != 0);
        try {
            this.model = this.createModel(input);
            this.connector = TasksUi.getRepositoryManager().getRepositoryConnector(this.getConnectorKind());
            this.setTaskData(this.model.getTaskData());
            this.model.addModelListener(new TaskDataModelListener(){

                public void attributeChanged(TaskDataModelEvent event) {
                    IManagedForm form = AbstractTaskEditorPage.this.getManagedForm();
                    if (form != null && !form.isDirty()) {
                        form.dirtyStateChanged();
                    }
                }
            });
            this.setNeedsAddToCategory(this.model.getTaskData().isNew());
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Error opening task", (Throwable)e));
            this.getTaskEditor().setStatus(Messages.AbstractTaskEditorPage_Error_opening_task, Messages.AbstractTaskEditorPage_Open_failed, e.getStatus());
        }
    }

    private void initializePart(Composite parent, AbstractTaskEditorPart part, Collection<TaskEditorPartDescriptor> descriptors) {
        this.getManagedForm().addPart((IFormPart)part);
        part.initialize(this);
        if (part instanceof AbstractTaskEditorSection) {
            this.createSubParts((AbstractTaskEditorSection)part, descriptors);
        }
        if (parent != null) {
            part.createControl(parent, this.toolkit);
            if (part.getControl() != null) {
                if (ID_PART_ACTIONS.equals(part.getPartId())) {
                    GridDataFactory.fillDefaults().align(4, 4).grab(false, false).applyTo(part.getControl());
                } else if (part.getExpandVertically()) {
                    GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(part.getControl());
                } else {
                    GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo(part.getControl());
                }
                if (ID_PART_COMMENTS.equals(part.getPartId())) {
                    EditorUtil.setMarker((Widget)part.getControl(), TaskEditorOutlineNode.LABEL_COMMENTS);
                } else if (ID_PART_ATTACHMENTS.equals(part.getPartId())) {
                    EditorUtil.setMarker((Widget)part.getControl(), TaskEditorOutlineNode.LABEL_ATTACHMENTS);
                }
            }
        }
    }

    protected void createFindSupport() {
        this.findSupport = new TaskEditorFindSupport(this);
    }

    public boolean isDirty() {
        return this.isModelDirty() || this.isFormDirty();
    }

    private boolean isFormDirty() {
        IManagedForm form = this.getManagedForm();
        return form != null && form.isDirty();
    }

    private boolean isModelDirty() {
        TaskDataModel model = this.getModel();
        return model != null && model.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean needsAddToCategory() {
        return this.needsAddToCategory;
    }

    public void reflow() {
        if (this.reflow) {
            try {
                this.form.setRedraw(false);
                Rectangle parentClientArea = this.form.getParent().getClientArea();
                Point formSize = this.form.getSize();
                if (formSize.x != parentClientArea.width) {
                    ScrollBar verticalBar = this.form.getVerticalBar();
                    int verticalBarWidth = verticalBar != null ? verticalBar.getSize().x : 15;
                    this.form.setSize(parentClientArea.width - verticalBarWidth, formSize.y);
                }
                this.form.layout(true, false);
                this.form.reflow(true);
            }
            finally {
                this.form.setRedraw(true);
            }
        }
    }

    @Deprecated
    public void refreshFormContent() {
        this.refresh();
    }

    @Override
    public void refresh() {
        if (this.getManagedForm() == null || this.getManagedForm().getForm().isDisposed()) {
            return;
        }
        try {
            this.showEditorBusy(true);
            boolean hasIncoming = false;
            if (this.getTask() != null) {
                hasIncoming = this.getTask().getSynchronizationState().isIncoming();
            }
            if (this.model != null) {
                this.doSave((IProgressMonitor)new NullProgressMonitor());
                this.refreshInput();
            } else {
                this.initModel(this.getTaskEditor().getTaskEditorInput());
            }
            if (this.taskData != null) {
                try {
                    this.setReflow(false);
                    Menu menu = this.editorComposite.getMenu();
                    CommonUiUtil.setMenu((Composite)this.editorComposite, null);
                    Control[] controlArray = this.editorComposite.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        control.dispose();
                        ++n2;
                    }
                    if (this.focusTracker != null) {
                        this.focusTracker.reset();
                    }
                    this.lastSelection = null;
                    controlArray = this.getManagedForm().getParts();
                    n = controlArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        Control part = controlArray[n2];
                        part.dispose();
                        this.getManagedForm().removePart((IFormPart)part);
                        ++n2;
                    }
                    this.editorComposite.setMenu(menu);
                    this.createFormContentInternal();
                    this.getTaskEditor().setMessage(null, 0);
                    if (hasIncoming) {
                        this.getTaskEditor().setActivePage(this.getId());
                    }
                    this.setSubmitEnabled(true);
                }
                finally {
                    this.setReflow(true);
                }
            }
            this.updateOutlinePage();
            this.updateHeaderMessage();
            this.getManagedForm().dirtyStateChanged();
            this.getTaskEditor().updateHeaderToolBar();
        }
        finally {
            this.showEditorBusy(false);
        }
        this.reflow();
    }

    private void refreshInput() {
        try {
            try {
                this.refreshDisabled = true;
                this.model.refresh(null);
            }
            catch (CoreException e) {
                this.getTaskEditor().setMessage(String.valueOf(Messages.AbstractTaskEditorPage_Failed_to_read_task_data_) + e.getMessage(), 3);
                this.taskData = null;
                this.refreshDisabled = false;
                return;
            }
        }
        finally {
            this.refreshDisabled = false;
        }
        this.setTaskData(this.model.getTaskData());
    }

    public void registerDefaultDropListener(Control control) {
        if (this.getModel() == null || this.getModel().getTaskData().isNew()) {
            return;
        }
        DropTarget target = new DropTarget(control, 17);
        LocalSelectionTransfer localSelectionTransfer = LocalSelectionTransfer.getTransfer();
        TextTransfer textTransfer = TextTransfer.getInstance();
        FileTransfer fileTransfer = FileTransfer.getInstance();
        Transfer[] types = new Transfer[]{localSelectionTransfer, textTransfer, fileTransfer};
        target.setTransfer(types);
        if (this.defaultDropListener == null) {
            this.defaultDropListener = new TaskAttachmentDropListener(this);
        }
        target.addDropListener((DropTargetListener)this.defaultDropListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void selectionChanged(Object element) {
        this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)new StructuredSelection(element)));
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof TextSelection) {
            ((TaskEditorActionContributor)this.getEditorSite().getActionBarContributor()).updateSelectableActions(event.getSelection());
            return;
        }
        if (selection.isEmpty()) {
            selection = this.defaultSelection;
            ((TaskEditorActionContributor)this.getEditorSite().getActionBarContributor()).forceActionsEnabled();
        }
        if (!selection.equals(this.lastSelection)) {
            this.lastSelection = selection;
            this.fireSelectionChanged(this.lastSelection);
            this.getSite().getSelectionProvider().setSelection(selection);
        }
    }

    public void setFocus() {
        if (this.focusTracker != null && this.focusTracker.setFocus()) {
            return;
        }
        IFormPart[] parts = this.getManagedForm().getParts();
        if (parts.length > 0) {
            parts[0].setFocus();
            return;
        }
        super.setFocus();
    }

    public void setNeedsAddToCategory(boolean needsAddToCategory) {
        this.needsAddToCategory = needsAddToCategory;
    }

    public void setReflow(boolean reflow) {
        this.reflow = reflow;
        this.form.setRedraw(reflow);
    }

    public void setSelection(ISelection selection) {
        IFormPart[] parts;
        IFormPart[] iFormPartArray = parts = this.getManagedForm().getParts();
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPart formPart = iFormPartArray[n2];
            if (formPart instanceof AbstractTaskEditorPart && ((AbstractTaskEditorPart)formPart).setSelection(selection)) {
                this.lastSelection = selection;
                return;
            }
            ++n2;
        }
    }

    private void setSubmitEnabled(boolean enabled) {
        AbstractTaskEditorPart actionPart = this.getPart(ID_PART_ACTIONS);
        if (actionPart instanceof TaskEditorActionPart) {
            ((TaskEditorActionPart)actionPart).setSubmitEnabled(enabled);
        }
        if (this.submitButton != null && !this.submitButton.isDisposed()) {
            this.submitButton.setEnabled(enabled);
        }
        this.submitEnabled = enabled;
    }

    private void setTaskData(TaskData taskData) {
        this.taskData = taskData;
    }

    public void showBusy(boolean busy) {
        if (this.getManagedForm() != null && !this.getManagedForm().getForm().isDisposed() && this.busy != busy) {
            this.setSubmitEnabled(!busy);
            CommonUiUtil.setEnabled((Composite)this.editorComposite, (!busy ? 1 : 0) != 0);
            this.busy = busy;
        }
    }

    public void showEditorBusy(boolean busy) {
        this.getTaskEditor().showBusy(busy);
        this.refreshDisabled = busy;
    }

    private void updateHeaderMessage() {
        if (this.taskData == null) {
            this.getTaskEditor().setMessage(Messages.AbstractTaskEditorPage_Synchronize_to_retrieve_task_data, 2, (IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    if (AbstractTaskEditorPage.this.synchronizeEditorAction != null) {
                        AbstractTaskEditorPage.this.synchronizeEditorAction.run();
                    }
                }
            });
        }
        if (this.getTaskEditor().getMessage() == null && TasksUiPlugin.getTaskList().getTask(this.task.getRepositoryUrl(), this.task.getTaskId()) == null) {
            this.getTaskEditor().setMessage(Messages.AbstractTaskEditorPage_Add_task_to_tasklist, 1, (IHyperlinkListener)new NotInTaskListListener());
        }
    }

    public Control getPartControl() {
        return this.partControl != null ? this.partControl : super.getPartControl();
    }

    private boolean needsFooter() {
        return this.needsFooter;
    }

    private void setNeedsFooter(boolean needsFooter) {
        this.needsFooter = needsFooter;
    }

    private void createFooterContent(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
    }

    public boolean needsSubmit() {
        return this.needsSubmit;
    }

    public void setNeedsSubmit(boolean needsSubmit) {
        this.needsSubmit = needsSubmit;
    }

    public boolean needsSubmitButton() {
        return this.needsSubmitButton;
    }

    public void setNeedsSubmitButton(boolean needsSubmitButton) {
        this.needsSubmitButton = needsSubmitButton;
    }

    public boolean needsPrivateSection() {
        return this.needsPrivateSection;
    }

    public void setNeedsPrivateSection(boolean needsPrivateSection) {
        this.needsPrivateSection = needsPrivateSection;
    }

    public boolean selectReveal(Object object) {
        if (object instanceof TaskEditorOutlineNode) {
            TaskEditorOutlineNode node = (TaskEditorOutlineNode)object;
            TaskAttribute attribute = node.getData();
            if (attribute != null) {
                super.selectReveal((Object)attribute.getId());
            } else {
                TaskRelation taskRelation = node.getTaskRelation();
                TaskRepository taskRepository = node.getTaskRepository();
                if (taskRelation != null && taskRepository != null) {
                    String taskID = taskRelation.getTaskId();
                    TasksUiUtil.openTask(taskRepository, taskID);
                } else {
                    EditorUtil.reveal(this.getManagedForm().getForm(), node.getLabel());
                }
                return true;
            }
        }
        return super.selectReveal(object);
    }

    void expandLastComment() {
        if (this.getManagedForm() == null || this.getManagedForm().getForm().isDisposed()) {
            return;
        }
        if (this.taskData == null) {
            return;
        }
        List commentAttributes = this.taskData.getAttributeMapper().getAttributesByType(this.taskData, "comment");
        if (commentAttributes.size() > 0) {
            this.selectReveal(((TaskAttribute)commentAttributes.get(commentAttributes.size() - 1)).getId());
        }
    }

    private class MenuCreator
    implements IMenuCreator {
        private MenuManager menuManager;
        private Menu menu;

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
                this.menu = null;
            }
            if (this.menuManager != null) {
                this.menuManager.dispose();
                this.menuManager = null;
            }
        }

        public Menu getMenu(Control parent) {
            if (this.menuManager == null) {
                this.menuManager = new MenuManager();
                this.initialize(this.menuManager);
            }
            return this.menuManager.createContextMenu(parent);
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        protected void initialize(MenuManager menuManager) {
        }
    }

    private class NotInTaskListListener
    extends HyperlinkAdapter
    implements ITaskListChangeListener,
    IDisposable {
        public NotInTaskListListener() {
            TasksUiPlugin.getTaskList().addChangeListener((ITaskListChangeListener)this);
        }

        public void linkActivated(HyperlinkEvent e) {
            TasksUiPlugin.getTaskList().addTaskIfAbsent(AbstractTaskEditorPage.this.task);
            AbstractTaskEditorPage.this.getTaskEditor().setMessage(null, 0);
        }

        public void containersChanged(Set<TaskContainerDelta> containers) {
            for (TaskContainerDelta taskContainerDelta : containers) {
                if (!AbstractTaskEditorPage.this.task.equals(taskContainerDelta.getElement()) || !taskContainerDelta.getKind().equals((Object)TaskContainerDelta.Kind.ADDED)) continue;
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractTaskEditorPage.this.getTaskEditor().setMessage(null, 0);
                    }
                });
            }
        }

        public void dispose() {
            TasksUiPlugin.getTaskList().removeChangeListener((ITaskListChangeListener)this);
        }
    }

    private final class ParentResizeHandler
    implements Listener {
        private int generation;

        private ParentResizeHandler() {
        }

        public void handleEvent(Event event) {
            ++this.generation;
            Display.getCurrent().timerExec(300, new Runnable(){
                int scheduledGeneration;
                {
                    this.scheduledGeneration = ParentResizeHandler.this.generation;
                }

                @Override
                public void run() {
                    if (AbstractTaskEditorPage.this.getManagedForm().getForm().isDisposed()) {
                        return;
                    }
                    if (this.scheduledGeneration == ParentResizeHandler.this.generation) {
                        AbstractTaskEditorPage.this.getManagedForm().reflow(true);
                    }
                }
            });
        }
    }

    private class SubmitTaskJobListener
    extends SubmitJobListener {
        private final boolean attachContext;
        private final boolean expandLastComment;

        public SubmitTaskJobListener(boolean attachContext, boolean expandLastComment) {
            this.attachContext = attachContext;
            this.expandLastComment = expandLastComment;
        }

        public void done(SubmitJobEvent event) {
            final SubmitJob job = event.getJob();
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                private void addTask(ITask newTask) {
                    AbstractTaskCategory parent = null;
                    AbstractTaskEditorPart actionPart = AbstractTaskEditorPage.this.getPart(AbstractTaskEditorPage.ID_PART_ACTIONS);
                    if (actionPart instanceof TaskEditorActionPart) {
                        parent = ((TaskEditorActionPart)actionPart).getCategory();
                    }
                    TasksUiInternal.getTaskList().addTask(newTask, (AbstractTaskContainer)parent);
                }

                @Override
                public void run() {
                    try {
                        if (job.getStatus() == null) {
                            TasksUiInternal.synchronizeRepositoryInBackground(AbstractTaskEditorPage.this.getTaskRepository());
                            if (job.getTask().equals(AbstractTaskEditorPage.this.getTask())) {
                                AbstractTaskEditorPage.this.refresh();
                            } else {
                                ITask oldTask = AbstractTaskEditorPage.this.getTask();
                                ITask newTask = job.getTask();
                                this.addTask(newTask);
                                TaskMigrator migrator = new TaskMigrator(oldTask);
                                migrator.setDelete(true);
                                migrator.setEditor(AbstractTaskEditorPage.this.getTaskEditor());
                                migrator.setMigrateDueDate(!AbstractTaskEditorPage.this.connector.hasRepositoryDueDate(AbstractTaskEditorPage.this.getTaskRepository(), newTask, AbstractTaskEditorPage.this.taskData));
                                migrator.execute(newTask);
                            }
                            if (SubmitTaskJobListener.this.expandLastComment) {
                                AbstractTaskEditorPage.this.expandLastComment();
                            }
                        }
                        AbstractTaskEditorPage.this.handleTaskSubmitted(new SubmitJobEvent(job));
                    }
                    finally {
                        AbstractTaskEditorPage.this.showEditorBusy(false);
                    }
                }
            });
        }

        public void taskSubmitted(SubmitJobEvent event, IProgressMonitor monitor) throws CoreException {
            if (!AbstractTaskEditorPage.this.getModel().getTaskData().isNew() && this.attachContext) {
                TaskData taskData = AbstractTaskEditorPage.this.getModel().getTaskData();
                TaskAttribute taskAttribute = null;
                if (taskData != null) {
                    taskAttribute = taskData.getRoot().createMappedAttribute("task.common.new.attachment");
                }
                AttachmentUtil.postContext(AbstractTaskEditorPage.this.connector, AbstractTaskEditorPage.this.getModel().getTaskRepository(), AbstractTaskEditorPage.this.task, "", taskAttribute, monitor);
            }
        }

        public void taskSynchronized(SubmitJobEvent event, IProgressMonitor monitor) {
        }
    }
}

