/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.log;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.jpt.common.utility.internal.exception.MultiThreadedExceptionHandlerAdapter;

public class LoggingMultiThreadedExceptionHandler
extends MultiThreadedExceptionHandlerAdapter {
    private final Logger logger;
    private final Level level;
    private final String message;

    public LoggingMultiThreadedExceptionHandler() {
        this(Logger.getLogger(null));
    }

    public LoggingMultiThreadedExceptionHandler(Logger logger) {
        this(logger, Level.SEVERE);
    }

    public LoggingMultiThreadedExceptionHandler(Logger logger, Level level) {
        this(logger, level, "Unexpected Exception");
    }

    public LoggingMultiThreadedExceptionHandler(Logger logger, Level level, String message) {
        if (logger == null || level == null || message == null) {
            throw new NullPointerException();
        }
        this.logger = logger;
        this.level = level;
        this.message = message;
    }

    @Override
    public void handleException(Throwable exception) {
        this.handleException(null, exception);
    }

    @Override
    public void handleException(Thread thread, Throwable exception) {
        LogRecord logRecord = new LogRecord(this.level, this.message);
        logRecord.setParameters(new Object[]{thread == null ? "null" : thread.getName()});
        logRecord.setThrown(exception);
        logRecord.setLoggerName(this.logger.getName());
        logRecord.setResourceBundle(this.logger.getResourceBundle());
        this.logger.log(logRecord);
    }
}

