/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.lissome.file;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.internal.lissome.LissomeFile;
import org.eclipse.emf.cdo.server.internal.lissome.LissomeFileHandle;
import org.eclipse.emf.cdo.server.internal.lissome.LissomeFileOperation;
import org.eclipse.emf.cdo.server.internal.lissome.LissomeStore;
import org.eclipse.emf.cdo.server.internal.lissome.bundle.OM;
import org.eclipse.emf.cdo.server.internal.lissome.optimizer.CommitTransactionTask;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Journal
extends LissomeFile {
    public static final String EXTENSION = "journal";
    public static final byte PACKAGE_UNITS_BLOCK = 1;
    public static final byte COMMIT_TRANSACTION_BLOCK = 2;
    public static final byte CREATE_BRANCH_BLOCK = 3;
    private static final ContextTracer TRACER = new ContextTracer(OM.JOURNAL, Journal.class);
    private static final long serialVersionUID = 1L;
    private static final boolean ZIP_PACKAGE_BYTES = true;
    private Map<String, Long> ePackagePointers = new HashMap<String, Long>();
    private long commitPointer;
    private long newCommitPointer;
    private long packageUnitPointer;
    private long newPackageUnitPointer;
    private CommitTransactionTask commitTransactionTask;
    private final LissomeFileHandle writer = this.openWriter();

    public Journal(LissomeStore store) throws FileNotFoundException {
        super(store, String.valueOf(store.getRepository().getName()) + "." + EXTENSION);
    }

    @Override
    protected LissomeFileHandle openHandle(String mode) {
        try {
            return new LissomeFileHandle(this, mode){

                public CDORevision getRevision(long pointer) {
                    return super.getRevision(-pointer);
                }
            };
        }
        catch (FileNotFoundException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    public void firstStart() {
        try {
            try {
                this.writer.seek(0L);
                this.writer.writeXLong(this.commitPointer);
                this.writer.writeXLong(this.packageUnitPointer);
            }
            catch (IOException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
        }
        finally {
            this.cleanUp();
        }
    }

    public void reStart() {
        try {
            try {
                this.writer.seek(0L);
                this.commitPointer = this.writer.readXLong();
                this.packageUnitPointer = this.writer.readXLong();
            }
            catch (IOException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
        }
        finally {
            this.cleanUp();
        }
    }

    public Collection<InternalCDOPackageUnit> readPackageUnits() {
        LissomeFileHandle reader = this.openReader();
        try {
            ArrayList<InternalCDOPackageUnit> result = new ArrayList<InternalCDOPackageUnit>();
            InternalCDOPackageRegistry packageRegistry = this.getStore().getRepository().getPackageRegistry();
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.setPackageRegistry((EPackage.Registry)packageRegistry);
            long filePointer = this.packageUnitPointer;
            while (filePointer != 0L) {
                reader.seek(filePointer);
                filePointer = reader.readXLong();
                int size = reader.readXInt();
                int i = 0;
                while (i < size) {
                    InternalCDOPackageUnit packageUnit = (InternalCDOPackageUnit)reader.readCDOPackageUnit((ResourceSet)resourceSet);
                    packageUnit.setPackageRegistry(packageRegistry);
                    result.add(packageUnit);
                    long ePackagePointer = reader.readXLong();
                    this.ePackagePointers.put(packageUnit.getID(), ePackagePointer);
                    EPackage ePackage = packageUnit.getTopLevelPackageInfo().getEPackage();
                    this.mapPackage(ePackage, reader);
                    ++i;
                }
            }
            ArrayList<InternalCDOPackageUnit> arrayList = result;
            return arrayList;
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
        finally {
            IOUtil.close((Closeable)((Object)reader));
        }
    }

    public EPackage[] loadPackageUnit(InternalCDOPackageUnit packageUnit) {
        LissomeFileHandle reader = this.openReader();
        try {
            long ePackagePointer = this.ePackagePointers.get(packageUnit.getID());
            reader.seek(ePackagePointer);
            byte[] bytes = reader.readByteArray();
            EPackage ePackage = this.createEPackage(packageUnit, bytes);
            EPackage[] ePackageArray = EMFUtil.getAllPackages((EPackage)ePackage);
            return ePackageArray;
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
        finally {
            IOUtil.close((Closeable)((Object)reader));
        }
    }

    protected void checkMetaObject(ENamedElement element, String name) throws IOException {
        if (!element.getName().equals(name)) {
            throw new IOException("Name '" + name + "' expected: " + element);
        }
    }

    protected void checkListSize(EList<?> list, int size) throws IOException {
        if (list.size() != size) {
            throw new IOException("Size " + size + " expected: " + list);
        }
    }

    protected void mapPackage(EPackage ePackage, LissomeFileHandle reader) throws IOException {
        LissomeStore store = this.getStore();
        this.checkMetaObject((ENamedElement)ePackage, reader.readString());
        store.mapMetaObject(ePackage, reader.readXInt());
        EList eClassifiers = ePackage.getEClassifiers();
        this.checkListSize(eClassifiers, reader.readXInt());
        for (EClassifier eClassifier : eClassifiers) {
            this.checkMetaObject((ENamedElement)eClassifier, reader.readString());
            store.mapMetaObject(eClassifier, reader.readXInt());
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            EList eStructuralFeatures = eClass.getEStructuralFeatures();
            this.checkListSize(eStructuralFeatures, reader.readXInt());
            for (EStructuralFeature eStructuralFeature : eStructuralFeatures) {
                this.checkMetaObject((ENamedElement)eStructuralFeature, reader.readString());
                store.mapMetaObject(eStructuralFeature, reader.readXInt());
            }
        }
        EList eSubpackages = ePackage.getESubpackages();
        this.checkListSize(eSubpackages, reader.readXInt());
        for (EPackage eSubpackage : eSubpackages) {
            this.mapPackage(eSubpackage);
        }
    }

    protected void mapPackage(EPackage ePackage) throws IOException {
        LissomeStore store = this.getStore();
        this.writer.writeString(ePackage.getName());
        this.writer.writeXInt(store.mapMetaObject(ePackage));
        EList eClassifiers = ePackage.getEClassifiers();
        this.writer.writeXInt(eClassifiers.size());
        for (EClassifier eClassifier : eClassifiers) {
            this.writer.writeString(eClassifier.getName());
            this.writer.writeXInt(store.mapMetaObject(eClassifier));
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            EList eStructuralFeatures = eClass.getEStructuralFeatures();
            this.writer.writeXInt(eStructuralFeatures.size());
            for (EStructuralFeature eStructuralFeature : eStructuralFeatures) {
                this.writer.writeString(eStructuralFeature.getName());
                this.writer.writeXInt(store.mapMetaObject(eStructuralFeature));
            }
        }
        EList eSubpackages = ePackage.getESubpackages();
        this.writer.writeXInt(eSubpackages.size());
        for (EPackage eSubpackage : eSubpackages) {
            this.mapPackage(eSubpackage);
        }
    }

    private EPackage createEPackage(InternalCDOPackageUnit packageUnit, byte[] bytes) {
        ResourceSet resourceSet = EMFUtil.newEcoreResourceSet((EPackage.Registry)this.getStore().getRepository().getPackageRegistry());
        return EMFUtil.createEPackage((String)packageUnit.getID(), (byte[])bytes, (boolean)true, (ResourceSet)resourceSet, (boolean)false);
    }

    private byte[] getEPackageBytes(InternalCDOPackageUnit packageUnit) {
        EPackage ePackage = packageUnit.getTopLevelPackageInfo().getEPackage();
        return EMFUtil.getEPackageBytes((EPackage)ePackage, (boolean)true, (EPackage.Registry)this.getStore().getRepository().getPackageRegistry());
    }

    public void writePackageUnits(final InternalCDOPackageUnit[] packageUnits, final OMMonitor monitor) {
        if (TRACER.isEnabled()) {
            TRACER.format("writePackageUnits: {0}", new Object[]{Arrays.asList(packageUnits)});
        }
        monitor.begin((double)packageUnits.length);
        try {
            this.writer.append(new LissomeFileOperation(){

                public void execute(LissomeFileHandle writer) throws IOException {
                    writer.writeByte(1);
                    Journal.this.writePackageUnits(writer, packageUnits, monitor);
                }
            });
        }
        finally {
            monitor.done();
        }
    }

    protected void writePackageUnits(LissomeFileHandle writer, InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) throws IOException {
        long ePackagePointer;
        InternalCDOPackageUnit packageUnit;
        writer.writeXInt(packageUnits.length);
        InternalCDOPackageUnit[] internalCDOPackageUnitArray = packageUnits;
        int n = packageUnits.length;
        int n2 = 0;
        while (n2 < n) {
            packageUnit = internalCDOPackageUnitArray[n2];
            ePackagePointer = writer.getFilePointer();
            this.ePackagePointers.put(packageUnit.getID(), ePackagePointer);
            byte[] bytes = this.getEPackageBytes(packageUnit);
            writer.writeByteArray(bytes);
            monitor.worked(3.0);
            ++n2;
        }
        this.newPackageUnitPointer = writer.getFilePointer();
        writer.writeXLong(this.packageUnitPointer);
        writer.writeXInt(packageUnits.length);
        internalCDOPackageUnitArray = packageUnits;
        n = packageUnits.length;
        n2 = 0;
        while (n2 < n) {
            packageUnit = internalCDOPackageUnitArray[n2];
            writer.writeCDOPackageUnit((CDOPackageUnit)packageUnit, false);
            ePackagePointer = this.ePackagePointers.get(packageUnit.getID());
            writer.writeXLong(ePackagePointer);
            EPackage ePackage = packageUnit.getTopLevelPackageInfo().getEPackage();
            this.mapPackage(ePackage);
            monitor.worked(1.0);
            ++n2;
        }
    }

    public long createBranch(final int branchID, final InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        if (TRACER.isEnabled()) {
            TRACER.format("createBranch: {0}, {1}", new Object[]{branchID, branchInfo});
        }
        return this.writer.append(new LissomeFileOperation(){

            public void execute(LissomeFileHandle writer) throws IOException {
                writer.writeByte(3);
                writer.writeXInt(branchID);
                writer.writeString(branchInfo.getName());
                writer.writeXInt(branchInfo.getBaseBranchID());
                writer.writeXLong(branchInfo.getBaseTimeStamp());
            }
        });
    }

    public void write(final InternalCommitContext context, final OMMonitor monitor) {
        if (TRACER.isEnabled()) {
            TRACER.format("write: {0}", new Object[]{context});
        }
        try {
            final CDOBranchPoint branchPoint = context.getBranchPoint();
            final long previousTimeStamp = context.getPreviousTimeStamp();
            final String userID = context.getUserID();
            final String commitComment = context.getCommitComment();
            final InternalCDOPackageUnit[] newPackageUnits = context.getNewPackageUnits();
            final InternalCDORevision[] newObjects = context.getNewObjects();
            final CDOID[] detachedObjects = context.getDetachedObjects();
            final Map detachedObjectTypes = context.getDetachedObjectTypes();
            final CDOBranchVersion[] detachedObjectVersions = context.getDetachedObjectVersions();
            final InternalCDORevisionDelta[] dirtyObjectDeltas = context.getDirtyObjectDeltas();
            int revisionWork = detachedObjects.length + 3 * newObjects.length + 2 * dirtyObjectDeltas.length;
            monitor.begin((double)(1 + 4 * newPackageUnits.length + revisionWork));
            this.commitTransactionTask = new CommitTransactionTask(context);
            this.newCommitPointer = this.writer.append(new LissomeFileOperation(){

                public void execute(LissomeFileHandle writer) throws IOException {
                    writer.writeByte(2);
                    writer.writeXLong(Journal.this.commitPointer);
                    writer.writeCDOBranchPoint(branchPoint);
                    writer.writeXLong(previousTimeStamp);
                    writer.writeString(userID);
                    writer.writeString(commitComment);
                    monitor.worked();
                    if (newPackageUnits.length != 0) {
                        Journal.this.writePackageUnits(writer, newPackageUnits, monitor);
                    }
                    InternalCDORevision[] detachedRevisions = null;
                    if (detachedObjects.length != 0 && detachedObjectTypes != null && detachedObjectVersions != null) {
                        detachedRevisions = new InternalCDORevision[detachedObjects.length];
                        Journal.this.commitTransactionTask.setDetachedRevisions(detachedRevisions);
                    }
                    CDOBranch transactionBranch = branchPoint.getBranch();
                    long timeStamp = branchPoint.getTimeStamp();
                    writer.writeBoolean(detachedObjectTypes != null);
                    writer.writeBoolean(detachedObjectVersions != null);
                    writer.writeXInt(detachedObjects.length);
                    int i = 0;
                    while (i < detachedObjects.length) {
                        int version;
                        CDOBranchVersion branchVersion;
                        CDOID id = detachedObjects[i];
                        EClass eClass = detachedObjectTypes != null ? (EClass)detachedObjectTypes.get(id) : null;
                        CDOBranchVersion cDOBranchVersion = branchVersion = detachedObjectVersions != null ? detachedObjectVersions[i] : null;
                        if (detachedRevisions != null) {
                            version = branchVersion.getBranch() == transactionBranch ? branchVersion.getVersion() + 1 : 1;
                            detachedRevisions[i] = new DetachedCDORevision(eClass, id, transactionBranch, version, timeStamp);
                        }
                        if (eClass != null) {
                            int cid = Journal.this.getStore().getMetaID(eClass);
                            writer.writeXInt(cid);
                        }
                        if (branchVersion != null) {
                            version = branchVersion.getVersion();
                            if (branchVersion.getBranch() == transactionBranch) {
                                writer.writeXInt(version);
                            } else {
                                writer.writeXInt(-version);
                                writer.writeCDOBranch(branchVersion.getBranch());
                            }
                        }
                        monitor.worked();
                        ++i;
                    }
                    Map<CDORevision, Long> newObjectPointers = Journal.this.commitTransactionTask.getNewObjectPointers();
                    writer.writeXInt(newObjects.length);
                    InternalCDORevision[] version = newObjects;
                    int branchVersion = newObjects.length;
                    int eClass = 0;
                    while (eClass < branchVersion) {
                        InternalCDORevision revision = version[eClass];
                        long pointer = writer.getFilePointer();
                        newObjectPointers.put((CDORevision)revision, pointer);
                        writer.writeCDORevision((CDORevision)revision, -1);
                        monitor.worked();
                        ++eClass;
                    }
                    writer.writeXInt(dirtyObjectDeltas.length);
                    version = dirtyObjectDeltas;
                    branchVersion = dirtyObjectDeltas.length;
                    eClass = 0;
                    while (eClass < branchVersion) {
                        InternalCDORevision revisionDelta = version[eClass];
                        writer.writeCDORevisionDelta((CDORevisionDelta)revisionDelta);
                        monitor.worked();
                        ++eClass;
                    }
                    ExtendedDataInputStream in = context.getLobs();
                    if (in != null) {
                        int count = in.readInt();
                        int i2 = 0;
                        while (i2 < count) {
                            byte[] id = in.readByteArray();
                            Journal.this.commitTransactionTask.getLobs().add(id);
                            long size = in.readLong();
                            if (size > 0L) {
                                Journal.this.writeBlob(id, size, (InputStream)in);
                            } else {
                                Journal.this.writeClob(id, -size, new InputStreamReader((InputStream)in));
                            }
                            ++i2;
                        }
                    }
                }
            });
            this.commitTransactionTask.setNewCommitPointer(this.newCommitPointer);
        }
        finally {
            monitor.done();
        }
    }

    protected void writeBlob(byte[] id, long size, InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void writeClob(byte[] id, long size, Reader reader) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void removeLob(byte[] id) {
        throw new UnsupportedOperationException();
    }

    public CommitTransactionTask commit(OMMonitor monitor) {
        try {
            if (this.newCommitPointer != this.commitPointer || this.newPackageUnitPointer != this.packageUnitPointer) {
                this.commitPointer = this.newCommitPointer;
                this.packageUnitPointer = this.newPackageUnitPointer;
                this.writer.seek(0L);
                this.writer.writeXLong(this.commitPointer);
                this.writer.writeXLong(this.packageUnitPointer);
            }
            CommitTransactionTask commitTransactionTask = this.commitTransactionTask;
            return commitTransactionTask;
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
        finally {
            this.cleanUp();
        }
    }

    public void rollback(IStoreAccessor.CommitContext commitContext) {
        try {
            List<byte[]> lobs = this.commitTransactionTask.getLobs();
            for (byte[] id : lobs) {
                this.removeLob(id);
            }
        }
        finally {
            this.cleanUp();
        }
    }

    protected void cleanUp() {
        this.commitTransactionTask = null;
        this.newCommitPointer = this.commitPointer;
        this.newPackageUnitPointer = this.packageUnitPointer;
    }

    public CDOCommitInfo readCommitInfo(LissomeFileHandle reader, long pointer) {
        try {
            reader.seek(pointer);
            reader.readByte();
            reader.readXLong();
            CDOBranchPoint branchPoint = reader.readCDOBranchPoint();
            CDOBranch branch = branchPoint.getBranch();
            long timeStamp = branchPoint.getTimeStamp();
            long previousTimeStamp = reader.readXLong();
            String userID = reader.readString();
            String comment = reader.readString();
            InternalCDOCommitInfoManager commitInfoManager = this.getStore().getRepository().getCommitInfoManager();
            return commitInfoManager.createCommitInfo(branch, timeStamp, previousTimeStamp, userID, comment, null, null);
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }
}

