/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.view;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerThread;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils.DebugViewTreeWalker;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcessDMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.visualizer.ui.util.SelectionUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;

public class MulticoreVisualizerSelectionFinder
extends DebugViewTreeWalker {
    protected List<Object> m_selection = null;
    protected Set<Object> m_result = null;

    @Override
    public void dispose() {
        super.dispose();
    }

    public ISelection findSelection(ISelection selection) {
        this.m_selection = SelectionUtils.getSelectedObjects((ISelection)selection);
        this.m_result = new HashSet<Object>();
        this.walk();
        ISelection found = SelectionUtils.toSelection(this.m_result);
        return found;
    }

    @Override
    public boolean processElement(TreePath path) {
        boolean result = true;
        Object element = MulticoreVisualizerSelectionFinder.getElement(path);
        if (element instanceof IDMVMContext) {
            IDMVMContext threadContext;
            IDMContext context = ((IDMVMContext)element).getDMContext();
            int pid = MulticoreVisualizerSelectionFinder.getPID(context);
            int tid = MulticoreVisualizerSelectionFinder.getTID(context);
            if (MulticoreVisualizerSelectionFinder.isThreadContext(context)) {
                for (Object o : this.m_selection) {
                    VisualizerThread thread;
                    if (!(o instanceof VisualizerThread) || (thread = (VisualizerThread)o).getPID() != pid || thread.getGDBTID() != tid) continue;
                    this.m_result.add(element);
                }
            } else if (context instanceof IStack.IFrameDMContext && MulticoreVisualizerSelectionFinder.isThreadFrameZero(context) && this.m_result.contains(threadContext = (IDMVMContext)path.getParentPath().getLastSegment())) {
                this.m_result.remove(threadContext);
                this.m_result.add(element);
            }
        }
        return result;
    }

    public static int getPID(IDMContext context) {
        IMIProcessDMContext processContext = (IMIProcessDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIProcessDMContext.class);
        int pid = processContext == null ? 0 : Integer.parseInt(processContext.getProcId());
        return pid;
    }

    public static int getTID(IDMContext context) {
        int tid;
        block3: {
            IMIExecutionDMContext execContext = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
            tid = 0;
            if (execContext != null) {
                try {
                    tid = Integer.parseInt(execContext.getThreadId());
                }
                catch (NumberFormatException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)("The thread id does not convert to an integer: " + execContext.getThreadId()));
                }
            }
        }
        return tid;
    }

    public static boolean isThreadContext(IDMContext context) {
        return context instanceof IMIExecutionDMContext && context.getParents().length >= 2 && (context.getParents()[0] instanceof IProcesses.IThreadDMContext || context.getParents()[1] instanceof IProcesses.IThreadDMContext);
    }

    public static boolean isThreadFrameZero(IDMContext context) {
        String value = context.toString();
        return value != null && value.endsWith(".frame[0]");
    }
}

