/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.mongodb.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.birt.data.oda.mongodb.impl.MDbConnection;
import org.eclipse.birt.data.oda.mongodb.impl.MDbResultSet;
import org.eclipse.birt.data.oda.mongodb.impl.ParameterMetaData;
import org.eclipse.birt.data.oda.mongodb.internal.impl.QueryModel;
import org.eclipse.birt.data.oda.mongodb.internal.impl.QueryProperties;
import org.eclipse.birt.data.oda.mongodb.nls.Messages;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;

public class MDbQuery
implements IQuery {
    public static final String ODA_DATA_SET_ID = "org.eclipse.birt.data.oda.mongodb.dataSet";
    static UnsupportedOperationException sm_unSupportedOpEx = new UnsupportedOperationException();
    private MDbConnection m_mdbConn;
    private QueryModel m_model;
    private QuerySpecification m_querySpec;
    private int m_maxRows;

    MDbQuery(MDbConnection mdbConn) {
        if (mdbConn == null) {
            throw new NullPointerException("null connection");
        }
        this.m_mdbConn = mdbConn;
    }

    private void resetPreparedQuery() {
        this.m_model = null;
    }

    public void prepare(String queryText) throws OdaException {
        this.resetPreparedQuery();
        QueryProperties queryProps = QueryProperties.deserialize(queryText);
        this.m_model = new QueryModel(queryProps, this.m_mdbConn.getConnectedDB());
        if (this.hasValidModel()) {
            this.m_model.addQuerySpec(this.getSpecification());
        }
    }

    private boolean hasValidModel() {
        return this.m_model != null && this.m_model.isValid();
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void close() throws OdaException {
        this.resetPreparedQuery();
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        if (!this.hasValidModel()) {
            throw new OdaException((Throwable)new IllegalStateException(Messages.mDbQuery_invalidQueryGetMD));
        }
        return this.m_model.getResultSetMetaData();
    }

    public IResultSet executeQuery() throws OdaException {
        if (!this.hasValidModel()) {
            throw new OdaException(Messages.mDbQuery_invalidQueryExecQuery);
        }
        MDbResultSet resultSet = this.m_model.execute();
        resultSet.setMaxRows(this.getMaxRows());
        return resultSet;
    }

    public void setProperty(String name, String value) throws OdaException {
    }

    public void setMaxRows(int max) throws OdaException {
        this.m_maxRows = max;
    }

    public int getMaxRows() throws OdaException {
        return this.m_maxRows;
    }

    public void clearInParameters() throws OdaException {
    }

    public void setInt(String parameterName, int value) throws OdaException {
        throw sm_unSupportedOpEx;
    }

    public void setInt(int parameterId, int value) throws OdaException {
        throw sm_unSupportedOpEx;
    }

    public void setDouble(String parameterName, double value) throws OdaException {
        throw sm_unSupportedOpEx;
    }

    public void setDouble(int parameterId, double value) throws OdaException {
        throw sm_unSupportedOpEx;
    }

    public void setBigDecimal(String parameterName, BigDecimal value) throws OdaException {
        throw sm_unSupportedOpEx;
    }

    public void setBigDecimal(int parameterId, BigDecimal value) throws OdaException {
        throw sm_unSupportedOpEx;
    }

    public void setString(String parameterName, String value) throws OdaException {
        throw sm_unSupportedOpEx;
    }

    public void setString(int parameterId, String value) throws OdaException {
        throw sm_unSupportedOpEx;
    }

    public void setDate(String parameterName, Date value) throws OdaException {
        throw sm_unSupportedOpEx;
    }

    public void setDate(int parameterId, Date value) throws OdaException {
        throw sm_unSupportedOpEx;
    }

    public void setTime(String parameterName, Time value) throws OdaException {
        throw sm_unSupportedOpEx;
    }

    public void setTime(int parameterId, Time value) throws OdaException {
        throw sm_unSupportedOpEx;
    }

    public void setTimestamp(String parameterName, Timestamp value) throws OdaException {
        throw sm_unSupportedOpEx;
    }

    public void setTimestamp(int parameterId, Timestamp value) throws OdaException {
        throw sm_unSupportedOpEx;
    }

    public void setBoolean(String parameterName, boolean value) throws OdaException {
        throw sm_unSupportedOpEx;
    }

    public void setBoolean(int parameterId, boolean value) throws OdaException {
        throw sm_unSupportedOpEx;
    }

    public void setObject(String parameterName, Object value) throws OdaException {
        throw sm_unSupportedOpEx;
    }

    public void setObject(int parameterId, Object value) throws OdaException {
        throw sm_unSupportedOpEx;
    }

    public void setNull(String parameterName) throws OdaException {
        throw sm_unSupportedOpEx;
    }

    public void setNull(int parameterId) throws OdaException {
        throw sm_unSupportedOpEx;
    }

    public int findInParameter(String parameterName) throws OdaException {
        return 0;
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        return new ParameterMetaData();
    }

    public void setSortSpec(SortSpec sortBy) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public SortSpec getSortSpec() throws OdaException {
        return null;
    }

    public void setSpecification(QuerySpecification querySpec) throws OdaException, UnsupportedOperationException {
        this.m_querySpec = querySpec;
    }

    public QuerySpecification getSpecification() {
        return this.m_querySpec;
    }

    public String getEffectiveQueryText() {
        if (!this.hasValidModel()) {
            return "";
        }
        return this.m_model.getEffectiveQueryText();
    }

    public void cancel() throws OdaException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setMetaDataSearchLimit(int searchLimit) {
        if (this.m_model != null) {
            this.m_model.setMetaDataSearchLimit(searchLimit);
        }
    }
}

