/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryContext;

public class QueryContextIteration
extends AbstractCloseableIteration<BindingSet> {
    private final CloseableIteration<? extends BindingSet> iter;
    private final QueryContext queryContext;

    public QueryContextIteration(CloseableIteration<? extends BindingSet> iter, QueryContext queryContext) {
        this.iter = iter;
        this.queryContext = queryContext;
    }

    @Override
    public boolean hasNext() throws QueryEvaluationException {
        if (this.isClosed()) {
            return false;
        }
        this.queryContext.begin();
        try {
            boolean bl = this.iter.hasNext();
            return bl;
        }
        finally {
            this.queryContext.end();
        }
    }

    @Override
    public BindingSet next() throws QueryEvaluationException {
        if (this.isClosed()) {
            throw new NoSuchElementException("The iteration has been closed.");
        }
        this.queryContext.begin();
        try {
            BindingSet bindingSet = (BindingSet)this.iter.next();
            return bindingSet;
        }
        finally {
            this.queryContext.end();
        }
    }

    @Override
    public void remove() throws QueryEvaluationException {
        if (this.isClosed()) {
            throw new IllegalStateException("The iteration has been closed.");
        }
        this.queryContext.begin();
        try {
            this.iter.remove();
        }
        finally {
            this.queryContext.end();
        }
    }

    @Override
    public void handleClose() throws QueryEvaluationException {
        this.queryContext.begin();
        try {
            this.iter.close();
        }
        finally {
            this.queryContext.end();
        }
    }
}

