/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.Declaration;
import org.eclipse.rcptt.ecl.core.Let;
import org.eclipse.rcptt.ecl.core.Val;
import org.eclipse.rcptt.ecl.internal.core.CommandSession;
import org.eclipse.rcptt.ecl.internal.core.DeclarationContainer;
import org.eclipse.rcptt.ecl.runtime.BoxedValues;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.ecl.runtime.ISession;

public class LetService
implements ICommandService {
    @Override
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        if (!(command instanceof Let)) {
            return Status.CANCEL_STATUS;
        }
        Let let = (Let)command;
        DeclarationContainer locals = LetService.getLocals(context);
        boolean inputUsed = false;
        for (Declaration decl : let.getVals()) {
            if (!(decl instanceof Val)) continue;
            Val val = (Val)decl;
            if (val.isInput()) {
                inputUsed = true;
                val.setValue(BoxedValues.box(context.getInput().take(Long.MAX_VALUE)));
            }
            locals.declare(val.getName(), val);
        }
        return context.getSession().execute(let.getBody(), inputUsed ? null : context.getInput(), context.getOutput()).waitFor();
    }

    protected static DeclarationContainer getLocals(IProcess context) {
        ISession session = context.getSession();
        if (!(session instanceof CommandSession)) {
            return null;
        }
        return ((CommandSession)session).getStack().getDeclarations();
    }
}

