/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.model.ReferencedProjectScope;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.wizards.WizardExecutablePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class WizardTestSuitePage
extends WizardExecutablePage {
    private Text nameText;
    private String name;

    public WizardTestSuitePage(IStructuredSelection selection) {
        super(Messages.WizardTestSuitePage_PageName, Messages.WizardTestSuitePage_PageName, selection);
    }

    @Override
    protected void createContent(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(Messages.WizardScenarioPage_NameLabel);
        this.nameText = new Text(parent, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)this.nameText);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardTestSuitePage.this.name = WizardTestSuitePage.this.nameText.getText();
                WizardTestSuitePage.this.validate();
            }
        });
        this.nameText.setFocus();
    }

    @Override
    protected boolean doValidate() {
        if (super.doValidate()) {
            IQ7NamedElement[] elements;
            if (this.name == null || this.name.length() == 0) {
                this.setErrorMessage(Messages.WizardScenarioPage_EmptyNameMsg);
                return false;
            }
            IQ7NamedElement[] iQ7NamedElementArray = elements = Q7SearchCore.findByName((String)this.name, (ISearchScope)new ReferencedProjectScope(RcpttCore.create((IProject)this.getProject())), (IProgressMonitor)new NullProgressMonitor());
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IQ7NamedElement iq7NamedElement = iQ7NamedElementArray[n2];
                if (iq7NamedElement instanceof ITestSuite) {
                    this.setErrorMessage(Messages.WizardTestSuitePage_DuplicateTestCaseMsg);
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public String getTestSuiteName() {
        return this.name;
    }

    @Override
    protected String getDefaultMessage() {
        return Messages.WizardTestSuitePage_DefaultMsg;
    }
}

