/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewDecision;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general.ModelElementProperties;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general.ReviewMeetingProperties;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ReviewDecisionProperties
extends ModelElementProperties {
    protected static final String REVIEW_DECISION_MEETING_ID = "reviewElement.decisionMeeting";
    protected static final PropertyDescriptor REVIEW_DECISION_MEETING_PROPERTY_DESCRIPTOR = new PropertyDescriptor((Object)"reviewElement.decisionMeeting", "Meeting: ");
    protected static final String REVIEW_DECISION_PARTICIPANTS_ID = "reviewElement.decisionParticipants";
    protected static final PropertyDescriptor REVIEW_DECISION_PARTICIPANTS_PROPERTY_DESCRIPTOR = new PropertyDescriptor((Object)"reviewElement.decisionParticipants", "Participants");
    protected static final String REVIEW_EXIT_DECISION_ID = "reviewElement.exitDecision";
    protected static final PropertyDescriptor REVIEW_EXIT_DECISION_PROPERTY_DESCRIPTOR = new PropertyDescriptor((Object)"reviewElement.exitDecision", "Exit Decision: ");
    protected static final String REVIEW_DECISION_TIME_SPENT_ID = "reviewElement.decisionTimeSpent";
    protected static final PropertyDescriptor REVIEW_DECISION_TIME_SPENT_PROPERTY_DESCRIPTOR = new PropertyDescriptor((Object)"reviewElement.decisionTimeSpent", "Time Spent: ");
    private static final IPropertyDescriptor[] DESCRIPTORS = new IPropertyDescriptor[]{REVIEW_DECISION_MEETING_PROPERTY_DESCRIPTOR, REVIEW_DECISION_PARTICIPANTS_PROPERTY_DESCRIPTOR, REVIEW_EXIT_DECISION_PROPERTY_DESCRIPTOR, REVIEW_DECISION_TIME_SPENT_PROPERTY_DESCRIPTOR};

    public ReviewDecisionProperties(R4EUIModelElement aElement) {
        super(aElement);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return DESCRIPTORS;
    }

    public Object getPropertyValue(Object aId) {
        if (this.getElement() != null) {
            R4EReviewDecision decision;
            if (REVIEW_DECISION_MEETING_ID.equals(aId)) {
                return new ReviewMeetingProperties(this.getElement());
            }
            if (REVIEW_DECISION_PARTICIPANTS_ID.equals(aId)) {
                List<R4EParticipant> participants = ((R4EUIReviewBasic)this.getElement()).getParticipants();
                ArrayList<String> decisionParticipantIds = new ArrayList<String>();
                for (R4EParticipant participant : participants) {
                    if (!participant.isIsPartOfDecision()) continue;
                    decisionParticipantIds.add(participant.getId());
                }
                return decisionParticipantIds;
            }
            if (REVIEW_EXIT_DECISION_ID.equals(aId)) {
                R4EReviewDecision decision2 = ((R4EUIReviewBasic)this.getElement()).getReview().getDecision();
                String[] values = R4EUIReviewBasic.getExitDecisionValues();
                if (decision2 != null) {
                    return values[Integer.valueOf(decision2.getValue().getValue())];
                }
                return values[0];
            }
            if (REVIEW_DECISION_TIME_SPENT_ID.equals(aId) && (decision = ((R4EUIReviewBasic)this.getElement()).getReview().getDecision()) != null) {
                return decision.getSpentTime();
            }
        }
        return null;
    }
}

