/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.ISendNotificationInputDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class SendNotificationInputDialog
extends FormDialog
implements ISendNotificationInputDialog {
    private static final String SEND_MAIL_DIALOG_TITLE = "Send Notification";
    private static final String BASIC_PARAMS_HEADER_MSG = "Which notification type do you want to send?";
    private static final String REVIEW_COMPLETION = "Notify of Review Completion";
    private static final String REVIEW_PROGRESS = "Notify of Review Progress";
    private static final String QUESTION = "Ask Question to Participant";
    private static final String MEETING_REQUEST = "Send Meeting Request";
    private static final String UPDATED_REVIEW_ITEMS = "Notify Participants of Updated Items Ready for Review";
    private final ISelection fSource;
    private int fMessageType;
    private Button fItemsUpdatedButton = null;
    private Button fProgressButton = null;
    private Button fCompletionButton = null;
    private Button fQuestionButton = null;
    private Button fMeetingButton = null;

    public SendNotificationInputDialog(Shell aParentShell, ISelection aSource) {
        super(aParentShell);
        this.fSource = aSource;
        this.setBlockOnOpen(true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.fMessageType = -1;
            if (this.fItemsUpdatedButton != null && this.fItemsUpdatedButton.getSelection()) {
                this.fMessageType = 0;
            } else if (this.fProgressButton != null && this.fProgressButton.getSelection()) {
                this.fMessageType = 2;
            } else if (this.fCompletionButton != null && this.fCompletionButton.getSelection()) {
                this.fMessageType = 3;
            } else if (this.fQuestionButton.getSelection()) {
                this.fMessageType = 4;
            } else if (this.fMeetingButton.getSelection()) {
                this.fMessageType = 5;
            }
        } else {
            this.fMessageType = -1;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(SEND_MAIL_DIALOG_TITLE);
        shell.setMinimumSize(400, 300);
    }

    protected void createFormContent(IManagedForm mform) {
        FormToolkit toolkit = mform.getToolkit();
        ScrolledForm sform = mform.getForm();
        sform.setExpandVertical(true);
        Composite composite = sform.getBody();
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        Section basicSection = toolkit.createSection(composite, 450);
        GridData basicSectionGridData = new GridData(4, 4, true, false);
        basicSectionGridData.horizontalSpan = 4;
        basicSection.setLayoutData((Object)basicSectionGridData);
        basicSection.setText("Basic Parameters");
        basicSection.setDescription(BASIC_PARAMS_HEADER_MSG);
        basicSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                SendNotificationInputDialog.this.getShell().setSize(SendNotificationInputDialog.this.getShell().computeSize(-1, -1));
            }
        });
        Composite basicSectionClient = toolkit.createComposite((Composite)basicSection);
        basicSectionClient.setLayout((Layout)layout);
        basicSection.setClient((Control)basicSectionClient);
        this.fCompletionButton = toolkit.createButton(basicSectionClient, REVIEW_COMPLETION, 16);
        this.fCompletionButton.setToolTipText("Send an Automatic Email to Report that we are done reviewing the Utems for the Current Review");
        this.fCompletionButton.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fQuestionButton = toolkit.createButton(basicSectionClient, QUESTION, 16);
        this.fQuestionButton.setToolTipText("Send an Automatic Email to ask a Question about the Selected Element or Text");
        this.fQuestionButton.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fItemsUpdatedButton = toolkit.createButton(basicSectionClient, UPDATED_REVIEW_ITEMS, 16);
        this.fItemsUpdatedButton.setToolTipText("Send an Automatic Email to Report Modifications to the Items to Review for the Current Review");
        this.fItemsUpdatedButton.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fProgressButton = toolkit.createButton(basicSectionClient, REVIEW_PROGRESS, 16);
        this.fProgressButton.setToolTipText("Send an Automatic Email to Report about our Progress Reviewing the Items for the Current Review");
        this.fProgressButton.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fMeetingButton = toolkit.createButton(basicSectionClient, MEETING_REQUEST, 16);
        this.fMeetingButton.setToolTipText("Send a new Meeting Request Notification");
        this.fMeetingButton.setLayoutData((Object)new GridData(1, 1, false, false));
        if (this.fSource instanceof IStructuredSelection) {
            for (Object selection : (IStructuredSelection)this.fSource) {
                if (!(selection instanceof R4EUIReviewBasic)) continue;
                this.fCompletionButton.setEnabled(true);
                this.fQuestionButton.setEnabled(true);
                this.fItemsUpdatedButton.setEnabled(true);
                this.fProgressButton.setEnabled(true);
                this.fMeetingButton.setEnabled(true);
                if (((R4EUIReviewBasic)selection).isUserReviewed()) {
                    this.fCompletionButton.setSelection(true);
                } else {
                    this.fProgressButton.setSelection(true);
                }
                return;
            }
        }
        this.fCompletionButton.setEnabled(false);
        this.fQuestionButton.setEnabled(true);
        this.fQuestionButton.setSelection(true);
        this.fItemsUpdatedButton.setEnabled(false);
        this.fProgressButton.setEnabled(false);
        this.fMeetingButton.setEnabled(false);
    }

    protected boolean isResizable() {
        return true;
    }

    public int getMessageTypeValue() {
        return this.fMessageType;
    }
}

