/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.IFindUserDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.sorters.FindUsersTableViewerSorter;
import org.eclipse.mylyn.reviews.userSearch.query.IQueryUser;
import org.eclipse.mylyn.reviews.userSearch.query.QueryUserFactory;
import org.eclipse.mylyn.reviews.userSearch.userInfo.IUserInfo;
import org.eclipse.mylyn.reviews.userSearch.userInfo.UserInformationFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindUserDialog
extends FormDialog
implements IFindUserDialog {
    private static final int TEXT_FIELD_WIDTH = 300;
    private static final int DIALOG_MIN_WIDTH = 860;
    private static final int DIALOG_MIN_HEIGHT = 550;
    private static final String FIND_USER_DIALOG_TITLE = "Find User";
    private static final String USER_INFORMATION_LABEL = "Search Filters";
    private static final String QUERY_RESULTS_LABEL = "Query Results";
    private static final String OFFICE_LABEL = "Office: ";
    private static final String COMPANY_LABEL = "Company: ";
    private static final String DEPARTMENT_LABEL = "Department: ";
    private static final String CITY_LABEL = "City: ";
    private static final String COUNTRY_LABEL = "Country: ";
    private static final String SEARCH_BUTTON_TEXT = "Search";
    private static final String CLEAR_BUTTON_TEXT = "Clear";
    private static final String NUM_ENTRIES_LABEL = "Number of Entries: ";
    private static final String USERS_ADDED_LABEL = "Users: ";
    private static final String ADD_USER_BUTTON_LABEL = "Add Users";
    protected static final IUserInfo[] NONE = new IUserInfo[0];
    private Group fUserDetailsForm = null;
    private Group fUserQueyResultsForm = null;
    private Group fUserAddedForm = null;
    protected Text fUserIdInputTextField = null;
    protected Text fUserNameInputTextField = null;
    protected Text fUserOfficeInputTextField = null;
    protected Text fUserCompanyInputTextField = null;
    protected Text fUserDepartmentInputTextField = null;
    protected Text fUserCityInputTextField = null;
    protected Text fUserCountryInputTextField = null;
    private Button fSearchButton = null;
    private Button fClearButton = null;
    protected List<IUserInfo> fUsersList = null;
    protected Label fNumEntriesValue = null;
    protected TableViewer fUsersTableViewer;
    protected Text fUserAddedValue = null;
    private Button fAddUserButton;
    private List<IUserInfo> fUserInfos = new ArrayList<IUserInfo>();

    public FindUserDialog(Shell aParentShell) {
        super(aParentShell);
        this.setBlockOnOpen(true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String[] ids;
            String[] stringArray = ids = this.fUserAddedValue.getText().trim().split(";");
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                boolean userFound = false;
                for (IUserInfo userInfo : this.fUserInfos) {
                    if (!id.trim().equalsIgnoreCase(userInfo.getUserId())) continue;
                    userFound = true;
                    break;
                }
                if (!userFound) {
                    ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Cannot add User", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, "User " + id.trim() + " not found in database", null), 4);
                    dialog.open();
                }
                ++n2;
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(FIND_USER_DIALOG_TITLE);
    }

    protected void createFormContent(IManagedForm mform) {
        FormToolkit toolkit = mform.getToolkit();
        ScrolledForm sform = mform.getForm();
        sform.setExpandVertical(true);
        Composite composite = sform.getBody();
        FormLayout layout = new FormLayout();
        layout.marginWidth = 7;
        layout.marginHeight = 3;
        composite.setLayout((Layout)layout);
        this.createSearchFiltersForm(composite, toolkit);
        this.createAddUsersForm(composite, toolkit);
        this.createUsersTableForm(composite, toolkit);
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return bar;
    }

    private void createSearchFiltersForm(Composite aParent, FormToolkit aToolkit) {
        this.fUserDetailsForm = new Group(aParent, 0);
        this.fUserDetailsForm.setText(USER_INFORMATION_LABEL);
        this.fUserDetailsForm.setBackground(this.getShell().getDisplay().getSystemColor(1));
        FormLayout layout = new FormLayout();
        layout.marginWidth = 7;
        layout.marginHeight = 3;
        this.fUserDetailsForm.setLayout((Layout)layout);
        FormData userDetailsFormData = new FormData();
        userDetailsFormData.top = new FormAttachment(0, 0);
        userDetailsFormData.left = new FormAttachment(0, 0);
        userDetailsFormData.right = new FormAttachment(100, 0);
        this.fUserDetailsForm.setLayoutData((Object)userDetailsFormData);
        Label userIdLabel = aToolkit.createLabel((Composite)this.fUserDetailsForm, "Id: ");
        FormData userIdLabelData = new FormData();
        userIdLabelData.top = new FormAttachment(5, 0);
        userIdLabel.setToolTipText("A Tag that Identifies this User");
        userIdLabel.setLayoutData((Object)userIdLabelData);
        this.fUserIdInputTextField = aToolkit.createText((Composite)this.fUserDetailsForm, "", 2052);
        FormData userIdTextData = new FormData();
        userIdTextData.top = new FormAttachment((Control)userIdLabel, 0, 128);
        userIdTextData.left = new FormAttachment((Control)userIdLabel, 60, 131072);
        userIdTextData.width = 300;
        this.fUserIdInputTextField.setToolTipText("A Tag that Identifies this User");
        this.fUserIdInputTextField.setLayoutData((Object)userIdTextData);
        Label userNameLabel = aToolkit.createLabel((Composite)this.fUserDetailsForm, "Name: ");
        FormData userNameLabelData = new FormData();
        userNameLabelData.top = new FormAttachment((Control)userIdLabel, 0, 128);
        userNameLabelData.left = new FormAttachment((Control)this.fUserIdInputTextField, 40, 131072);
        userNameLabel.setToolTipText("The Actual Name of this User");
        userNameLabel.setLayoutData((Object)userNameLabelData);
        this.fUserNameInputTextField = aToolkit.createText((Composite)this.fUserDetailsForm, "", 2052);
        FormData userNameTextData = new FormData();
        userNameTextData.top = new FormAttachment((Control)userNameLabel, 0, 128);
        userNameTextData.left = new FormAttachment((Control)userNameLabel, 25, 131072);
        userNameTextData.width = 300;
        this.fUserNameInputTextField.setToolTipText("The Actual Name of this User");
        this.fUserNameInputTextField.setLayoutData((Object)userNameTextData);
        Label officeLabel = aToolkit.createLabel((Composite)this.fUserDetailsForm, OFFICE_LABEL);
        FormData officeLabelData = new FormData();
        officeLabelData.top = new FormAttachment((Control)this.fUserIdInputTextField, 5, 1024);
        officeLabelData.left = new FormAttachment((Control)userIdLabel, 0, 16384);
        officeLabel.setToolTipText("The location of this User");
        officeLabel.setLayoutData((Object)officeLabelData);
        this.fUserOfficeInputTextField = aToolkit.createText((Composite)this.fUserDetailsForm, "", 2052);
        FormData officeTextData = new FormData();
        officeTextData.top = new FormAttachment((Control)officeLabel, 0, 128);
        officeTextData.left = new FormAttachment((Control)this.fUserIdInputTextField, 0, 16384);
        officeTextData.right = new FormAttachment((Control)this.fUserIdInputTextField, 0, 131072);
        this.fUserOfficeInputTextField.setToolTipText("The location of this User");
        this.fUserOfficeInputTextField.setLayoutData((Object)officeTextData);
        Label companyLabel = aToolkit.createLabel((Composite)this.fUserDetailsForm, COMPANY_LABEL);
        FormData companyLabelData = new FormData();
        companyLabelData.top = new FormAttachment((Control)officeLabel, 0, 128);
        companyLabelData.left = new FormAttachment((Control)userNameLabel, 0, 16384);
        companyLabel.setToolTipText("The Organization this User is Part of");
        companyLabel.setLayoutData((Object)companyLabelData);
        this.fUserCompanyInputTextField = aToolkit.createText((Composite)this.fUserDetailsForm, "", 2052);
        FormData companyTextData = new FormData();
        companyTextData.top = new FormAttachment((Control)officeLabel, 0, 128);
        companyTextData.left = new FormAttachment((Control)this.fUserNameInputTextField, 0, 16384);
        companyTextData.right = new FormAttachment((Control)this.fUserNameInputTextField, 0, 131072);
        this.fUserCompanyInputTextField.setToolTipText("The Organization this User is Part of");
        this.fUserCompanyInputTextField.setLayoutData((Object)companyTextData);
        Label deptLabel = aToolkit.createLabel((Composite)this.fUserDetailsForm, DEPARTMENT_LABEL);
        FormData deptLabelData = new FormData();
        deptLabelData.top = new FormAttachment((Control)this.fUserOfficeInputTextField, 5, 1024);
        deptLabelData.left = new FormAttachment((Control)userIdLabel, 0, 16384);
        deptLabel.setToolTipText("The Department this User is Part of");
        deptLabel.setLayoutData((Object)deptLabelData);
        this.fUserDepartmentInputTextField = aToolkit.createText((Composite)this.fUserDetailsForm, "", 2052);
        FormData deptTextData = new FormData();
        deptTextData.top = new FormAttachment((Control)deptLabel, 0, 128);
        deptTextData.left = new FormAttachment((Control)this.fUserIdInputTextField, 0, 16384);
        deptTextData.right = new FormAttachment((Control)this.fUserIdInputTextField, 0, 131072);
        this.fUserDepartmentInputTextField.setToolTipText("The Department this User is Part of");
        this.fUserDepartmentInputTextField.setLayoutData((Object)deptTextData);
        Label cityLabel = aToolkit.createLabel((Composite)this.fUserDetailsForm, CITY_LABEL);
        FormData cityLabelData = new FormData();
        cityLabelData.top = new FormAttachment((Control)deptLabel, 0, 128);
        cityLabelData.left = new FormAttachment((Control)userNameLabel, 0, 16384);
        cityLabel.setToolTipText("The City where the User's Organization is located");
        cityLabel.setLayoutData((Object)cityLabelData);
        this.fUserCityInputTextField = aToolkit.createText((Composite)this.fUserDetailsForm, "", 2052);
        FormData cityTextData = new FormData();
        cityTextData.top = new FormAttachment((Control)cityLabel, 0, 128);
        cityTextData.left = new FormAttachment((Control)this.fUserNameInputTextField, 0, 16384);
        cityTextData.right = new FormAttachment((Control)this.fUserNameInputTextField, 0, 131072);
        this.fUserCityInputTextField.setToolTipText("The City where the User's Organization is located");
        this.fUserCityInputTextField.setLayoutData((Object)cityTextData);
        Label countryLabel = aToolkit.createLabel((Composite)this.fUserDetailsForm, COUNTRY_LABEL);
        FormData countryLabelData = new FormData();
        countryLabelData.top = new FormAttachment((Control)this.fUserDepartmentInputTextField, 5, 1024);
        countryLabelData.left = new FormAttachment((Control)userIdLabel, 0, 16384);
        countryLabel.setToolTipText("The Country where the User's Organization is located");
        countryLabel.setLayoutData((Object)countryLabelData);
        this.fUserCountryInputTextField = aToolkit.createText((Composite)this.fUserDetailsForm, "", 2052);
        FormData countryTextData = new FormData();
        countryTextData.top = new FormAttachment((Control)countryLabel, 0, 128);
        countryTextData.left = new FormAttachment((Control)this.fUserIdInputTextField, 0, 16384);
        countryTextData.right = new FormAttachment((Control)this.fUserIdInputTextField, 0, 131072);
        this.fUserCountryInputTextField.setToolTipText("The Country where the User's Organization is located");
        this.fUserCountryInputTextField.setLayoutData((Object)countryTextData);
        this.fSearchButton = aToolkit.createButton((Composite)this.fUserDetailsForm, SEARCH_BUTTON_TEXT, 8);
        FormData searchButtonData = new FormData();
        searchButtonData.top = new FormAttachment((Control)countryLabel, 0, 128);
        searchButtonData.left = new FormAttachment((Control)this.fUserNameInputTextField, 0, 16384);
        this.fSearchButton.setToolTipText("Search for Users matching the Criteria(s)");
        this.fSearchButton.setLayoutData((Object)searchButtonData);
        this.fSearchButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FindUserDialog.this.getShell().setCursor(FindUserDialog.this.getShell().getDisplay().getSystemCursor(1));
                FindUserDialog.this.searchUser();
                FindUserDialog.this.updateTableSelections();
                FindUserDialog.this.getShell().setCursor(FindUserDialog.this.getShell().getDisplay().getSystemCursor(0));
            }
        });
        this.fClearButton = aToolkit.createButton((Composite)this.fUserDetailsForm, CLEAR_BUTTON_TEXT, 8);
        FormData clearSearchButtonData = new FormData();
        clearSearchButtonData.top = new FormAttachment((Control)countryLabel, 0, 128);
        clearSearchButtonData.left = new FormAttachment((Control)this.fSearchButton, 10, 131072);
        this.fClearButton.setToolTipText("Clear Serach Results");
        this.fClearButton.setLayoutData((Object)clearSearchButtonData);
        this.fClearButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FindUserDialog.this.clearSearchField();
            }
        });
    }

    private void createUsersTableForm(Composite aParent, FormToolkit aToolkit) {
        this.fUserQueyResultsForm = new Group(aParent, 0);
        this.fUserQueyResultsForm.setText(QUERY_RESULTS_LABEL);
        this.fUserQueyResultsForm.setBackground(this.getShell().getDisplay().getSystemColor(1));
        FormData userFormData = new FormData();
        userFormData.top = new FormAttachment((Control)this.fUserDetailsForm, 10, 1024);
        userFormData.left = new FormAttachment(0);
        userFormData.right = new FormAttachment(100);
        userFormData.bottom = new FormAttachment((Control)this.fUserAddedForm);
        this.fUserQueyResultsForm.setLayoutData((Object)userFormData);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 7;
        layout.marginHeight = 3;
        this.fUserQueyResultsForm.setLayout((Layout)layout);
        Label numEntriesLabel = aToolkit.createLabel((Composite)this.fUserQueyResultsForm, NUM_ENTRIES_LABEL);
        FormData numEntriesLabelData = new FormData();
        numEntriesLabelData.left = new FormAttachment((Control)this.fUserQueyResultsForm, 0, 16384);
        numEntriesLabelData.bottom = new FormAttachment(100);
        numEntriesLabel.setToolTipText("Number of Matches Found");
        numEntriesLabel.setLayoutData((Object)numEntriesLabelData);
        this.fNumEntriesValue = aToolkit.createLabel((Composite)this.fUserQueyResultsForm, "0");
        FormData numEntriesValueData = new FormData();
        numEntriesValueData.left = new FormAttachment((Control)numEntriesLabel, 10, 131072);
        numEntriesValueData.bottom = new FormAttachment(100);
        numEntriesValueData.width = 30;
        this.fNumEntriesValue.setToolTipText("Number of Matches Found");
        this.fNumEntriesValue.setLayoutData((Object)numEntriesValueData);
        this.fUsersTableViewer = new TableViewer((Composite)this.fUserQueyResultsForm, 65538);
        this.fUsersTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                FindUserDialog.this.addUser();
            }
        });
        String[] columnId = UserInformationFactory.getInstance().getAttributeTypes();
        TableColumn nameColumn = null;
        String[] stringArray = columnId;
        int n = columnId.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            nameColumn = new TableColumn(this.fUsersTableViewer.getTable(), 16384);
            nameColumn.setText(element);
            nameColumn.setMoveable(true);
            nameColumn.pack();
            ++n2;
        }
        this.fUsersTableViewer.getTable().setHeaderVisible(true);
        this.fUsersTableViewer.getTable().setLinesVisible(true);
        FormData usersTableData = new FormData();
        usersTableData.top = new FormAttachment(0);
        usersTableData.bottom = new FormAttachment((Control)numEntriesLabel, -5, 128);
        usersTableData.left = new FormAttachment(0);
        usersTableData.right = new FormAttachment(100);
        this.fUsersTableViewer.getControl().setLayoutData((Object)usersTableData);
        FindUsersTableViewerSorter.bind(this.fUsersTableViewer);
        this.attachContentProvider(this.fUsersTableViewer);
        this.attachLabelProvider(this.fUsersTableViewer);
    }

    private void createAddUsersForm(Composite aParent, FormToolkit aToolkit) {
        this.fUserAddedForm = new Group(aParent, 0);
        this.fUserAddedForm.setText(USERS_ADDED_LABEL);
        this.fUserAddedForm.setBackground(this.getShell().getDisplay().getSystemColor(1));
        FormData userFormData = new FormData();
        userFormData.left = new FormAttachment(0);
        userFormData.right = new FormAttachment(100);
        userFormData.bottom = new FormAttachment(100);
        this.fUserAddedForm.setLayoutData((Object)userFormData);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 7;
        layout.marginHeight = 3;
        this.fUserAddedForm.setLayout((Layout)layout);
        this.fAddUserButton = aToolkit.createButton((Composite)this.fUserAddedForm, ADD_USER_BUTTON_LABEL, 0);
        FormData userAddedButtonData = new FormData();
        userAddedButtonData.top = new FormAttachment(5, 0);
        userAddedButtonData.left = new FormAttachment((Control)this.fUserAddedForm, 10, 131072);
        this.fAddUserButton.setToolTipText("Add Selected Users");
        this.fAddUserButton.setLayoutData((Object)userAddedButtonData);
        this.fAddUserButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FindUserDialog.this.addUser();
            }
        });
        this.fUserAddedValue = aToolkit.createText((Composite)this.fUserAddedForm, "", 2048);
        FormData userAddedValueData = new FormData();
        userAddedValueData.top = new FormAttachment((Control)this.fAddUserButton, 0, 128);
        userAddedValueData.bottom = new FormAttachment((Control)this.fAddUserButton, 0, 1024);
        userAddedValueData.left = new FormAttachment((Control)this.fAddUserButton, 10, 131072);
        userAddedValueData.right = new FormAttachment(100);
        this.fUserAddedValue.setToolTipText("Semicolon-separated List of Users to be added");
        this.fUserAddedValue.setLayoutData((Object)userAddedValueData);
        this.fUserAddedValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FindUserDialog.this.fUserAddedValue.getText().length() > 0) {
                    FindUserDialog.this.getButton(0).setEnabled(true);
                } else {
                    FindUserDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        this.fUserAddedValue.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                String[] ids;
                ArrayList<IUserInfo> updatedInfos = new ArrayList<IUserInfo>();
                String[] stringArray = ids = FindUserDialog.this.fUserAddedValue.getText().split(";");
                int n = ids.length;
                int n2 = 0;
                while (n2 < n) {
                    IUserInfo newUserInfo;
                    String id = stringArray[n2];
                    boolean userFound = false;
                    for (IUserInfo userInfo : FindUserDialog.this.fUserInfos) {
                        if (!id.trim().equalsIgnoreCase(userInfo.getUserId())) continue;
                        updatedInfos.add(userInfo);
                        userFound = true;
                        break;
                    }
                    if (!userFound && (newUserInfo = FindUserDialog.this.getUser(id.trim())) != null) {
                        updatedInfos.add(newUserInfo);
                    }
                    ++n2;
                }
                FindUserDialog.this.fUserInfos = updatedInfos;
                FindUserDialog.this.updateTableSelections();
            }
        });
    }

    private void attachLabelProvider(TableViewer aViewer) {
        aViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object aElement, int aColumnIndex) {
                return null;
            }

            public String getColumnText(Object aElement, int aColumnIndex) {
                String[] usrElem = ((IUserInfo)aElement).getAttributeValues();
                return usrElem[aColumnIndex];
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void removeListener(ILabelProviderListener lpl) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }
        });
    }

    private void attachContentProvider(TableViewer aTableViewer) {
        aTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (FindUserDialog.this.fUsersList == null) {
                    return NONE;
                }
                return FindUserDialog.this.fUsersList.toArray(new IUserInfo[0]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer aViewer, Object aOldInput, Object aNewInput) {
                if (aNewInput instanceof IUserInfo[]) {
                    IUserInfo[] usersData = (IUserInfo[])aNewInput;
                    FindUserDialog.this.fNumEntriesValue.setText(Integer.toString(usersData.length));
                }
            }
        });
    }

    protected IUserInfo getUser(String aUserId) {
        if (aUserId != null && !"".equals(aUserId)) {
            IQueryUser query = new QueryUserFactory().getInstance();
            try {
                ArrayList users = query.searchByUserId(aUserId);
                if (users != null && users.size() > 0) {
                    return (IUserInfo)users.get(0);
                }
            }
            catch (NamingException e) {
                R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), e);
            }
            catch (IOException e) {
                R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), e);
            }
        }
        return null;
    }

    protected void searchUser() {
        try {
            if (this.fUserIdInputTextField.getText().equals("") && this.fUserNameInputTextField.getText().equals("") && this.fUserCompanyInputTextField.getText().equals("") && this.fUserOfficeInputTextField.getText().equals("") && this.fUserDepartmentInputTextField.getText().equals("") && this.fUserCountryInputTextField.getText().equals("") && this.fUserCityInputTextField.getText().equals("")) {
                return;
            }
            IQueryUser query = new QueryUserFactory().getInstance();
            this.fUsersList = query.search(this.fUserIdInputTextField.getText().trim(), this.fUserNameInputTextField.getText().trim(), this.fUserCompanyInputTextField.getText().trim(), this.fUserOfficeInputTextField.getText().trim(), this.fUserDepartmentInputTextField.getText().trim(), this.fUserCountryInputTextField.getText().trim(), this.fUserCityInputTextField.getText().trim());
            if (this.fUsersList.size() > 0) {
                TableColumn[] columns;
                this.fUsersTableViewer.setInput((Object)this.fUsersList.toArray(new IUserInfo[this.fUsersList.size()]));
                TableColumn[] tableColumnArray = columns = this.fUsersTableViewer.getTable().getColumns();
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn column = tableColumnArray[n2];
                    column.pack();
                    ++n2;
                }
                this.fUsersTableViewer.refresh();
                this.fUsersTableViewer.getTable().layout();
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Find User Result", (String)"No Users found");
            }
        }
        catch (NamingException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), e);
            ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Naming Error Detected", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, e.getMessage(), (Throwable)e), 4);
            dialog.open();
        }
        catch (IOException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), e);
            ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "I/O Error Detected", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, e.getMessage(), (Throwable)e), 4);
            dialog.open();
        }
    }

    protected void clearSearchField() {
        this.fUserIdInputTextField.setText("");
        this.fUserNameInputTextField.setText("");
        this.fUserOfficeInputTextField.setText("");
        this.fUserCompanyInputTextField.setText("");
        this.fUserDepartmentInputTextField.setText("");
        this.fUserCityInputTextField.setText("");
        this.fUserCountryInputTextField.setText("");
    }

    protected boolean isResizable() {
        return true;
    }

    @Override
    public List<IUserInfo> getUserInfos() {
        return this.fUserInfos;
    }

    @Override
    public void setDialogsDefaults() {
        this.getShell().setDefaultButton(this.fSearchButton);
        this.getShell().setMinimumSize(860, 550);
        this.fUserInfos.clear();
    }

    private void updateTableSelections() {
        ArrayList<IUserInfo> selectedElements = new ArrayList<IUserInfo>();
        for (IUserInfo userInfo : this.fUserInfos) {
            int i = 0;
            while (i < this.fUsersTableViewer.getTable().getItemCount()) {
                IUserInfo tableUserInfo = (IUserInfo)this.fUsersTableViewer.getElementAt(i);
                if (userInfo.getUserId().equalsIgnoreCase(tableUserInfo.getUserId())) {
                    selectedElements.add(tableUserInfo);
                }
                ++i;
            }
        }
        StructuredSelection selection = new StructuredSelection(selectedElements);
        this.fUsersTableViewer.setSelection((ISelection)selection, true);
    }

    public void addUser() {
        IStructuredSelection selection = (IStructuredSelection)this.fUsersTableViewer.getSelection();
        IUserInfo element2 = null;
        boolean userFound = false;
        for (IUserInfo element2 : selection) {
            for (IUserInfo userInfo : this.fUserInfos) {
                if (!element2.getUserId().equalsIgnoreCase(userInfo.getUserId())) continue;
                userFound = true;
                break;
            }
            if (userFound) continue;
            this.fUserInfos.add(element2);
        }
        StringBuffer buffer = new StringBuffer();
        for (IUserInfo userInfo : this.fUserInfos) {
            buffer.append(String.valueOf(userInfo.getUserId().toLowerCase()) + ";" + " ");
        }
        this.fUserAddedValue.setText(buffer.toString());
    }
}

