/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MExpression;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarSeparator;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarManagerRenderer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.widgets.Shell;

public class ToolBarContributionRecord {
    public static final String FACTORY = "ToolBarContributionFactory";
    static final String STATIC_CONTEXT = "ToolBarContributionFactoryContext";
    MToolBar toolbarModel;
    MToolBarContribution toolbarContribution;
    ArrayList<MToolBarElement> generatedElements = new ArrayList();
    HashSet<MToolBarElement> sharedElements = new HashSet();
    ToolBarManagerRenderer renderer;
    boolean isVisible = true;
    private IEclipseContext infoContext;
    private Runnable factoryDispose;

    public ToolBarContributionRecord(MToolBar model, MToolBarContribution contribution, ToolBarManagerRenderer renderer) {
        this.toolbarModel = model;
        this.toolbarContribution = contribution;
        this.renderer = renderer;
    }

    public ToolBarManager getManagerForModel() {
        return this.renderer.getManager(this.toolbarModel);
    }

    public void updateVisibility(IEclipseContext context) {
        boolean currentVisibility;
        ExpressionContext exprContext = new ExpressionContext(context);
        this.updateIsVisible(exprContext);
        HashSet<ToolBarContributionRecord> recentlyUpdated = new HashSet<ToolBarContributionRecord>();
        recentlyUpdated.add(this);
        boolean changed = false;
        for (MToolBarElement item : this.generatedElements) {
            currentVisibility = this.computeVisibility(recentlyUpdated, item, exprContext);
            if (item.isVisible() == currentVisibility) continue;
            item.setVisible(currentVisibility);
            changed = true;
        }
        for (MToolBarElement item : this.sharedElements) {
            currentVisibility = this.computeVisibility(recentlyUpdated, item, exprContext);
            if (item.isVisible() == currentVisibility) continue;
            item.setVisible(currentVisibility);
            changed = true;
        }
        if (changed) {
            ToolBarManager managerForModel = this.getManagerForModel();
            managerForModel.markDirty();
            if (this.isVisible) {
                Stream.of(managerForModel.getItems()).filter(i -> i.isVisible()).findFirst().ifPresent(i -> {
                    Object widget;
                    MWindow window = this.getWindow();
                    if (window != null && (widget = window.getWidget()) instanceof Shell) {
                        ((Shell)widget).requestLayout();
                    }
                });
            }
        }
    }

    private MWindow getWindow() {
        EObject n = (EObject)this.toolbarModel;
        while (n.eContainer() != null) {
            if (!((n = n.eContainer()) instanceof MWindow)) continue;
            return (MWindow)n;
        }
        return null;
    }

    public void updateIsVisible(ExpressionContext exprContext) {
        this.isVisible = ContributionsAnalyzer.isVisible((MToolBarContribution)this.toolbarContribution, (ExpressionContext)exprContext);
    }

    public boolean computeVisibility(HashSet<ToolBarContributionRecord> recentlyUpdated, MToolBarElement item, ExpressionContext exprContext) {
        String identifier;
        Object rc;
        ArrayList<ToolBarContributionRecord> list;
        boolean currentVisibility = this.isVisible;
        if (item instanceof MToolBarSeparator && (list = this.renderer.getList(item)) != null) {
            Iterator<ToolBarContributionRecord> cr = list.iterator();
            while (!currentVisibility && cr.hasNext()) {
                ToolBarContributionRecord rec = cr.next();
                if (!recentlyUpdated.contains(rec)) {
                    rec.updateIsVisible(exprContext);
                    recentlyUpdated.add(rec);
                }
                currentVisibility |= rec.isVisible;
            }
        }
        if (currentVisibility && item.getPersistedState().get("IIdentifier") != null && (rc = exprContext.eclipseContext.get(identifier = (String)item.getPersistedState().get("IIdentifier"))) instanceof Boolean) {
            currentVisibility = (Boolean)rc;
        }
        if (currentVisibility && item.getVisibleWhen() != null) {
            boolean val;
            currentVisibility = val = ContributionsAnalyzer.isVisible((MExpression)item.getVisibleWhen(), (ExpressionContext)exprContext);
        }
        return currentVisibility;
    }

    public void collectInfo(ExpressionInfo info) {
        ContributionsAnalyzer.collectInfo((ExpressionInfo)info, (MExpression)this.toolbarContribution.getVisibleWhen());
        for (MToolBarElement item : this.generatedElements) {
            ContributionsAnalyzer.collectInfo((ExpressionInfo)info, (MExpression)item.getVisibleWhen());
        }
        for (MToolBarElement item : this.sharedElements) {
            ContributionsAnalyzer.collectInfo((ExpressionInfo)info, (MExpression)item.getVisibleWhen());
        }
    }

    public boolean anyVisibleWhen() {
        if (this.toolbarContribution.getVisibleWhen() != null) {
            return true;
        }
        List<Object> childrenToInspect = this.toolbarContribution.getTransientData().get(FACTORY) != null ? this.generatedElements : this.toolbarContribution.getChildren();
        for (MToolBarElement mToolBarElement : childrenToInspect) {
            if (!this.requiresVisibilityCheck(mToolBarElement)) continue;
            return true;
        }
        return false;
    }

    private boolean requiresVisibilityCheck(MToolBarElement toolBarElement) {
        return toolBarElement.getVisibleWhen() != null || toolBarElement.getPersistedState().get("IIdentifier") != null;
    }

    public boolean mergeIntoModel() {
        List<MToolBarElement> copyElements;
        int idx = ToolBarContributionRecord.getIndex(this.toolbarModel, this.toolbarContribution.getPositionInParent());
        if (idx == -1) {
            return false;
        }
        if (this.toolbarContribution.getTransientData().get(FACTORY) != null) {
            copyElements = this.mergeFactoryIntoModel();
        } else {
            copyElements = new ArrayList<MToolBarElement>();
            for (MToolBarElement item : this.toolbarContribution.getChildren()) {
                MToolBarElement copy = (MToolBarElement)EcoreUtil.copy((EObject)((EObject)item));
                copyElements.add(copy);
            }
        }
        Iterator<Object> iterator = copyElements.iterator();
        while (iterator.hasNext()) {
            MToolBarElement copy;
            copy.setVisible(!this.requiresVisibilityCheck(copy = (MToolBarElement)iterator.next()));
            if (copy instanceof MToolBarSeparator) {
                MToolBarSeparator shared = this.findExistingSeparator(copy.getElementId());
                if (shared == null) {
                    shared = (MToolBarSeparator)copy;
                    this.renderer.linkElementToContributionRecord(copy, this);
                    this.toolbarModel.getChildren().add(idx++, copy);
                } else {
                    copy = shared;
                }
                this.sharedElements.add((MToolBarElement)shared);
            } else {
                this.generatedElements.add(copy);
                this.renderer.linkElementToContributionRecord(copy, this);
                this.toolbarModel.getChildren().add(idx++, copy);
            }
            if (!(copy instanceof MToolBarSeparator)) continue;
            ArrayList<ToolBarContributionRecord> array = this.renderer.getList(copy);
            array.add(this);
        }
        return true;
    }

    private List<MToolBarElement> mergeFactoryIntoModel() {
        Object obj = this.toolbarContribution.getTransientData().get(FACTORY);
        if (!(obj instanceof IContextFunction)) {
            return Collections.EMPTY_LIST;
        }
        IEclipseContext staticContext = this.getStaticContext();
        staticContext.remove(List.class);
        this.factoryDispose = (Runnable)((IContextFunction)obj).compute(staticContext, null);
        return (List)staticContext.get(List.class);
    }

    private IEclipseContext getStaticContext() {
        if (this.infoContext == null) {
            IEclipseContext parentContext = this.renderer.getContext((MUIElement)this.toolbarModel);
            this.infoContext = parentContext != null ? parentContext.createChild(STATIC_CONTEXT) : EclipseContextFactory.create((String)STATIC_CONTEXT);
            ContributionsAnalyzer.populateModelInterfaces((Object)this.toolbarModel, (IEclipseContext)this.infoContext, (Class[])this.toolbarModel.getClass().getInterfaces());
            this.infoContext.set(ToolBarManagerRenderer.class, (Object)this.renderer);
        }
        return this.infoContext;
    }

    MToolBarSeparator findExistingSeparator(String id) {
        if (id == null) {
            return null;
        }
        for (MToolBarElement item : this.toolbarModel.getChildren()) {
            if (!(item instanceof MToolBarSeparator) || !id.equals(item.getElementId())) continue;
            return (MToolBarSeparator)item;
        }
        return null;
    }

    public void dispose() {
        for (MToolBarElement copy : this.generatedElements) {
            this.toolbarModel.getChildren().remove(copy);
        }
        for (MToolBarElement shared : this.sharedElements) {
            ArrayList<ToolBarContributionRecord> array = this.renderer.getList(shared);
            array.remove(this);
            if (!array.isEmpty()) continue;
            this.toolbarModel.getChildren().remove(shared);
        }
        if (this.factoryDispose != null) {
            this.factoryDispose.run();
            this.factoryDispose = null;
        }
    }

    private static int getIndex(MElementContainer<?> model, String positionInParent) {
        String id = null;
        String modifier = null;
        if (positionInParent != null && positionInParent.length() > 0) {
            String[] array = positionInParent.split("=");
            modifier = array[0];
            id = array[1];
        }
        if (id == null) {
            return model.getChildren().size();
        }
        int idx = 0;
        int size = model.getChildren().size();
        while (idx < size) {
            if (id.equals(((MUIElement)model.getChildren().get(idx)).getElementId())) {
                if ("after".equals(modifier)) {
                    ++idx;
                } else if ("endof".equals(modifier)) {
                    ++idx;
                    while (!(idx >= size || model.getChildren().get(idx) instanceof MToolBarSeparator && ((MUIElement)model.getChildren().get(idx)).getElementId() != null)) {
                        ++idx;
                    }
                }
                return idx;
            }
            ++idx;
        }
        return id.equals("additions") ? model.getChildren().size() : -1;
    }
}

