/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util.internal.pde;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.internal.pde.UtilPDEPlugin;
import org.eclipse.oomph.util.pde.TargetPlatformUtil;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.internal.core.util.ManifestUtils;

public class TargetPlatformClasspathFile
implements IDynamicVariableResolver {
    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        try {
            File tempFile = File.createTempFile("pde-", ".properties");
            ITargetDefinition targetDefinition = TargetPlatformUtil.getActiveTargetDefinition();
            if (!targetDefinition.isResolved()) {
                targetDefinition.resolve((IProgressMonitor)new NullProgressMonitor());
            }
            StringBuilder builder = new StringBuilder();
            TargetBundle[] targetBundleArray = targetDefinition.getAllBundles();
            int n = targetBundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                String scheme;
                URI location;
                TargetBundle bundle = targetBundleArray[n2];
                BundleInfo info = bundle.getBundleInfo();
                if (info != null && !info.getSymbolicName().endsWith(".source") && (location = info.getLocation()) != null && "file".equals(scheme = location.getScheme())) {
                    TargetPlatformClasspathFile.appendBundleClasspath(builder, new File(location.getPath()));
                }
                ++n2;
            }
            IOUtil.writeLines((File)tempFile, (String)"UTF-8", Collections.singletonList(builder.toString()));
            return tempFile.getAbsolutePath();
        }
        catch (Exception ex) {
            UtilPDEPlugin.INSTANCE.coreException(ex);
            return null;
        }
    }

    public static void appendBundleClasspath(StringBuilder builder, File file) throws CoreException {
        if (file != null) {
            if (file.isDirectory()) {
                TargetPlatformClasspathFile.appendFolder(builder, file);
            } else {
                TargetPlatformClasspathFile.appendFile(builder, file);
            }
        }
    }

    private static void appendFolder(StringBuilder builder, File bundleFolder) throws CoreException {
        Map manifest = ManifestUtils.loadManifest((File)bundleFolder);
        String bundleClasspath = (String)manifest.get("Bundle-ClassPath");
        if (bundleClasspath != null) {
            StringTokenizer tokenizer = new StringTokenizer(bundleClasspath, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (".".equals(token)) {
                    TargetPlatformClasspathFile.appendFile(builder, bundleFolder);
                    continue;
                }
                TargetPlatformClasspathFile.appendFile(builder, new File(bundleFolder, token));
            }
        }
    }

    private static void appendFile(StringBuilder builder, File file) {
        if (builder.length() != 0) {
            builder.append(File.pathSeparatorChar);
        }
        builder.append(file.getAbsolutePath());
    }
}

