/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.util.PrefUtil;

public class GlobalizationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Combo layoutDirectionCombo;
    private Button bidiSupportClickButton;
    private Combo textDirectionCombo;
    private StringFieldEditor nlExtensionsField;
    private int layoutDirection;
    private boolean bidiSupport;
    private String textDirection;
    private static final String DEFAULT_DIR = WorkbenchMessages.GlobalizationPreference_defaultDirection;
    private static final String LTR_DIR = WorkbenchMessages.GlobalizationPreference_ltrDirection;
    private static final String AUTO_DIR = WorkbenchMessages.GlobalizationPreference_autoDirection;
    private static final String RTL_DIR = WorkbenchMessages.GlobalizationPreference_rtlDirection;

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.globalization_preference_page_context");
        Composite composite = GlobalizationPreferencePage.createComposite(parent);
        this.createNlsExtensionsGroup(composite);
        GlobalizationPreferencePage.createSpace(composite);
        this.createBidiPreferencesGroup(composite);
        this.applyDialogFont(composite);
        return composite;
    }

    private static Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        return composite;
    }

    private void createNlsExtensionsGroup(Composite parent) {
        this.nlExtensionsField = new StringFieldEditor("NL_EXTENSIONS", WorkbenchMessages.GlobalizationPreference_nlExtensions, parent);
        this.nlExtensionsField.setPreferenceStore(this.getPreferenceStore());
        this.nlExtensionsField.setPage((DialogPage)this);
        this.nlExtensionsField.load();
    }

    private void createBidiPreferencesGroup(Composite composite) {
        this.layoutDirectionCombo = GlobalizationPreferencePage.addComboBox(composite, WorkbenchMessages.GlobalizationPreference_layoutDirection, 0);
        this.layoutDirectionCombo.setItems(new String[]{DEFAULT_DIR, LTR_DIR, RTL_DIR});
        this.layoutDirectionCombo.select(this.getLayoutDirectionIndex(this.layoutDirection));
        this.layoutDirectionCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            int n = this.layoutDirection = this.getLayoutDirectionInteger(this.layoutDirectionCombo.getSelectionIndex());
        }));
        GlobalizationPreferencePage.createSpace(composite);
        this.bidiSupportClickButton = new Button(composite, 16416);
        this.bidiSupportClickButton.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
        this.bidiSupportClickButton.setText(WorkbenchMessages.GlobalizationPreference_bidiSupport);
        this.bidiSupportClickButton.setSelection(this.bidiSupport);
        this.bidiSupportClickButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.selectClickMode(this.bidiSupportClickButton.getSelection())));
        this.textDirectionCombo = GlobalizationPreferencePage.addComboBox(composite, WorkbenchMessages.GlobalizationPreference_textDirection, LayoutConstants.getIndent());
        this.textDirectionCombo.setItems(new String[]{DEFAULT_DIR, LTR_DIR, AUTO_DIR, RTL_DIR});
        this.textDirectionCombo.setEnabled(this.bidiSupport);
        this.textDirectionCombo.select(this.getTextDirectionIndex(this.textDirection));
        this.textDirectionCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String string = this.textDirection = this.getTextDirectionString(this.textDirectionCombo.getSelectionIndex());
        }));
        GlobalizationPreferencePage.createSpace(composite);
        Font font = composite.getFont();
        Composite note = this.createNoteComposite(font, composite, WorkbenchMessages.Preference_note, WorkbenchMessages.GlobalizationPreference_restartWidget);
        note.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
    }

    private void selectClickMode(boolean singleClick) {
        this.bidiSupport = singleClick;
        this.textDirectionCombo.setEnabled(this.bidiSupport);
    }

    private int getTextDirectionIndex(String textDirection) {
        int index = textDirection.equals("ltr") ? this.textDirectionCombo.indexOf(LTR_DIR) : (textDirection.equals("rtl") ? this.textDirectionCombo.indexOf(RTL_DIR) : (textDirection.equals("auto") ? this.textDirectionCombo.indexOf(AUTO_DIR) : this.textDirectionCombo.indexOf(DEFAULT_DIR)));
        return index;
    }

    private String getTextDirectionString(int index) {
        String textDir = index == this.textDirectionCombo.indexOf(LTR_DIR) ? "ltr" : (index == this.textDirectionCombo.indexOf(AUTO_DIR) ? "auto" : (index == this.textDirectionCombo.indexOf(RTL_DIR) ? "rtl" : ""));
        return textDir;
    }

    private int getLayoutDirectionIndex(int layoutDirection) {
        int index = layoutDirection == 0x2000000 ? this.layoutDirectionCombo.indexOf(LTR_DIR) : (layoutDirection == 0x4000000 ? this.layoutDirectionCombo.indexOf(RTL_DIR) : this.layoutDirectionCombo.indexOf(DEFAULT_DIR));
        return index;
    }

    private int getLayoutDirectionInteger(int index) {
        int layoutDir = index == this.layoutDirectionCombo.indexOf(LTR_DIR) ? 0x2000000 : (index == this.layoutDirectionCombo.indexOf(RTL_DIR) ? 0x4000000 : 0);
        return layoutDir;
    }

    private static Combo addComboBox(Composite parent, String label, int indent) {
        Label labelControl = new Label(parent, 16384);
        GridData gd = new GridData();
        gd.horizontalIndent = indent;
        labelControl.setLayoutData((Object)gd);
        labelControl.setText(label);
        return new Combo(parent, 8);
    }

    private static void createSpace(Composite parent) {
        Label vfiller = new Label(parent, 16384);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        GC gc = new GC((Drawable)parent);
        gridData.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)1) / 2;
        gc.dispose();
        vfiller.setLayoutData((Object)gridData);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    @Override
    public void init(IWorkbench aWorkbench) {
        IPreferenceStore store = this.getPreferenceStore();
        this.layoutDirection = store.getInt("LAYOUT_DIRECTION");
        this.bidiSupport = store.getBoolean("BIDI_SUPPORT");
        this.textDirection = store.getString("TEXT_DIRECTION");
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.nlExtensionsField.setStringValue(store.getDefaultString("NL_EXTENSIONS"));
        this.layoutDirection = store.getDefaultInt("LAYOUT_DIRECTION");
        this.bidiSupport = store.getDefaultBoolean("BIDI_SUPPORT");
        this.textDirection = store.getDefaultString("TEXT_DIRECTION");
        this.layoutDirectionCombo.select(this.getLayoutDirectionIndex(this.layoutDirection));
        this.bidiSupportClickButton.setSelection(this.bidiSupport);
        this.textDirectionCombo.select(this.getTextDirectionIndex(this.textDirection));
        this.textDirectionCombo.setEnabled(this.bidiSupport);
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("NL_EXTENSIONS", this.nlExtensionsField.getStringValue());
        store.setValue("LAYOUT_DIRECTION", this.layoutDirection);
        store.setValue("BIDI_SUPPORT", this.bidiSupport);
        store.setValue("TEXT_DIRECTION", this.textDirection);
        Window.setDefaultOrientation((int)this.layoutDirection);
        BidiUtils.setBidiSupport((boolean)this.bidiSupport);
        BidiUtils.setTextDirection((String)(this.textDirection.isEmpty() ? null : this.textDirection));
        PrefUtil.savePrefs();
        return true;
    }
}

