/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.projects.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.predicates.PredicatesFactory;
import org.eclipse.oomph.setup.projects.ProjectsBuildTask;
import org.eclipse.oomph.setup.projects.ProjectsPackage;
import org.eclipse.oomph.setup.projects.provider.ProjectsEditPlugin;
import org.eclipse.oomph.setup.provider.SetupTaskItemProvider;
import org.eclipse.oomph.util.StringUtil;

public class ProjectsBuildTaskItemProvider
extends SetupTaskItemProvider {
    public ProjectsBuildTaskItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addLabelPropertyDescriptor(object);
            this.addOnlyNewProjectsPropertyDescriptor(object);
            this.addRefreshPropertyDescriptor(object);
            this.addCleanPropertyDescriptor(object);
            this.addBuildPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addLabelPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ProjectsBuildTask_label_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ProjectsBuildTask_label_feature", "_UI_ProjectsBuildTask_type"), (EStructuralFeature)ProjectsPackage.Literals.PROJECTS_BUILD_TASK__LABEL, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addOnlyNewProjectsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ProjectsBuildTask_onlyNewProjects_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ProjectsBuildTask_onlyNewProjects_feature", "_UI_ProjectsBuildTask_type"), (EStructuralFeature)ProjectsPackage.Literals.PROJECTS_BUILD_TASK__ONLY_NEW_PROJECTS, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addRefreshPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ProjectsBuildTask_refresh_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ProjectsBuildTask_refresh_feature", "_UI_ProjectsBuildTask_type"), (EStructuralFeature)ProjectsPackage.Literals.PROJECTS_BUILD_TASK__REFRESH, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addCleanPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ProjectsBuildTask_clean_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ProjectsBuildTask_clean_feature", "_UI_ProjectsBuildTask_type"), (EStructuralFeature)ProjectsPackage.Literals.PROJECTS_BUILD_TASK__CLEAN, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addBuildPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ProjectsBuildTask_build_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ProjectsBuildTask_build_feature", "_UI_ProjectsBuildTask_type"), (EStructuralFeature)ProjectsPackage.Literals.PROJECTS_BUILD_TASK__BUILD, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(ProjectsPackage.Literals.PROJECTS_BUILD_TASK__PREDICATES);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/ProjectsBuildTask"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        ProjectsBuildTask projectsBuildTask = (ProjectsBuildTask)object;
        String label = projectsBuildTask.getLabel();
        if (StringUtil.isEmpty((String)label)) {
            label = this.getString("_UI_ProjectsBuildTask_type");
        }
        ArrayList<String> tags = new ArrayList<String>();
        if (projectsBuildTask.isOnlyNewProjects()) {
            tags.add(this.getFeatureText(ProjectsPackage.Literals.PROJECTS_BUILD_TASK__ONLY_NEW_PROJECTS));
        }
        if (projectsBuildTask.isRefresh()) {
            tags.add(this.getFeatureText(ProjectsPackage.Literals.PROJECTS_BUILD_TASK__REFRESH));
        }
        if (projectsBuildTask.isClean()) {
            tags.add(this.getFeatureText(ProjectsPackage.Literals.PROJECTS_BUILD_TASK__CLEAN));
        }
        if (projectsBuildTask.isBuild()) {
            tags.add(this.getFeatureText(ProjectsPackage.Literals.PROJECTS_BUILD_TASK__BUILD));
        }
        if (!tags.isEmpty()) {
            return label + " (" + StringUtil.implode(tags, (char)',').replace(",", ", ") + ")";
        }
        return label;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(ProjectsBuildTask.class)) {
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 11: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(ProjectsPackage.Literals.PROJECTS_BUILD_TASK__PREDICATES, PredicatesFactory.eINSTANCE.createNamePredicate()));
        newChildDescriptors.add(this.createChildParameter(ProjectsPackage.Literals.PROJECTS_BUILD_TASK__PREDICATES, PredicatesFactory.eINSTANCE.createCommentPredicate()));
        newChildDescriptors.add(this.createChildParameter(ProjectsPackage.Literals.PROJECTS_BUILD_TASK__PREDICATES, PredicatesFactory.eINSTANCE.createLocationPredicate()));
        newChildDescriptors.add(this.createChildParameter(ProjectsPackage.Literals.PROJECTS_BUILD_TASK__PREDICATES, PredicatesFactory.eINSTANCE.createRepositoryPredicate()));
        newChildDescriptors.add(this.createChildParameter(ProjectsPackage.Literals.PROJECTS_BUILD_TASK__PREDICATES, PredicatesFactory.eINSTANCE.createAndPredicate()));
        newChildDescriptors.add(this.createChildParameter(ProjectsPackage.Literals.PROJECTS_BUILD_TASK__PREDICATES, PredicatesFactory.eINSTANCE.createOrPredicate()));
        newChildDescriptors.add(this.createChildParameter(ProjectsPackage.Literals.PROJECTS_BUILD_TASK__PREDICATES, PredicatesFactory.eINSTANCE.createNotPredicate()));
        newChildDescriptors.add(this.createChildParameter(ProjectsPackage.Literals.PROJECTS_BUILD_TASK__PREDICATES, PredicatesFactory.eINSTANCE.createNaturePredicate()));
        newChildDescriptors.add(this.createChildParameter(ProjectsPackage.Literals.PROJECTS_BUILD_TASK__PREDICATES, PredicatesFactory.eINSTANCE.createBuilderPredicate()));
        newChildDescriptors.add(this.createChildParameter(ProjectsPackage.Literals.PROJECTS_BUILD_TASK__PREDICATES, PredicatesFactory.eINSTANCE.createFilePredicate()));
        newChildDescriptors.add(this.createChildParameter(ProjectsPackage.Literals.PROJECTS_BUILD_TASK__PREDICATES, PredicatesFactory.eINSTANCE.createImportedPredicate()));
    }

    public ResourceLocator getResourceLocator() {
        return ProjectsEditPlugin.INSTANCE;
    }
}

