/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui.internal.pde;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.oomph.ui.internal.pde.TargetManager;
import org.eclipse.oomph.ui.internal.pde.TargetSnapshot;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.internal.core.target.ExternalFileTargetHandle;
import org.eclipse.pde.internal.core.target.WorkspaceFileTargetHandle;

public final class Target
implements Comparable<Target> {
    private static final TargetSnapshot[] NO_SNAPSHOTS = new TargetSnapshot[0];
    private final TargetManager manager;
    private final ITargetHandle handle;
    private String name;
    private Set<TargetSnapshot> snapshots;
    private TargetSnapshot[] sortedSnapshots;
    private int lastSnapshotNumber;

    Target(TargetManager manager, ITargetHandle handle, String name) {
        this.manager = Objects.requireNonNull(manager);
        this.handle = Objects.requireNonNull(handle);
        this.name = name;
        this.clearSnapshots();
    }

    public TargetManager getManager() {
        return this.manager;
    }

    public ITargetHandle getHandle() {
        return this.handle;
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        if (this.handle instanceof WorkspaceFileTargetHandle) {
            IFile file = ((WorkspaceFileTargetHandle)this.handle).getTargetFile();
            return file.getFullPath().toString();
        }
        if (this.handle instanceof ExternalFileTargetHandle) {
            URI uri = ((ExternalFileTargetHandle)this.handle).getLocation();
            return uri.toString();
        }
        return null;
    }

    public IFile getWorkspaceFile() {
        if (this.handle instanceof WorkspaceFileTargetHandle) {
            return ((WorkspaceFileTargetHandle)this.handle).getTargetFile();
        }
        return null;
    }

    public boolean isActive() {
        return this.manager.getActiveTarget() == this;
    }

    public boolean isDefault() {
        return Objects.equals(this.name, this.manager.getDefaultTargetName());
    }

    public TargetSnapshot[] getSnapshots() {
        return this.sortedSnapshots;
    }

    public List<TargetSnapshot> getOldSnapshots() {
        TargetSnapshot[] tmp = this.sortedSnapshots;
        if (tmp.length <= 1) {
            return Collections.emptyList();
        }
        ArrayList<TargetSnapshot> result = new ArrayList<TargetSnapshot>();
        int i = 1;
        while (i < tmp.length) {
            result.add(tmp[i]);
            ++i;
        }
        return result;
    }

    public TargetSnapshot getCurrentSnapshot() {
        TargetSnapshot[] tmp = this.sortedSnapshots;
        return tmp.length == 0 ? null : tmp[0];
    }

    public TargetSnapshot getPreviousSnapshot(TargetSnapshot snapshot) {
        TargetSnapshot[] tmp = this.sortedSnapshots;
        int index = Target.indexOfSnapshot(tmp, snapshot);
        return index != -1 && index < tmp.length - 1 ? tmp[index + 1] : null;
    }

    public TargetSnapshot getNextSnapshot(TargetSnapshot snapshot) {
        TargetSnapshot[] tmp = this.sortedSnapshots;
        int index = Target.indexOfSnapshot(tmp, snapshot);
        return index != -1 && index > 0 ? tmp[index - 1] : null;
    }

    public boolean isMonitored() {
        return this.manager.getMonitoredTarget() == this;
    }

    public boolean monitor() {
        return this.manager.monitorTarget(this);
    }

    public TargetSnapshot takeSnapshot() {
        return this.manager.targetSaved(this.handle, true);
    }

    public void deleteSnapshots(Collection<TargetSnapshot> snapshots) {
        if (!snapshots.isEmpty()) {
            this.manager.deleteSnapshots(this, snapshots);
        }
    }

    public boolean isResolved() {
        return this.snapshots != null;
    }

    @Override
    public int compareTo(Target o) {
        int result;
        int n = result = this.name == null ? -1 : this.name.compareTo(o.name);
        if (result == 0) {
            result = this.handle.toString().compareTo(o.handle.toString());
        }
        return result;
    }

    public String toString() {
        return "Target[" + this.name + " --> " + String.valueOf(this.handle) + "]";
    }

    void setName(String name) {
        this.name = name;
    }

    TargetSnapshot internalTakeSnapshot(String xml) {
        TargetSnapshot snapshot = new TargetSnapshot(this, ++this.lastSnapshotNumber, xml);
        this.snapshots.add(snapshot);
        this.updateSortedSnapshots();
        return snapshot;
    }

    void internalDeleteSnapshots(Collection<TargetSnapshot> snapshots) {
        this.snapshots.removeAll(snapshots);
        this.updateSortedSnapshots();
    }

    void clearSnapshots() {
        this.snapshots = new HashSet<TargetSnapshot>();
        this.sortedSnapshots = NO_SNAPSHOTS;
    }

    private void updateSortedSnapshots() {
        this.sortedSnapshots = this.snapshots.toArray(new TargetSnapshot[this.snapshots.size()]);
        Arrays.sort(this.sortedSnapshots);
    }

    private static int indexOfSnapshot(TargetSnapshot[] tmp, TargetSnapshot snapshot) {
        int i = 0;
        while (i < tmp.length) {
            if (tmp[i] == snapshot) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

