/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.urischeme.internal.registration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.urischeme.IOperatingSystemRegistration;
import org.eclipse.urischeme.IScheme;
import org.eclipse.urischeme.ISchemeInformation;
import org.eclipse.urischeme.internal.registration.DesktopFileWriter;
import org.eclipse.urischeme.internal.registration.FileProvider;
import org.eclipse.urischeme.internal.registration.IFileProvider;
import org.eclipse.urischeme.internal.registration.IProcessExecutor;
import org.eclipse.urischeme.internal.registration.ProcessExecutor;
import org.eclipse.urischeme.internal.registration.SchemeInformation;

public class RegistrationLinux
implements IOperatingSystemRegistration {
    private static final String DEFAULT_PRODUCT_NAME = "Eclipse SDK";
    private static final String USER_HOME = System.getProperty("user.home");
    private static final String PATH_TO_LOCAL_SHARE_APPS = String.valueOf(USER_HOME) + "/.local/share/applications/";
    private static final String DESKTOP_FILE_EXT = ".desktop";
    private static final String XDG_MIME = "xdg-mime";
    private static final String DEFAULT = "default";
    private static final String QUERY = "query";
    private static final String X_SCHEME_HANDLER_PREFIX = "x-scheme-handler/";
    private IFileProvider fileProvider;
    private IProcessExecutor processExecutor;
    private String productName;

    public RegistrationLinux() {
        this(new FileProvider(), new ProcessExecutor(), RegistrationLinux.getProductName());
    }

    private static String getProductName() {
        IProduct product = Platform.getProduct();
        String name = product == null ? DEFAULT_PRODUCT_NAME : product.getName();
        return name == null ? DEFAULT_PRODUCT_NAME : name;
    }

    public RegistrationLinux(IFileProvider fileProvider, IProcessExecutor processExecutor, String productName) {
        this.fileProvider = fileProvider;
        this.processExecutor = processExecutor;
        this.productName = productName;
    }

    @Override
    public void handleSchemes(Collection<IScheme> toAdd, Collection<IScheme> toRemove) throws Exception {
        String desktopFileName = this.getDesktopFileName();
        this.changeDesktopFile(toAdd, toRemove, String.valueOf(PATH_TO_LOCAL_SHARE_APPS) + desktopFileName);
        this.registerSchemesWithXdgMime(toAdd, desktopFileName);
    }

    @Override
    public List<ISchemeInformation> getSchemesInformation(Collection<IScheme> schemes) throws Exception {
        ArrayList<ISchemeInformation> returnList = new ArrayList<ISchemeInformation>();
        String eclipseLauncher = this.getEclipseLauncher();
        for (IScheme scheme : schemes) {
            SchemeInformation schemeInfo = new SchemeInformation(scheme.getName(), scheme.getDescription());
            String location = this.determineHandlerLocation(scheme.getName());
            if (location.equals(eclipseLauncher)) {
                schemeInfo.setHandled(true);
            }
            schemeInfo.setHandlerLocation(location);
            returnList.add(schemeInfo);
        }
        return returnList;
    }

    private String determineHandlerLocation(String uriScheme) throws Exception {
        String desktopFileName = this.getRegisteredDesktopFileForScheme(uriScheme);
        if (!desktopFileName.isEmpty()) {
            return this.getHandlerLocationFromDesktopFileIfSchemeRegistered(desktopFileName, uriScheme);
        }
        return "";
    }

    private void changeDesktopFile(Iterable<IScheme> toAdd, Iterable<IScheme> toRemove, String desktopFilePath) throws IOException {
        List<String> lines = this.readFileOrGetInitialContent(desktopFilePath);
        if (lines.isEmpty()) {
            return;
        }
        DesktopFileWriter writer = new DesktopFileWriter(lines);
        for (IScheme scheme : toAdd) {
            writer.addScheme(scheme.getName());
        }
        for (IScheme scheme : toRemove) {
            writer.removeScheme(scheme.getName());
        }
        this.fileProvider.write(desktopFilePath, writer.getResult());
    }

    private List<String> readFileOrGetInitialContent(String desktopFilePath) {
        try {
            return this.fileProvider.readAllLines(desktopFilePath);
        }
        catch (IOException iOException) {
            return DesktopFileWriter.getMinimalDesktopFileContent(this.getEclipseLauncher(), this.productName);
        }
    }

    private void registerSchemesWithXdgMime(Collection<IScheme> schemes, String desktopFilePath) throws Exception {
        if (schemes.isEmpty()) {
            return;
        }
        String scheme = schemes.stream().map(IScheme::getName).collect(Collectors.joining(" x-scheme-handler/", X_SCHEME_HANDLER_PREFIX, ""));
        this.processExecutor.execute(XDG_MIME, DEFAULT, desktopFilePath, scheme);
    }

    private String getHandlerLocationFromDesktopFileIfSchemeRegistered(String desktopFileName, String scheme) throws IOException {
        List<String> lines;
        DesktopFileWriter writer;
        String path = String.valueOf(PATH_TO_LOCAL_SHARE_APPS) + desktopFileName;
        if (this.fileProvider.fileExists(path) && (writer = new DesktopFileWriter(lines = this.fileProvider.readAllLines(path))).isRegistered(scheme)) {
            return writer.getExecutableLocation();
        }
        return "";
    }

    private String getRegisteredDesktopFileForScheme(String scheme) throws Exception {
        return this.processExecutor.execute(XDG_MIME, QUERY, DEFAULT, X_SCHEME_HANDLER_PREFIX + scheme);
    }

    private String getDesktopFileName() {
        String homeLocationProperty = this.getEclipseHomeLocation();
        homeLocationProperty = homeLocationProperty.replace("/", "_");
        return String.valueOf(homeLocationProperty) + DESKTOP_FILE_EXT;
    }

    @Override
    public String getEclipseLauncher() {
        String property = System.getProperty("eclipse.launcher");
        if (property == null) {
            return String.valueOf(this.getEclipseHomeLocation()) + "eclipse";
        }
        return property;
    }

    private String getEclipseHomeLocation() {
        String homeLocationProperty = System.getProperty("eclipse.home.location", "");
        if (homeLocationProperty.startsWith("file:")) {
            return homeLocationProperty.substring("file:".length());
        }
        return homeLocationProperty;
    }

    @Override
    public boolean canOverwriteOtherApplicationsRegistration() {
        return false;
    }
}

