/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.ui;

import java.lang.reflect.Field;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.userstorage.internal.util.StringUtil;
import org.eclipse.userstorage.ui.internal.Activator;

public abstract class AbstractDialog
extends TitleAreaDialog {
    private static final String DIALOG_WIDTH = AbstractDialog.getDialogConstant("DIALOG_WIDTH", "DIALOG_WIDTH");
    private static final String DIALOG_HEIGHT = AbstractDialog.getDialogConstant("DIALOG_HEIGHT", "DIALOG_HEIGHT");
    private static final String DIALOG_FONT_DATA = AbstractDialog.getDialogConstant("DIALOG_FONT_DATA", "DIALOG_FONT_NAME");
    private static final String DIALOG_MESSAGE = "DIALOG_MESSAGE";
    private static final int WIDTH_MIN = 350;
    private static final int WIDTH_MAX = 5000;
    private static final int WIDTH_INC1 = 250;
    private static final int WIDTH_INC2 = 25;
    private static final Field messageLabelField;

    static {
        Field field = null;
        try {
            field = TitleAreaDialog.class.getDeclaredField("messageLabel");
            field.setAccessible(true);
        }
        catch (Throwable ex) {
            field = null;
        }
        messageLabelField = field;
    }

    public AbstractDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(68848);
    }

    public boolean close() {
        IDialogSettings settings;
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed() && (settings = this.getDialogBoundsSettings()) != null) {
            String message = this.getMessage();
            int strategy = this.getDialogBoundsStrategy();
            if ((strategy & 2) != 0) {
                settings.put(DIALOG_MESSAGE, message);
            }
        }
        return super.close();
    }

    protected IDialogSettings getPluginSettings() {
        return null;
    }

    protected String getDialogSettingsName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = this.getPluginSettings();
        if (settings == null) {
            return null;
        }
        String sectionName = this.getDialogSettingsName();
        if (sectionName == null) {
            return null;
        }
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    protected int getDialogBoundsStrategy() {
        return 2;
    }

    protected Point getInitialSize() {
        Point messageSize;
        Text messageLabel;
        IDialogSettings settings;
        Shell shell = this.getShell();
        Point result = shell.computeSize(-1, -1, true);
        Point minimum = this.getMinimumSize();
        result.x = Math.max(result.x, minimum.x);
        result.y = Math.max(result.y, minimum.y);
        if ((this.getDialogBoundsStrategy() & 2) != 0 && (settings = this.getDialogBoundsSettings()) != null && this.hasSameFont(settings) && this.hasSameMessage(settings)) {
            try {
                int width = settings.getInt(DIALOG_WIDTH);
                if (width != -1) {
                    result.x = width;
                }
            }
            catch (NumberFormatException width) {
                // empty catch block
            }
            try {
                int height = settings.getInt(DIALOG_HEIGHT);
                if (height != -1) {
                    result.y = height;
                }
            }
            catch (NumberFormatException height) {
                // empty catch block
            }
            return result;
        }
        try {
            messageLabel = (Text)messageLabelField.get((Object)this);
        }
        catch (Throwable ex) {
            return result;
        }
        String message = messageLabel.getText();
        messageLabel.setText("\n\n");
        int messageHeight = messageLabel.computeSize((int)-1, (int)-1).y;
        messageLabel.setText(message);
        result.x = 350;
        while (result.x < 5000) {
            result.x += 250;
            shell.setSize(result);
            messageSize = messageLabel.computeSize(messageLabel.getSize().x, -1);
            if (messageSize.y <= messageHeight) break;
        }
        result.x -= 250;
        while (result.x < 5000) {
            result.x += 25;
            shell.setSize(result);
            messageSize = messageLabel.computeSize(messageLabel.getSize().x, -1);
            if (messageSize.y <= messageHeight) break;
        }
        result = shell.computeSize(result.x + 25, -1, true);
        return result;
    }

    protected Point getMinimumSize() {
        return new Point(350, 0);
    }

    protected Control createDialogArea(Composite parent) {
        Shell shell = this.getShell();
        ImageDescriptor descriptor = Activator.imageDescriptorFromPlugin((String)"org.eclipse.userstorage.ui", (String)"icons/LoginBanner.png");
        final Image titleImage = descriptor.createImage((Device)shell.getDisplay());
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                titleImage.dispose();
            }
        });
        this.setTitleImage(titleImage);
        return super.createDialogArea(parent);
    }

    private boolean hasSameFont(IDialogSettings settings) {
        String previousFontData = settings.get(DIALOG_FONT_DATA);
        if (StringUtil.isEmpty((String)previousFontData)) {
            return false;
        }
        FontData[] fontDatas = JFaceResources.getDialogFont().getFontData();
        if (fontDatas.length == 0) {
            return false;
        }
        String currentFontData = fontDatas[0].toString();
        return previousFontData.equalsIgnoreCase(currentFontData);
    }

    private boolean hasSameMessage(IDialogSettings settings) {
        String previousMessage = settings.get(DIALOG_MESSAGE);
        if (StringUtil.isEmpty((String)previousMessage)) {
            return false;
        }
        String currentMessage = this.getMessage();
        return previousMessage.equals(currentMessage);
    }

    private static String getDialogConstant(String name, String defaultValue) {
        try {
            Field field = Dialog.class.getDeclaredField(name);
            field.setAccessible(true);
            return (String)field.get(null);
        }
        catch (Throwable throwable) {
            return defaultValue;
        }
    }
}

