/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.property.list;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.property.ListPropertyDetailValuesList;

public abstract class ListProperty<S, E>
implements IListProperty<S, E> {
    @Override
    public List<E> getList(S source) {
        if (source == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.doGetList(source));
    }

    protected List<E> doGetList(S source) {
        IObservableList<E> observable = this.observe(source);
        try {
            ArrayList<E> arrayList = new ArrayList<E>(observable);
            return arrayList;
        }
        finally {
            observable.dispose();
        }
    }

    @Override
    public final void setList(S source, List<E> list) {
        if (source != null) {
            this.doSetList(source, list);
        }
    }

    protected void doSetList(S source, List<E> list) {
        this.doUpdateList(source, Diffs.computeListDiff(this.doGetList(source), list));
    }

    @Override
    public final void updateList(S source, ListDiff<E> diff) {
        if (source != null) {
            this.doUpdateList(source, diff);
        }
    }

    protected void doUpdateList(S source, ListDiff<E> diff) {
        IObservableList<E> observable = this.observe(source);
        try {
            diff.applyTo(observable);
        }
        finally {
            observable.dispose();
        }
    }

    @Override
    public IObservableList<E> observe(S source) {
        return this.observe(Realm.getDefault(), source);
    }

    @Override
    public IObservableFactory<S, IObservableList<E>> listFactory() {
        return target -> this.observe(target);
    }

    @Override
    public IObservableFactory<S, IObservableList<E>> listFactory(Realm realm) {
        return target -> this.observe(realm, target);
    }

    @Override
    public <U extends S> IObservableList<E> observeDetail(IObservableValue<U> master) {
        return MasterDetailObservables.detailList(master, this.listFactory(master.getRealm()), (Object)this.getElementType());
    }

    @Override
    public final <T> IListProperty<S, T> values(IValueProperty<? super E, T> detailValue) {
        return new ListPropertyDetailValuesList(this, detailValue);
    }
}

