/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.ui;

import org.eclipse.oomph.p2.internal.ui.AgentManagerComposite;
import org.eclipse.oomph.p2.internal.ui.P2UIPlugin;
import org.eclipse.oomph.ui.OomphDialog;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class AgentManagerDialog
extends OomphDialog {
    public static final String TITLE = "Bundle Pool Management";
    public static final String MESSAGE = "Manage your p2 agents and bundle pools";
    private Object selectedElement;
    private AgentManagerComposite composite;

    public AgentManagerDialog(Shell parentShell) {
        super(parentShell, TITLE, 700, 500, (OomphUIPlugin)P2UIPlugin.INSTANCE, false);
        this.setShellStyle(68656);
    }

    public Object getSelectedElement() {
        if (this.composite == null) {
            return this.selectedElement;
        }
        return this.composite.getSelectedElement();
    }

    public void setSelectedElement(Object selectedElement) {
        this.selectedElement = selectedElement;
    }

    public final AgentManagerComposite getComposite() {
        return this.composite;
    }

    protected String getShellText() {
        return TITLE;
    }

    protected String getDefaultMessage() {
        return "Manage your p2 agents and bundle pools.";
    }

    protected String getImagePath() {
        return "wizban/AgentManager.png";
    }

    protected int getContainerMargin() {
        return 10;
    }

    protected void createUI(Composite parent) {
        this.getShell().setImage(P2UIPlugin.INSTANCE.getSWTImage("obj16/bundlePool"));
        this.composite = new AgentManagerComposite(parent, 0, this.selectedElement){

            protected void elementChanged(Object element) {
                super.elementChanged(element);
                AgentManagerDialog.this.elementChanged(element);
            }

            protected void profilesShown(boolean profilesShown) {
                super.profilesShown(profilesShown);
                String message = "Manage your p2 agents and bundle pools.";
                if (profilesShown) {
                    message = String.valueOf(message) + " Double-click profiles to see their details.";
                }
                AgentManagerDialog.this.setMessage(message);
            }
        };
        this.composite.setLayoutData(new GridData(1808));
    }

    protected void elementChanged(Object element) {
    }
}

