/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.workbench.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.workbench.FileAssociationsTask;
import org.eclipse.oomph.setup.workbench.FileEditor;
import org.eclipse.oomph.setup.workbench.FileMapping;
import org.eclipse.oomph.setup.workbench.WorkbenchPackage;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.FileEditorMapping;
import org.eclipse.ui.internal.util.PrefUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileAssociationsTaskImpl
extends SetupTaskImpl
implements FileAssociationsTask {
    protected EList<FileMapping> mappings;

    protected FileAssociationsTaskImpl() {
    }

    protected EClass eStaticClass() {
        return WorkbenchPackage.Literals.FILE_ASSOCIATIONS_TASK;
    }

    @Override
    public EList<FileMapping> getMappings() {
        if (this.mappings == null) {
            this.mappings = new EObjectContainmentEList(FileMapping.class, (InternalEObject)this, 9);
        }
        return this.mappings;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                return ((InternalEList)this.getMappings()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                return this.getMappings();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.getMappings().clear();
                this.getMappings().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.getMappings().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return this.mappings != null && !this.mappings.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public Object getOverrideToken() {
        return this.getClass();
    }

    public void overrideFor(SetupTask overriddenSetupTask) {
        super.overrideFor(overriddenSetupTask);
        FileAssociationsTask overriddenFileAssociationsTask = (FileAssociationsTask)overriddenSetupTask;
        this.getMappings().addAll(overriddenFileAssociationsTask.getMappings());
    }

    public void consolidate() {
        HashMap<String, FileMapping> existingMappings = new HashMap<String, FileMapping>();
        Iterator it = this.getMappings().iterator();
        while (it.hasNext()) {
            FileMapping mapping = (FileMapping)it.next();
            String filePattern = mapping.getFilePattern();
            FileMapping existingMapping = (FileMapping)existingMappings.get(filePattern);
            if (existingMapping != null) {
                EList<FileEditor> existingEditors = existingMapping.getEditors();
                LinkedHashSet<FileEditor> editors = new LinkedHashSet<FileEditor>((Collection<FileEditor>)existingEditors);
                editors.addAll((Collection<FileEditor>)mapping.getEditors());
                existingEditors.clear();
                existingEditors.addAll(editors);
                String defaultEditorID = mapping.getDefaultEditorID();
                if (!StringUtil.isEmpty((String)defaultEditorID)) {
                    existingMapping.setDefaultEditorID(defaultEditorID);
                }
                it.remove();
                continue;
            }
            existingMappings.put(filePattern, mapping);
        }
    }

    public int getProgressMonitorWork() {
        return 0;
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        Map<String, FileEditorMapping> fileEditorMappings = FileAssociationsTaskImpl.getFileEditorMappings();
        for (FileMapping mapping : this.getMappings()) {
            IEditorDescriptor defaultEditor;
            FileEditorMapping fileEditorMapping = fileEditorMappings.get(mapping.getFilePattern());
            if (fileEditorMapping == null) {
                return true;
            }
            EditorRegistry registry = (EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry();
            String defaultEditorID = mapping.getDefaultEditorID();
            if (!StringUtil.isEmpty((String)defaultEditorID) && (defaultEditor = registry.findEditor(defaultEditorID)) != null) {
                String mappingDefaultEditorID;
                IEditorDescriptor mappingDefaultEditor = fileEditorMapping.getDefaultEditor();
                String string = mappingDefaultEditorID = mappingDefaultEditor == null ? null : mappingDefaultEditor.getId();
                if (!ObjectUtil.equals((Object)mappingDefaultEditorID, (Object)defaultEditorID)) {
                    return true;
                }
            }
            Set<String> editorIDs = this.getEditorIDs((IFileEditorMapping)fileEditorMapping);
            for (FileEditor fileEditor : mapping.getEditors()) {
                String editorID = fileEditor.getID();
                if (registry.findEditor(editorID) == null || editorIDs.contains(editorID)) continue;
                return true;
            }
        }
        return false;
    }

    public void perform(SetupTaskContext context) throws Exception {
        final EditorRegistry registry = (EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry();
        final Map<String, FileEditorMapping> fileEditorMappings = FileAssociationsTaskImpl.getFileEditorMappings();
        for (FileMapping mapping : this.getMappings()) {
            IEditorDescriptor defaultEditor;
            Iterator extension;
            String filePattern = mapping.getFilePattern();
            FileEditorMapping fileEditorMapping = fileEditorMappings.get(filePattern);
            if (fileEditorMapping == null) {
                int lastDot = filePattern.lastIndexOf(46);
                String name = lastDot == -1 ? filePattern : filePattern.substring(0, lastDot);
                Iterator iterator = extension = lastDot == -1 ? null : filePattern.substring(lastDot + 1);
                if (StringUtil.isEmpty((String)name)) {
                    name = "." + (String)((Object)extension);
                    extension = null;
                }
                fileEditorMapping = new FileEditorMapping(name, (String)((Object)extension));
                fileEditorMappings.put(filePattern, fileEditorMapping);
            }
            Set<String> editorIDs = this.getEditorIDs((IFileEditorMapping)fileEditorMapping);
            extension = mapping.getEditors().iterator();
            while (extension.hasNext()) {
                IEditorDescriptor editor;
                FileEditor fileEditor = (FileEditor)extension.next();
                String editorID = fileEditor.getID();
                if (editorIDs.contains(editorID) || !((editor = registry.findEditor(editorID)) instanceof EditorDescriptor)) continue;
                fileEditorMapping.addEditor((EditorDescriptor)editor);
            }
            String defaultEditorID = mapping.getDefaultEditorID();
            if (StringUtil.isEmpty((String)defaultEditorID) || !((defaultEditor = registry.findEditor(defaultEditorID)) instanceof EditorDescriptor)) continue;
            fileEditorMapping.setDefaultEditor((EditorDescriptor)defaultEditor);
        }
        this.performUI(context, new SetupTaskImpl.RunnableWithContext(){

            public void run(SetupTaskContext context) throws Exception {
                registry.setFileEditorMappings(fileEditorMappings.values().toArray(new FileEditorMapping[fileEditorMappings.size()]));
                registry.saveAssociations();
                PrefUtil.savePrefs();
            }
        });
    }

    private static Map<String, FileEditorMapping> getFileEditorMappings() {
        HashMap<String, FileEditorMapping> result = new HashMap<String, FileEditorMapping>();
        IFileEditorMapping[] mappings = PlatformUI.getWorkbench().getEditorRegistry().getFileEditorMappings();
        int i = 0;
        while (i < mappings.length) {
            IFileEditorMapping mapping = mappings[i];
            if (mapping instanceof FileEditorMapping) {
                String name = mapping.getName();
                String extension = mapping.getExtension();
                String pattern = String.valueOf(name) + (StringUtil.isEmpty((String)extension) ? "" : "." + extension);
                result.put(pattern, (FileEditorMapping)mapping);
            }
            ++i;
        }
        return result;
    }

    private Set<String> getEditorIDs(IFileEditorMapping mapping) {
        HashSet<String> ids = new HashSet<String>();
        IEditorDescriptor[] editors = mapping.getEditors();
        int i = 0;
        while (i < editors.length) {
            IEditorDescriptor editor = editors[i];
            String editorID = editor.getId();
            ids.add(editorID);
            ++i;
        }
        return ids;
    }
}

