/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.tests;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OomphPlugin;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTest {
    private static final PrintStream LOG = System.out;
    public static final IProgressMonitor LOGGER = new IProgressMonitor(){
        private String message = "";

        public void beginTask(String name, int totalWork) {
            this.filter(name);
        }

        public void done() {
        }

        public void internalWorked(double work) {
        }

        public boolean isCanceled() {
            return false;
        }

        public void setCanceled(boolean value) {
        }

        public void setTaskName(String name) {
            this.filter(name);
        }

        public void subTask(String name) {
            this.filter(name);
        }

        public void worked(int work) {
        }

        private void filter(String message) {
            if (message == null) {
                message = "";
            }
            if (!message.equals(this.message)) {
                AbstractTest.log(message);
            }
            this.message = message;
        }
    };
    @Rule
    public TestName testName = new TestName();
    private File userHome;

    @Before
    public void setUp() throws Exception {
        AbstractTest.log("=========================================================================================================================\n" + this.testName.getMethodName() + "\n=========================================================================================================================\n");
    }

    @After
    public void tearDown() throws Exception {
        LOGGER.setTaskName(null);
    }

    public static File createTempFolder() {
        try {
            File folder = File.createTempFile("test-", "");
            folder.delete();
            folder.mkdirs();
            return folder;
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    public File getUserHome() {
        if (this.userHome == null) {
            this.userHome = AbstractTest.createTempFolder();
        }
        return this.userHome;
    }

    public File getTestFolder(OomphPlugin plugin, String name) {
        try {
            File folder = new File(this.getUserHome(), name);
            if (plugin != null) {
                OomphPlugin.BundleFile rootFile = plugin.getRootFile();
                OomphPlugin.BundleFile testRoot = rootFile.getChild("tests");
                OomphPlugin.BundleFile child = testRoot.getChild(name);
                child.export(folder);
                AbstractTest.log("Copied plugin://" + plugin.getSymbolicName() + "/" + child + " to " + folder);
            } else {
                IOUtil.mkdirs((File)folder);
                AbstractTest.log("Created folder " + folder);
            }
            return folder;
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public static void log() {
        LOG.println();
    }

    public static void log(Object object) {
        LOG.println(object);
    }

    public static Matcher<Object> isNull() {
        return IsNull.nullValue();
    }
}

