/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.VersionSegment;
import org.eclipse.oomph.resources.EclipseProjectFactory;
import org.eclipse.oomph.resources.ProjectHandler;
import org.eclipse.oomph.resources.SourceLocator;
import org.eclipse.oomph.resources.backend.BackendContainer;
import org.eclipse.oomph.resources.impl.SourceLocatorImpl;
import org.eclipse.oomph.targlets.IUGenerator;
import org.eclipse.oomph.targlets.core.WorkspaceIUInfo;
import org.eclipse.oomph.targlets.internal.core.TargletsCorePlugin;
import org.eclipse.oomph.targlets.util.VersionGenerator;
import org.eclipse.oomph.util.OomphPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceIUAnalyzer {
    public static final String IU_PROPERTY_WORKSPACE = "org.eclipse.oomph.targlet.workspace";
    private final MultiStatus status = new MultiStatus(TargletsCorePlugin.INSTANCE.getSymbolicName(), 0, "Workspace IU Analysis", null);
    private final Map<IInstallableUnit, WorkspaceIUInfo> workspaceIUInfos = new HashMap<IInstallableUnit, WorkspaceIUInfo>();
    private final Map<String, Version> iuVersions = new HashMap<String, Version>();
    private final String qualifierReplacement;
    private Map<String, Requirement> omniRootRequirements;

    public WorkspaceIUAnalyzer(EList<Requirement> rootRequirements) {
        this(rootRequirements, VersionGenerator.generateQualifierReplacement());
    }

    public WorkspaceIUAnalyzer(EList<Requirement> rootRequirements, String qualifierReplacement) {
        this.qualifierReplacement = qualifierReplacement;
        if (qualifierReplacement != null && rootRequirements != null) {
            this.omniRootRequirements = new HashMap<String, Requirement>();
            for (Requirement requirement : rootRequirements) {
                if (!VersionRange.emptyRange.equals((Object)requirement.getVersionRange())) continue;
                this.omniRootRequirements.put(requirement.getName(), requirement);
            }
        }
    }

    public Map<IInstallableUnit, WorkspaceIUInfo> getWorkspaceIUInfos() {
        return this.workspaceIUInfos;
    }

    public Map<String, Version> getIUVersions() {
        return this.iuVersions;
    }

    public String getQualifierReplacement() {
        return this.qualifierReplacement;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public void analyze(SourceLocator sourceLocator, final EList<IUGenerator> iuGenerators, IProgressMonitor monitor) {
        sourceLocator.handleProjects(EclipseProjectFactory.LIST, new ProjectHandler(){

            public void handleProject(IProject project, BackendContainer backendContainer) {
                try {
                    EList installableUnits = null;
                    IUGenerator generator = null;
                    for (IUGenerator iuGenerator : iuGenerators) {
                        try {
                            EList ius = iuGenerator.generateIUs(project, WorkspaceIUAnalyzer.this.qualifierReplacement, WorkspaceIUAnalyzer.this.iuVersions);
                            if (ius == null || ius.isEmpty()) continue;
                            installableUnits = ius;
                            generator = iuGenerator;
                            break;
                        }
                        catch (Exception ex) {
                            WorkspaceIUAnalyzer.this.log(project, ex);
                        }
                    }
                    if (installableUnits != null) {
                        for (IInstallableUnit installableUnit : installableUnits) {
                            if (!(installableUnit instanceof InstallableUnit)) continue;
                            ((InstallableUnit)installableUnit).setProperty(WorkspaceIUAnalyzer.IU_PROPERTY_WORKSPACE, Boolean.TRUE.toString());
                        }
                        for (IUGenerator iuModifier : iuGenerators) {
                            if (iuModifier == generator) continue;
                            try {
                                IInstallableUnit mainIU = (IInstallableUnit)installableUnits.get(0);
                                iuModifier.modifyIU(mainIU, project, WorkspaceIUAnalyzer.this.qualifierReplacement, WorkspaceIUAnalyzer.this.iuVersions);
                            }
                            catch (Exception ex) {
                                WorkspaceIUAnalyzer.this.log(project, ex);
                            }
                        }
                        boolean main = true;
                        for (IInstallableUnit installableUnit : installableUnits) {
                            WorkspaceIUAnalyzer.this.adjustOmniRootRequirements(installableUnit);
                            WorkspaceIUInfo info = null;
                            if (main) {
                                String projectName = project.getName();
                                info = new WorkspaceIUInfo(backendContainer, projectName);
                                main = false;
                            }
                            WorkspaceIUAnalyzer.this.workspaceIUInfos.put(installableUnit, info);
                        }
                    }
                }
                catch (Exception ex) {
                    WorkspaceIUAnalyzer.this.log(project, ex);
                }
            }
        }, this.status, monitor);
    }

    private void adjustOmniRootRequirements(IInstallableUnit iu) {
        Requirement requirement;
        if (this.omniRootRequirements != null && (requirement = this.omniRootRequirements.remove(iu.getId())) != null) {
            requirement.setVersionRange(P2Factory.eINSTANCE.createVersionRange(iu.getVersion(), VersionSegment.MICRO));
            if (this.omniRootRequirements.isEmpty()) {
                this.omniRootRequirements = null;
            }
        }
    }

    protected void log(IProject project, Exception ex) {
        SourceLocatorImpl.addStatus((MultiStatus)this.status, (OomphPlugin)TargletsCorePlugin.INSTANCE, (String)("project " + project.getName()), (Object)ex);
    }
}

