/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.router;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.persistence.service.DAO;
import org.eclipse.om2m.persistence.service.DBService;

public class Patterns
implements Constants {
    public final String ALL_SHORT_NAMES = "acp|ae|cnt|cin|csr|la|ol|grp|fopt|sub|pch|pcu|req|nod|ani|andi|fcnt|dac";
    public final String NON_HIERARCHICAL_ID = "(" + Constants.PREFIX_SEPERATOR + "(\\b\\w+\\b)?)";
    public final Pattern UNAUTHORIZED_NAMES = Pattern.compile("acp" + this.NON_HIERARCHICAL_ID + "?|" + "ae" + this.NON_HIERARCHICAL_ID + "?|" + "cnt" + this.NON_HIERARCHICAL_ID + "?|" + "cin" + this.NON_HIERARCHICAL_ID + "?|" + "csr" + this.NON_HIERARCHICAL_ID + "?|" + "la" + this.NON_HIERARCHICAL_ID + "?|" + "ol" + this.NON_HIERARCHICAL_ID + "?|" + "grp" + this.NON_HIERARCHICAL_ID + "?|" + "fopt" + this.NON_HIERARCHICAL_ID + "?|" + "sub" + this.NON_HIERARCHICAL_ID + "?|" + "pch" + "?|" + "pcu" + "?|" + "req" + "?|" + "nod" + "?|" + "fcnt" + "?|" + "dac" + "?");
    public final String ID_STRING = "([A-Za-z0-9_\\-~#]|\\.)+";
    public final Pattern ID_PATTERN = Pattern.compile("([A-Za-z0-9_\\-~#]|\\.)+");
    public final Pattern CSE_BASE_PATTERN = Pattern.compile("/" + Constants.CSE_ID);
    public final Pattern ACP_PATTERN = Pattern.compile(this.CSE_BASE_PATTERN + "/" + "acp" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~#]|\\.)+");
    public final Pattern AE_PATTERN = Pattern.compile(this.CSE_BASE_PATTERN + "/" + "(C|S)" + "([A-Za-z0-9_\\-~#]|\\.)+");
    public final Pattern AEANNC_PATTERN = Pattern.compile(this.CSE_BASE_PATTERN + "/" + "aeA" + "([A-Za-z0-9_\\-~#]|\\.)+");
    public final Pattern CONTAINER_PATTERN = Pattern.compile(this.CSE_BASE_PATTERN + "/" + "cnt" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~#]|\\.)+");
    public final Pattern DYNAMIC_AUTHORIZATION_CONSULTATION_PATTERN = Pattern.compile(this.CSE_BASE_PATTERN + "/" + "dac" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~#]|\\.)+");
    public final Pattern FLEXCONTAINER_PATTERN = Pattern.compile(this.CSE_BASE_PATTERN + "/" + "fcnt" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~#]|\\.)+");
    public final Pattern FLEXCONTAINER_ANNC_PATTERN = Pattern.compile(this.CSE_BASE_PATTERN + "/" + "fcnta" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~#]|\\.)+");
    public final Pattern CONTENTINSTANCE_PATTERN = Pattern.compile(this.CSE_BASE_PATTERN + "/" + "cin" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~#]|\\.)+");
    public final Pattern REMOTE_CSE_PATTERN = Pattern.compile(this.CSE_BASE_PATTERN + "/" + "csr" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~#]|\\.)+");
    public final Pattern GROUP_PATTERN = Pattern.compile(this.CSE_BASE_PATTERN + "/" + "grp" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~#]|\\.)+");
    public final Pattern SUBSCRIPTION_PATTERN = Pattern.compile(this.CSE_BASE_PATTERN + "/" + "sub" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~#]|\\.)+");
    public final Pattern POLLING_CHANNEL_PATTERN = Pattern.compile(this.CSE_BASE_PATTERN + "/" + "pch" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~#]|\\.)+");
    public final Pattern POLLING_CHANNEL_URI_PATTERN = Pattern.compile(this.CSE_BASE_PATTERN + "/" + "pcu" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~#]|\\.)+");
    public final Pattern REQUEST_PATTERN = Pattern.compile(this.CSE_BASE_PATTERN + "/" + "req" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~#]|\\.)+");
    public final Pattern NON_RETARGETING_PATTERN = Pattern.compile("/" + Constants.CSE_ID + "(/(" + "([A-Za-z0-9_\\-~#]|\\.)+" + ")?)*");
    public final String FANOUT_POINT_MATCH = "/fopt";
    public final Pattern NODE_PATTERN = Pattern.compile(this.CSE_BASE_PATTERN + "/" + "nod" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~#]|\\.)+");
    public final Pattern AREA_NW_INFO_PATTERN = Pattern.compile(this.CSE_BASE_PATTERN + "/" + "ani" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~#]|\\.)+");
    public final Pattern AREA_NWK_DEVICE_INFO_PATTERN = Pattern.compile(this.CSE_BASE_PATTERN + "/" + "andi" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~#]|\\.)+");
    public final Pattern NON_HIERARCHICAL_PATTERN = Pattern.compile("(" + this.CSE_BASE_PATTERN + "/(" + "acp|ae|cnt|cin|csr|la|ol|grp|fopt|sub|pch|pcu|req|nod|ani|andi|fcnt|dac" + ")" + Constants.PREFIX_SEPERATOR + "([A-Za-z0-9_\\-~#]|\\.)+" + ")|(" + this.CSE_BASE_PATTERN + ")|" + this.AE_PATTERN.pattern());
    public final Pattern HIERARCHICAL_PATTERN = Pattern.compile(this.CSE_BASE_PATTERN + "(/" + Constants.CSE_NAME + "(/" + this.ID_PATTERN + ")*)?");

    public boolean match(Pattern pattern, String uri) {
        Matcher m = pattern.matcher(uri);
        return m.matches();
    }

    public DAO<?> getDAO(String uri, DBService db) {
        if (this.match(this.CSE_BASE_PATTERN, uri)) {
            return db.getDAOFactory().getCSEBaseDAO();
        }
        if (this.match(this.ACP_PATTERN, uri)) {
            return db.getDAOFactory().getAccessControlPolicyDAO();
        }
        if (this.match(this.AE_PATTERN, uri)) {
            return db.getDAOFactory().getAeDAO();
        }
        if (this.match(this.AEANNC_PATTERN, uri)) {
            return db.getDAOFactory().getAeAnncDAO();
        }
        if (this.match(this.CONTAINER_PATTERN, uri)) {
            return db.getDAOFactory().getContainerDAO();
        }
        if (this.match(this.DYNAMIC_AUTHORIZATION_CONSULTATION_PATTERN, uri)) {
            return db.getDAOFactory().getDynamicAuthorizationDAO();
        }
        if (this.match(this.FLEXCONTAINER_PATTERN, uri)) {
            return db.getDAOFactory().getFlexContainerDAO();
        }
        if (this.match(this.FLEXCONTAINER_ANNC_PATTERN, uri)) {
            return db.getDAOFactory().getFlexContainerAnncDAO();
        }
        if (this.match(this.CONTENTINSTANCE_PATTERN, uri)) {
            return db.getDAOFactory().getContentInstanceDAO();
        }
        if (this.match(this.REMOTE_CSE_PATTERN, uri)) {
            return db.getDAOFactory().getRemoteCSEDAO();
        }
        if (this.match(this.GROUP_PATTERN, uri)) {
            return db.getDAOFactory().getGroupDAO();
        }
        if (this.match(this.SUBSCRIPTION_PATTERN, uri)) {
            return db.getDAOFactory().getSubsciptionDAO();
        }
        if (this.match(this.POLLING_CHANNEL_PATTERN, uri)) {
            return db.getDAOFactory().getPollingChannelDAO();
        }
        if (this.match(this.REQUEST_PATTERN, uri)) {
            return db.getDAOFactory().getRequestEntityDAO();
        }
        if (this.match(this.NODE_PATTERN, uri)) {
            return db.getDAOFactory().getNodeEntityDAO();
        }
        return null;
    }

    public boolean checkResourceName(String resourceName) {
        return this.match(this.ID_PATTERN, resourceName);
    }
}

