/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.types;

import org.eclipse.om2m.sdt.Identifiers;

public enum DeviceType implements Identifiers
{
    deviceAirConditioner(1, "deviceAirConditioner", "deviceAirConditioner", "deACr"),
    deviceClothesWasher(2, "deviceClothesWasher", "deviceClothesWasher", "deCWr"),
    deviceElectricVehicleCharger(3, "deviceElectricVehicleCharger", "deviceElectricVehicleCharger", "dEVCr"),
    deviceLight(4, "deviceLight", "deviceLight", "devLt"),
    deviceMicrogeneration(5, "deviceMicrogeneration", "deviceMicrogeneration", "devMn"),
    deviceOven(6, "deviceOven", "deviceOven", "devOn"),
    deviceRefrigerator(7, "deviceRefrigerator", "deviceRefrigerator", "devRr"),
    deviceRobotCleaner(8, "deviceRobotCleaner", "deviceRobotCleaner", "devRCr"),
    deviceSmartElectricMeter(9, "deviceSmartElectricMeter", "deviceSmartElectricMeter", "dSEMr"),
    deviceStorageBattery(10, "deviceStorageBattery", "deviceStorageBattery", "deSBy"),
    deviceTelevision(11, "deviceTelevision", "deviceTelevision", "devTn"),
    deviceThermostat(12, "deviceThermostat", "deviceThermostat", "devTt"),
    deviceWaterHeater(13, "deviceWaterHeater", "deviceWaterHeater", "devWHr"),
    deviceCoffeeMachine(14, "deviceCoffeeMachine", "deviceCoffeeMachine", "dCeMe"),
    deviceKettle(15, "deviceKettle", "deviceKettle", "dKtle"),
    deviceDoor(100, "deviceDoor", "deviceDoor", "devDr"),
    deviceSmokeExtractor(101, "deviceSmokeExtractor", "deviceSmokeExtractor", "dSeEr"),
    deviceSwitchButton(102, "deviceSwitchButton", "deviceSwitchButton", "dShBn"),
    deviceWarningDevice(103, "deviceWarningDevice", "deviceWarningDevice", "deWDe"),
    deviceGasValve(200, "deviceGasValve", "deviceGasValve", "dGsVe"),
    deviceWaterValve(201, "deviceWaterValve", "deviceWaterValve", "deWVe"),
    deviceFloodDetector(300, "deviceFloodDetector", "deviceFloodDetector", "deFDr"),
    deviceMotionDetector(301, "deviceMotionDetector", "deviceMotionDetector", "deMDr"),
    deviceSmokeDetector(302, "deviceSmokeDetector", "deviceSmokeDetector", "deSDr"),
    deviceTemperatureDetector(303, "deviceTemperatureDetector", "deviceTemperatureDetector", "deTDr"),
    deviceContactDetector(304, "deviceContactDetector", "deviceContactDetector", "deCDr"),
    deviceCamera(400, "deviceCamera", "deviceCamera", "devCa"),
    deviceWeatherStation(500, "deviceWeatherStation", "deviceWeatherStation", "deWSn"),
    deviceNumberDevice(600, "deviceNumberDevice", "deviceNumberDevice", "deNDe"),
    undefinedVendorExt(0, "undefinedVendorExt", "", "");

    public static final String PATH = "org.onem2m.home.device.";
    private int value;
    private final String def;
    private final String longDefinitionName;
    private final String shortDefinitionName;

    private DeviceType(int v, String s, String longDef, String shortDef) {
        this.value = v;
        this.def = s;
        this.longDefinitionName = longDef;
        this.shortDefinitionName = shortDef;
    }

    public int getValue() {
        return this.value;
    }

    public String getDefinition() {
        return PATH + this.def;
    }

    public String getLongName() {
        return this.longDefinitionName;
    }

    public String getShortName() {
        return this.shortDefinitionName;
    }

    public static DeviceType fromValue(int v) {
        DeviceType[] deviceTypeArray = DeviceType.values();
        int n = deviceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceType c = deviceTypeArray[n2];
            if (c.value == v) {
                return c;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Undefined value " + v);
    }

    public static DeviceType fromValue(String def) {
        DeviceType[] deviceTypeArray = DeviceType.values();
        int n = deviceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceType c = deviceTypeArray[n2];
            if (c.def.equals(def)) {
                return c;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Undefined definition " + def);
    }
}

