/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.FloatDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class AtmosphericPressureSensor
extends Module {
    private FloatDataPoint atmosphericPressure;

    public AtmosphericPressureSensor(String name, Domain domain, FloatDataPoint atmosphericPressure) {
        super(name, domain, (Identifiers)ModuleType.atmosphericPressureSensor);
        if (atmosphericPressure == null || !atmosphericPressure.getShortDefinitionType().equals(DatapointType.atmosphericPressure.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong atmosphericPressure datapoint: " + atmosphericPressure);
        }
        this.atmosphericPressure = atmosphericPressure;
        this.atmosphericPressure.setWritable(false);
        this.atmosphericPressure.getDataType().setUnitOfMeasure("Mbar");
        this.atmosphericPressure.setDoc("Current Atmospheric Pressure In Mbar");
        this.addDataPoint((DataPoint)this.atmosphericPressure);
    }

    public AtmosphericPressureSensor(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (FloatDataPoint)dps.get(DatapointType.atmosphericPressure.getShortName()));
    }

    public float getAtmosphericPressure() throws DataPointException, AccessException {
        return ((Float)this.atmosphericPressure.getValue()).floatValue();
    }
}

