/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.om2m.sdt.Action;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Device;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Element;
import org.eclipse.om2m.sdt.Event;
import org.eclipse.om2m.sdt.Extended;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.Property;
import org.eclipse.om2m.sdt.events.SDTEventListener;
import org.eclipse.om2m.sdt.events.SDTNotification;
import org.eclipse.om2m.sdt.utils.Activator;
import org.eclipse.om2m.sdt.utils.Logger;

public abstract class ModuleClass
extends Element {
    private static final Identifiers OWNER = new Identifiers(){

        @Override
        public String getShortName() {
            return "owner";
        }

        @Override
        public String getLongName() {
            return "owner";
        }

        @Override
        public String getDefinition() {
            return "owner";
        }
    };
    private Extended extended;
    private boolean optional;
    private Map<String, Action> actions;
    private Map<String, DataPoint> dataPoints;
    private Map<String, DataPoint> dataPointsByShortDefinitionType;
    private Map<String, Event> events;
    private Map<String, Property> properties;
    private Device owner;

    ModuleClass(String id, Domain domain) {
        super(id);
        if (domain.getModule(id) != null) {
            String msg = "Already a module with name " + id + " in domain " + domain;
            Logger.warning(msg);
            throw new IllegalArgumentException(msg);
        }
        this.optional = false;
        this.actions = new HashMap<String, Action>();
        this.dataPoints = new HashMap<String, DataPoint>();
        this.dataPointsByShortDefinitionType = new HashMap<String, DataPoint>();
        this.events = new HashMap<String, Event>();
        this.properties = new HashMap<String, Property>();
        domain.addModule(this);
    }

    public String getPid() {
        return this.getName().replaceAll("\\.", "_");
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public Collection<String> getActionNames() {
        return this.actions.keySet();
    }

    public Collection<Action> getActions() {
        return this.actions.values();
    }

    public Action getAction(String name) {
        return this.actions.get(name);
    }

    public void addAction(Action action) {
        if (this.actions.get(action.getName()) != null) {
            String msg = "Already an action with name " + action.getName() + " in module " + this.getName();
            Logger.warning(msg);
            throw new IllegalArgumentException(msg);
        }
        action.setParent((Module)this);
        action.setOwner(this.owner);
        this.actions.put(action.getName(), action);
    }

    public void removeAction(String name) {
        this.actions.remove(name);
    }

    public Collection<String> getDataPointNames() {
        return this.dataPoints.keySet();
    }

    public Collection<DataPoint> getDataPoints() {
        return this.dataPoints.values();
    }

    public DataPoint getDataPoint(String name) {
        return this.dataPoints.get(name);
    }

    public DataPoint getDataPointByShortName(String shortDefinitionType) {
        return this.dataPointsByShortDefinitionType.get(shortDefinitionType);
    }

    public void addDataPoint(DataPoint dp) {
        if (this.dataPoints.get(dp.getName()) != null) {
            String msg = "Already a datapoint with name " + dp.getName() + " in module " + this.getName();
            Logger.warning(msg);
            throw new IllegalArgumentException(msg);
        }
        dp.setParent((Module)this);
        if (dp.getShortDefinitionType() == null) {
            String msg = "Short definition type is null of " + dp.getName() + " in module " + this.getName();
            Logger.warning(msg);
            throw new IllegalArgumentException(msg);
        }
        this.dataPoints.put(dp.getName(), dp);
        this.dataPointsByShortDefinitionType.put(dp.getShortDefinitionType(), dp);
        if (this.owner != null) {
            dp.setOwner(this.owner);
        }
    }

    public void removeDataPoint(String name) {
        DataPoint dp = this.dataPoints.remove(name);
        if (dp != null) {
            this.dataPointsByShortDefinitionType.remove(dp.getShortDefinitionType());
        }
    }

    public Collection<String> getEventNames() {
        return this.events.keySet();
    }

    public Collection<Event> getEvents() {
        return this.events.values();
    }

    public Event getEvent(String name) {
        return this.events.get(name);
    }

    public void addEvent(Event evt) {
        try {
            evt.setTimeStamp();
            this.events.put(evt.getName(), evt);
            Logger.info("New event " + evt + " for module " + this);
            for (DataPoint dp : evt.getDataPoints()) {
                this.notifyListeners(evt.getName(), evt.getValue(), dp);
            }
        }
        catch (Exception e) {
            Logger.warning("Error notifying event", e);
        }
    }

    private void notifyListeners(String name, Object val, DataPoint dp) {
        if (this.dataPoints.get(dp.getName()) == null) {
            Logger.warning("Wrong datapoint " + dp + ". Not in module " + this + ". Ignored...");
            return;
        }
        Collection<SDTEventListener> listeners = Activator.getListeners((Module)this, dp);
        if (listeners.isEmpty()) {
            Logger.info("No listener to be notified");
            return;
        }
        Logger.info("notify " + listeners.size() + " listeners");
        SDTNotification notif = new SDTNotification(name, val, this.owner, this, dp);
        for (SDTEventListener l : listeners) {
            try {
                if (Activator.isGrantedEventAccess(l, dp)) {
                    l.handleNotification(notif);
                    continue;
                }
                Logger.info("Non authorized listener " + l.getClass());
            }
            catch (Exception e) {
                Logger.warning("Error handling notification " + notif + " by listener " + l.getClass(), e);
            }
        }
    }

    public void removeEvent(String name) {
        this.events.remove(name);
    }

    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public Collection<Property> getProperties() {
        return this.properties.values();
    }

    public Property getProperty(String name) {
        return this.properties.get(name);
    }

    public Property getPropertyByShortName(String shortDefinitionType) {
        for (Property property : this.properties.values()) {
            if (!property.getShortName().equals(shortDefinitionType)) continue;
            return property;
        }
        return null;
    }

    public void addProperty(Property arg) {
        this.properties.put(arg.getName(), arg);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public Extended getExtends() {
        return this.extended;
    }

    public void setExtends(String domain, String clazz) {
        this.extended = new Extended(domain, clazz);
    }

    @Override
    protected String prettyPrint(String t1) {
        String t2 = String.valueOf(t1) + "\t";
        StringBuffer ret = new StringBuffer(t1).append("<ModuleClass name=\"").append(this.getName()).append("\">");
        if (this.getDoc() != null) {
            ret.append("\n").append(t2).append(this.getDoc());
        }
        this.prettyPrint(ret, this.properties.values(), "Properties", t2);
        this.prettyPrint(ret, this.dataPoints.values(), "Data", t2);
        this.prettyPrint(ret, this.actions.values(), "Actions", t2);
        this.prettyPrint(ret, this.events.values(), "Events", t2);
        return ret.append("\n").append(t1).append("</ModuleClass>").toString();
    }

    void setOwner(Device owner) {
        this.owner = owner;
        this.addProperty(new Property(OWNER, owner.getPid()));
        for (DataPoint dp : this.dataPoints.values()) {
            dp.setOwner(owner);
        }
        for (Action a : this.actions.values()) {
            a.setOwner(owner);
        }
    }

    public Device getOwner() {
        return this.owner;
    }

    protected void finalize() throws Throwable {
        Logger.info("finalize " + this);
        this.actions.clear();
        this.dataPoints.clear();
        this.properties.clear();
        this.events.clear();
    }
}

