/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.dal.driver.sample.fan;

import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.dal.driver.sample.Activator;
import org.eclipse.om2m.dal.driver.sample.fan.function.Countdown;
import org.eclipse.om2m.dal.driver.sample.fan.function.FaultDetection;
import org.eclipse.om2m.dal.driver.sample.fan.function.Speed;
import org.eclipse.om2m.dal.driver.sample.fan.function.Switch;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.dal.Device;
import org.osgi.service.dal.DeviceException;
import org.osgi.service.dal.functions.data.AlarmData;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class FanDevice
extends JFrame
implements Device {
    private static final long serialVersionUID = -3749351505120115293L;
    private final ImageIcon iconFan1 = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/fan1.png"));
    private final ImageIcon iconFan2 = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/fan2.png"));
    private final ImageIcon iconFan3 = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/fan3.png"));
    private final ImageIcon iconFan4 = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/fan4.png"));
    private final ImageIcon iconFan5 = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/fan5.png"));
    private final ImageIcon iconFan6 = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/fan6.png"));
    private final ImageIcon iconFan7 = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/fan7.png"));
    private final ImageIcon iconFan8 = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/fan8.png"));
    private final ImageIcon iconFan9 = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/fan9.png"));
    private final ImageIcon iconFan10 = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/fan10.png"));
    private final ImageIcon iconFan11 = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/fan11.png"));
    private final ImageIcon iconFan12 = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/fan12.png"));
    private final ImageIcon iconFan13 = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/fan13.png"));
    private final ImageIcon[] iconFans = new ImageIcon[]{this.iconFan1, this.iconFan2, this.iconFan3, this.iconFan4, this.iconFan5, this.iconFan6, this.iconFan7, this.iconFan8, this.iconFan9, this.iconFan10, this.iconFan11, this.iconFan12, this.iconFan13};
    private final ImageIcon iconButton0_normal = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/button0_normal.png"));
    private final ImageIcon iconButton0_clicking = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/button0_clicking.png"));
    private final ImageIcon iconButton1_normal = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/button1_normal.png"));
    private final ImageIcon iconButton1_clicking = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/button1_clicking.png"));
    private final ImageIcon iconButton1_clicked = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/button1_clicked.png"));
    private final ImageIcon iconButton2_normal = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/button2_normal.png"));
    private final ImageIcon iconButton2_clicking = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/button2_clicking.png"));
    private final ImageIcon iconButton2_clicked = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/button2_clicked.png"));
    private final ImageIcon iconTimer0 = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/timer0.png"));
    private final ImageIcon iconTimer1 = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/timer1.png"));
    private final ImageIcon iconTimer2 = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/timer2.png"));
    private final ImageIcon iconTimer3 = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/timer3.png"));
    private final ImageIcon iconTimer4 = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/timer4.png"));
    private final ImageIcon iconTimer5 = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/timer5.png"));
    private final ImageIcon[] iconTimers = new ImageIcon[]{this.iconTimer0, this.iconTimer1, this.iconTimer2, this.iconTimer3, this.iconTimer4, this.iconTimer5};
    private final ImageIcon iconReduce_normal = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/reduce_normal.png"));
    private final ImageIcon iconReduce_clicked = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/reduce_clicked.png"));
    private final ImageIcon iconPlus_normal = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/plus_normal.png"));
    private final ImageIcon iconPlus_clicked = new ImageIcon(FrameworkUtil.getBundle(FanDevice.class).getResource("images/plus_clicked.png"));
    private static Log LOGGER = LogFactory.getLog(FanDevice.class);
    private final String DRIVER = "fan";
    private String devId = Integer.toHexString(1);
    private String uid = "fan:" + this.devId;
    private Dictionary<String, Object> props = null;
    private ServiceRegistration<?> devReg = null;
    private ServiceReference<?> devRef = null;
    private static int LEVEL_0_INTERVAL = 1000;
    private static int LEVEL_1_INTERVAL = 40;
    private static int LEVEL_2_INTERVAL = 25;
    private int interval = LEVEL_0_INTERVAL;
    private Switch powerService = new Switch(this.uid, "powerswitch");
    private Speed speedService = new Speed(this.uid, "speed");
    private Countdown countdownService = new Countdown(this.uid, "countdown");
    private FaultDetection faultDetectionService = new FaultDetection(this.uid, "faultdetection");
    private JPanel contentPane;
    private JPanel fanPane;
    private JPanel controlPane;
    private JLabel labelFan;
    private JLabel labelMinus;
    private JLabel labelTimer;
    private JLabel labelPlus;
    private JLabel labelButton0;
    private JLabel labelButton1;
    private JLabel labelButton2;
    private static FanDevice fanDevice = null;

    public static void init() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    FanDevice.fanDevice = new FanDevice(null);
                    fanDevice.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void stop() {
        try {
            fanDevice.remove();
        }
        catch (DeviceException e) {
            e.printStackTrace();
        }
    }

    private FanDevice() {
        this.setupDeviceProperties();
        LOGGER.info((Object)("Register FanDevice (" + this.uid + ") ..."));
        this.devReg = Activator.getContext().registerService(Device.class.getName(), (Object)this, this.props);
        this.devRef = this.devReg.getReference();
        LOGGER.info((Object)("FanDevice (" + this.uid + ") is registered."));
        this.setTitle("Simulated DAL Device");
        this.setLocationByPlatform(true);
        this.setVisible(false);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setBounds(10, 10, 650, 500);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(null);
        this.contentPane.setLayout(null);
        this.setContentPane(this.contentPane);
        this.fanPane = new JPanel();
        this.fanPane.setBounds(10, 10, 382, 429);
        this.fanPane.setLayout(null);
        this.controlPane = new JPanel();
        this.controlPane.setLayout(null);
        this.controlPane.setBounds(402, 10, 200, 429);
        this.contentPane.setLayout(null);
        this.contentPane.add(this.fanPane);
        this.contentPane.add(this.controlPane);
        this.labelFan = new JLabel("");
        this.labelFan.setIcon(this.iconFans[0]);
        this.labelFan.setBounds(0, 0, 382, 429);
        this.fanPane.add(this.labelFan);
        this.labelMinus = new JLabel("");
        this.labelMinus.setBounds(20, 85, 29, 120);
        this.labelMinus.setIcon(this.iconReduce_normal);
        this.labelMinus.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!FanDevice.this.validKey(e)) {
                    return;
                }
                try {
                    if (FanDevice.this.countdownService.getData().getLevel().compareTo(Countdown.MIN_VALUE) > 0) {
                        FanDevice.this.countdownService.reduce();
                    }
                }
                catch (DeviceException devException) {
                    devException.printStackTrace();
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                FanDevice.this.labelMinus.setIcon(FanDevice.this.iconReduce_clicked);
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                FanDevice.this.labelMinus.setIcon(FanDevice.this.iconReduce_normal);
            }
        });
        this.labelTimer = new JLabel("");
        this.labelTimer.setBounds(30, 85, 120, 120);
        this.labelTimer.setIcon(this.iconTimers[0]);
        this.labelPlus = new JLabel("");
        this.labelPlus.setBounds(142, 85, 29, 120);
        this.labelPlus.setIcon(this.iconPlus_normal);
        this.labelPlus.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!FanDevice.this.validKey(e)) {
                    return;
                }
                try {
                    if (FanDevice.this.countdownService.getData().getLevel().compareTo(Countdown.MAX_VALUE) < 0) {
                        FanDevice.this.countdownService.increase();
                    }
                }
                catch (DeviceException devException) {
                    devException.printStackTrace();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                FanDevice.this.labelPlus.setIcon(FanDevice.this.iconPlus_clicked);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                FanDevice.this.labelPlus.setIcon(FanDevice.this.iconPlus_normal);
            }
        });
        this.labelButton0 = new JLabel("");
        this.labelButton0.setIcon(this.iconButton0_normal);
        this.labelButton0.setBounds(30, 215, 50, 120);
        this.labelButton1 = new JLabel("");
        this.labelButton1.setIcon(this.iconButton1_normal);
        this.labelButton1.setBounds(80, 215, 50, 120);
        this.labelButton2 = new JLabel("");
        this.labelButton2.setIcon(this.iconButton2_normal);
        this.labelButton2.setBounds(130, 215, 50, 120);
        this.labelButton0.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (!FanDevice.this.validKey(arg0)) {
                    return;
                }
                try {
                    if (FanDevice.this.speedService.getData().getLevel().compareTo(Speed.LEVEL_0) != 0) {
                        FanDevice.this.speedService.setData(Speed.LEVEL_0, "");
                        FanDevice.this.labelButton1.setIcon(FanDevice.this.iconButton1_normal);
                        FanDevice.this.labelButton2.setIcon(FanDevice.this.iconButton2_normal);
                    }
                    if (FanDevice.this.powerService.getData().getValue()) {
                        FanDevice.this.powerService.setFalse();
                    }
                }
                catch (DeviceException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                FanDevice.this.labelButton0.setIcon(FanDevice.this.iconButton0_clicking);
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                FanDevice.this.labelButton0.setIcon(FanDevice.this.iconButton0_normal);
            }
        });
        this.labelButton1.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (!FanDevice.this.validKey(arg0)) {
                    return;
                }
                try {
                    if (!FanDevice.this.powerService.getData().getValue()) {
                        FanDevice.this.powerService.setTrue();
                    }
                    if (FanDevice.this.speedService.getData().getLevel().compareTo(Speed.LEVEL_1) != 0) {
                        FanDevice.this.speedService.setData(Speed.LEVEL_1, "");
                        FanDevice.this.labelButton1.setIcon(FanDevice.this.iconButton1_clicked);
                        FanDevice.this.labelButton2.setIcon(FanDevice.this.iconButton2_normal);
                        FanDevice.this.interval = LEVEL_1_INTERVAL;
                    }
                }
                catch (DeviceException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                FanDevice.this.labelButton1.setIcon(FanDevice.this.iconButton1_clicking);
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                FanDevice.this.labelButton1.setIcon(FanDevice.this.iconButton1_normal);
            }
        });
        this.labelButton2.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (!FanDevice.this.validKey(arg0)) {
                    return;
                }
                try {
                    if (!FanDevice.this.powerService.getData().getValue()) {
                        FanDevice.this.powerService.setTrue();
                    }
                    if (FanDevice.this.speedService.getData().getLevel().compareTo(Speed.LEVEL_2) != 0) {
                        FanDevice.this.speedService.setData(Speed.LEVEL_2, "");
                        FanDevice.this.labelButton2.setIcon(FanDevice.this.iconButton2_clicked);
                        FanDevice.this.labelButton1.setIcon(FanDevice.this.iconButton1_normal);
                        FanDevice.this.interval = LEVEL_2_INTERVAL;
                    }
                }
                catch (DeviceException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                FanDevice.this.labelButton2.setIcon(FanDevice.this.iconButton2_clicking);
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                FanDevice.this.labelButton2.setIcon(FanDevice.this.iconButton2_normal);
            }
        });
        this.controlPane.add(this.labelMinus);
        this.controlPane.add(this.labelTimer);
        this.controlPane.add(this.labelPlus);
        this.controlPane.add(this.labelButton0);
        this.controlPane.add(this.labelButton1);
        this.controlPane.add(this.labelButton2);
        new Thread(){

            @Override
            public void run() {
                try {
                    int pos = 0;
                    while (true) {
                        if (!FanDevice.this.powerService.getData().getValue() || FanDevice.this.speedService.getData().getLevel().compareTo(Speed.LEVEL_0) == 0) {
                            continue;
                        }
                        if (pos >= FanDevice.this.iconFans.length) {
                            pos = 0;
                        }
                        FanDevice.this.labelFan.setIcon(FanDevice.this.iconFans[pos++]);
                        Thread.sleep(FanDevice.this.interval);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        }.start();
        Hashtable<String, String> dict = new Hashtable<String, String>();
        ((Dictionary)dict).put("event.topics", "org/osgi/service/dal/FunctionEvent/PROPERTY_CHANGED");
        ((Dictionary)dict).put("event.filter", "(dal.function.UID=" + this.countdownService.getServiceProperty("dal.function.UID") + ")");
        ServiceRegistration register = Activator.getContext().registerService(EventHandler.class.getName(), (Object)new EventHandler(){

            public void handleEvent(Event arg0) {
                try {
                    FanDevice.this.labelTimer.setIcon(FanDevice.this.iconTimers[FanDevice.this.countdownService.getData().getLevel().intValue()]);
                    if (FanDevice.this.countdownService.getData().getLevel().compareTo(Countdown.MIN_VALUE) == 0 && FanDevice.this.powerService.getData().getValue()) {
                        FanDevice.this.powerService.setFalse();
                    } else if (FanDevice.this.countdownService.getData().getLevel().compareTo(Countdown.MIN_VALUE) > 0 && !FanDevice.this.powerService.getData().getValue() && FanDevice.this.speedService.getData().getLevel().compareTo(Speed.LEVEL_0) != 0) {
                        FanDevice.this.powerService.setTrue();
                    }
                }
                catch (DeviceException e) {
                    e.printStackTrace();
                }
            }
        }, dict);
        if (register == null) {
            LOGGER.error((Object)String.format("Event handler (%s) register failed!", this.countdownService.getServiceProperty("dal.function.UID")));
        }
    }

    private boolean validKey(MouseEvent event) {
        if (event.getClickCount() > 1) {
            this.faultDetectionService.setAlarm(new AlarmData(System.currentTimeMillis(), null, 1, 7));
            return false;
        }
        return true;
    }

    private void setupDeviceProperties() {
        this.props = new Hashtable<String, Object>();
        this.props.put("dal.device.UID", this.uid);
        this.props.put("dal.device.driver", "fan");
        this.props.put("dal.device.name", this.uid);
        this.props.put("dal.device.status", STATUS_PROCESSING);
    }

    public Object getServiceProperty(String propKey) {
        if (this.devRef != null) {
            return this.devRef.getProperty(propKey);
        }
        return this.props.get(propKey);
    }

    public String[] getServicePropertyKeys() {
        if (this.devRef != null) {
            return this.devRef.getPropertyKeys();
        }
        String[] keys = new String[this.props.size()];
        int count = 0;
        Enumeration<String> key = this.props.keys();
        while (key.hasMoreElements()) {
            keys[count++] = key.nextElement();
        }
        return keys;
    }

    public void setStatus(Integer status) {
        this.props.put("dal.device.status", status);
        this.devReg.setProperties(this.props);
    }

    public void remove() throws DeviceException {
        LOGGER.info((Object)("Remove FanDevice (" + this.uid + ") ..."));
        this.setStatus(STATUS_DETAIL_REMOVING);
        LOGGER.info((Object)("Remove functions of FanDevice (" + this.uid + ") ..."));
        this.powerService.remove();
        this.speedService.remove();
        this.countdownService.remove();
        this.faultDetectionService.remove();
        LOGGER.info((Object)("Functions of FanDevice (" + this.uid + ") is removed!"));
        this.devReg.unregister();
        this.setVisible(false);
        this.dispose();
        LOGGER.info((Object)("FanDevice (" + this.uid + ") is removed!"));
    }

    /* synthetic */ FanDevice(FanDevice fanDevice) {
        this();
    }
}

