/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.dal;

import java.awt.EventQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.interworking.service.InterworkingService;
import org.eclipse.om2m.ipe.dal.InterworkingServiceImpl;
import org.eclipse.om2m.persistence.service.DBService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static Log LOGGER = LogFactory.getLog(Activator.class);
    private static BundleContext context;
    private ServiceTracker<Object, Object> cseServiceTracker;
    private ServiceTracker<Object, Object> dbServiceTracker;
    private static CseService cse;
    private static DBService dbs;
    private ServiceRegistration<?> ipeReg;
    private InterworkingServiceImpl ipe;

    public void start(BundleContext context) throws Exception {
        LOGGER.info((Object)"Start DAL interworking bundle...");
        Activator.context = context;
        this.cseServiceTracker = new ServiceTracker<Object, Object>(context, CseService.class.getName(), null){

            public void removedService(ServiceReference<Object> reference, Object service) {
                LOGGER.info((Object)"CseService removed");
                cse = null;
            }

            public Object addingService(ServiceReference<Object> reference) {
                LOGGER.info((Object)"CseService discovered");
                cse = (CseService)this.context.getService(reference);
                if (Activator.this.ipe == null) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Activator.this.ipe = new InterworkingServiceImpl();
                            Activator.this.ipe.activate();
                            LOGGER.info((Object)"Register DAL InterworkingService ...");
                            Activator.this.ipeReg = context.registerService(InterworkingService.class.getName(), (Object)Activator.this.ipe, null);
                            LOGGER.info((Object)"DAL InterworkingService is registered.");
                        }
                    });
                }
                return cse;
            }
        };
        this.cseServiceTracker.open();
        this.dbServiceTracker = new ServiceTracker<Object, Object>(context, DBService.class.getName(), null){

            public void removedService(ServiceReference<Object> reference, Object service) {
                LOGGER.info((Object)"DBService removed");
                dbs = null;
            }

            public Object addingService(ServiceReference<Object> reference) {
                LOGGER.info((Object)"DBService discovered");
                dbs = (DBService)this.context.getService(reference);
                return dbs;
            }
        };
        this.dbServiceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        LOGGER.info((Object)"Stop DAL interworking bundle...");
        if (this.ipe != null) {
            this.ipe.deactivate();
        }
        if (this.ipeReg != null) {
            this.ipeReg.unregister();
        }
    }

    public static BundleContext getContext() {
        return context;
    }

    public static CseService getCseService() {
        return cse;
    }

    public static DBService getDBService() {
        return dbs;
    }
}

