/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.entitymapper;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.GroupEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.resource.AnnounceableResource;
import org.eclipse.om2m.commons.resource.ChildResourceRef;
import org.eclipse.om2m.commons.resource.Group;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.core.entitymapper.EntityMapper;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.entitymapper.SubscriptionMapper;

public class GroupMapper
extends EntityMapper<GroupEntity, Group> {
    @Override
    protected Group createResource() {
        return new Group();
    }

    @Override
    protected void mapAttributes(GroupEntity entity, Group resource, int level, int offset) {
        if (level < 0) {
            return;
        }
        EntityMapperFactory.getAnnounceableSubordonateEntity_AnnounceableResourceMapper().mapAttributes((AnnounceableSubordinateEntity)entity, (AnnounceableResource)resource, level, offset);
        resource.setConsistencyStrategy(entity.getConsistencyStrategy());
        resource.setCreator(entity.getCreator());
        resource.setCurrentNrOfMembers(BigInteger.valueOf(entity.getMemberIDs().size()));
        resource.setFanOutPoint(String.valueOf(entity.getHierarchicalURI()) + "/" + "fopt");
        resource.setGroupName(resource.getGroupName());
        resource.setMaxNrOfMembers(entity.getMaxNrOfMembers());
        resource.setMemberType(entity.getMemberType());
        resource.setMemberTypeValidated(entity.isMemberTypeValidated());
        if (!entity.getMemberIDs().isEmpty()) {
            resource.getMemberIDs().addAll(entity.getMemberIDs());
        }
        if (!entity.getMemberAcpIds().isEmpty()) {
            resource.getMembersAccessControlPolicyIDs().addAll(entity.getMemberAcpIds());
        }
    }

    @Override
    protected List<ChildResourceRef> getChildResourceRef(GroupEntity entity, int level, int offset) {
        ArrayList<ChildResourceRef> childRefs = new ArrayList<ChildResourceRef>();
        if (level == 0) {
            return childRefs;
        }
        for (SubscriptionEntity sub : entity.getSubscriptions()) {
            ChildResourceRef ref = new ChildResourceRef();
            ref.setResourceName(sub.getName());
            ref.setType(sub.getResourceType());
            ref.setValue(sub.getResourceID());
            childRefs.add(ref);
            childRefs.addAll(new SubscriptionMapper().getChildResourceRef(sub, level - 1, offset - 1));
        }
        return childRefs;
    }

    @Override
    protected void mapChildResourceRef(GroupEntity entity, Group resource, int level, int offset) {
        resource.getChildResource().addAll(this.getChildResourceRef(entity, level, offset));
    }

    @Override
    protected void mapChildResources(GroupEntity entity, Group resource, int level, int offset) {
        if (level == 0) {
            return;
        }
        for (SubscriptionEntity sub : entity.getSubscriptions()) {
            Subscription subRes = (Subscription)new SubscriptionMapper().mapEntityToResource(sub, ResultContent.ATTRIBUTES, level - 1, offset - 1);
            resource.getSubscription().add(subRes);
        }
    }
}

