/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core;

import java.math.BigInteger;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.CSEType;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.AccessControlOriginatorEntity;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AccessControlRuleEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.resource.RemoteCSE;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.utils.Util;
import org.eclipse.om2m.core.comm.RestClient;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.datamapper.DataMapperSelector;
import org.eclipse.om2m.core.persistence.PersistenceService;
import org.eclipse.om2m.core.remotecse.RemoteCseService;
import org.eclipse.om2m.core.urimapper.UriMapper;
import org.eclipse.om2m.persistence.service.DBService;
import org.eclipse.om2m.persistence.service.DBTransaction;

public class CSEInitializer
implements Constants {
    private static final Log LOGGER = LogFactory.getLog(CSEInitializer.class);
    private static RemoteCSE currentRegistrationToIn;
    private static ScheduledExecutorService scheduler;
    private static final Object MUTEX;
    private static String acpAdminId;

    static {
        scheduler = Executors.newScheduledThreadPool(1);
        MUTEX = new Object();
    }

    private CSEInitializer() {
    }

    public static void init() throws InterruptedException {
        LOGGER.info((Object)"Initializating the cseBase");
        DBService dbs = PersistenceService.getInstance().getDbService();
        DBTransaction transaction = dbs.getDbTransaction();
        transaction.open();
        CSEBaseEntity cseBase = (CSEBaseEntity)dbs.getDAOFactory().getCSEBaseDAO().find(transaction, (Object)("/" + Constants.CSE_ID));
        if (cseBase == null) {
            LOGGER.info((Object)"Create AccessControlPolicy resource");
            CSEInitializer.initACP();
            LOGGER.info((Object)"Create CSEBase resource");
            CSEInitializer.initCSEBase();
            if (!Constants.CSE_TYPE.equalsIgnoreCase("in-cse") && Constants.CSE_AUTHENTICATION) {
                LOGGER.info((Object)"Register CSE to another CSE.");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        CSEInitializer.registerCSE();
                        CSEInitializer.checkPeriodicallyCSERegistration();
                    }
                }).start();
            }
        } else {
            LOGGER.info((Object)"cseBase already initialized");
        }
    }

    private static void initCSEBase() {
        int[] supportedResources;
        CSEBaseEntity cseBaseEntity = new CSEBaseEntity();
        DBService db = PersistenceService.getInstance().getDbService();
        DBTransaction transaction = db.getDbTransaction();
        transaction.open();
        AccessControlPolicyEntity acpEntity = (AccessControlPolicyEntity)db.getDAOFactory().getAccessControlPolicyDAO().find(transaction, (Object)acpAdminId);
        cseBaseEntity.getAccessControlPolicies().add(acpEntity);
        cseBaseEntity.getChildAccessControlPolicies().add(acpEntity);
        cseBaseEntity.setCreationTime(Util.DateUtil.now());
        cseBaseEntity.setCseid(Constants.CSE_ID);
        cseBaseEntity.setCseType(CSEType.toBigInteger((String)Constants.CSE_TYPE));
        cseBaseEntity.setLastModifiedTime(Util.DateUtil.now());
        cseBaseEntity.setName(Constants.CSE_NAME);
        cseBaseEntity.setResourceID("/" + Constants.CSE_ID);
        cseBaseEntity.setResourceType(BigInteger.valueOf(5L));
        cseBaseEntity.setHierarchicalURI("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME);
        int[] nArray = supportedResources = new int[]{1, 2, 3, 4, 5, 9, 14, 15, 16, 17, 23, 28};
        int n = supportedResources.length;
        int n2 = 0;
        while (n2 < n) {
            int rt = nArray[n2];
            cseBaseEntity.getSupportedResourceType().add(BigInteger.valueOf(rt));
            ++n2;
        }
        cseBaseEntity.getPointOfAccess().add("http://" + Constants.CSE_IP + ":" + Constants.CSE_PORT + Constants.CSE_CONTEXT);
        UriMapper.addNewUri(cseBaseEntity.getHierarchicalURI(), cseBaseEntity.getResourceID(), 5);
        if (db.getDAOFactory().getCSEBaseDAO().find(transaction, (Object)cseBaseEntity.getResourceID()) == null) {
            db.getDAOFactory().getCSEBaseDAO().create(transaction, (Object)cseBaseEntity);
        } else {
            db.getDAOFactory().getCSEBaseDAO().update(transaction, (Object)cseBaseEntity);
        }
        CSEBaseEntity dbCseBaseEntity = (CSEBaseEntity)db.getDAOFactory().getCSEBaseDAO().find(transaction, (Object)cseBaseEntity.getResourceID());
        acpEntity.setParentCse(dbCseBaseEntity);
        transaction.commit();
        transaction.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerCSE() {
        String contentFormat = System.getProperty("org.eclipse.om2m.registration.contentFormat", "application/xml");
        RemoteCSE remoteCSE = new RemoteCSE();
        switch (Constants.CSE_TYPE.toLowerCase()) {
            case "asn-cse": {
                remoteCSE.setCseType(CSEType.ASN_CSE);
                break;
            }
            case "mn-cse": {
                remoteCSE.setCseType(CSEType.MN_CSE);
                break;
            }
        }
        String httpPoa = "http://" + Constants.CSE_IP + ":" + Constants.CSE_PORT + Constants.CSE_CONTEXT;
        if (Constants.CSE_CONTEXT.length() > 1) {
            httpPoa = String.valueOf(httpPoa) + "/";
        }
        remoteCSE.getPointOfAccess().add(httpPoa);
        remoteCSE.setCSEID("/" + Constants.CSE_ID);
        remoteCSE.setCSEBase("//" + Constants.M2M_SP_ID + remoteCSE.getCSEID());
        remoteCSE.setRequestReachability(new Boolean(true));
        remoteCSE.setName(Constants.CSE_NAME);
        String representation = DataMapperSelector.getDataMapperList().get(contentFormat).objToString((Object)remoteCSE);
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        String remotePoa = "http://" + Constants.REMOTE_CSE_IP + ":" + Constants.REMOTE_CSE_PORT + "/~" + Constants.REMOTE_CSE_CONTEXT;
        if (Constants.REMOTE_CSE_CONTEXT.length() > 1 && !Constants.REMOTE_CSE_CONTEXT.equals("/~")) {
            remotePoa = String.valueOf(remotePoa) + "/";
        }
        remotePoa = String.valueOf(remotePoa) + Constants.REMOTE_CSE_ID;
        request.setTo(remotePoa);
        request.setContent((Object)representation);
        request.setOperation(Operation.CREATE);
        request.setResourceType(BigInteger.valueOf(16L));
        request.setRequestContentType(contentFormat);
        request.setRequestIdentifier("001");
        boolean registered = false;
        while (!registered) {
            ResponsePrimitive response = RestClient.sendRequest(request);
            LOGGER.info((Object)("response after registration: " + response));
            if (response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
                registered = true;
                Object object = MUTEX;
                synchronized (object) {
                    currentRegistrationToIn = (RemoteCSE)DataMapperSelector.getDataMapperList().get(contentFormat).stringToObj((String)response.getContent());
                    break;
                }
            }
            if (ResponseStatusCode.CONFLICT.equals(response.getResponseStatusCode())) {
                CSEInitializer.deleteRegistration();
                registered = false;
                continue;
            }
            try {
                LOGGER.info((Object)"Error in registration to another CSE. Retrying in 10s");
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                LOGGER.debug((Object)"Interrupted Exception", (Throwable)e);
            }
        }
        LOGGER.info((Object)("Successfully registered to " + Constants.REMOTE_CSE_ID));
        RemoteCSEEntity remoteCseEntity = new RemoteCSEEntity();
        remoteCseEntity.setCreationTime(Util.DateUtil.now());
        remoteCseEntity.setLastModifiedTime(Util.DateUtil.now());
        remoteCseEntity.setParentID("/" + Constants.CSE_ID);
        DBService dbs = PersistenceService.getInstance().getDbService();
        DBTransaction transaction = dbs.getDbTransaction();
        transaction.open();
        remoteCseEntity.getAccessControlPolicies().add((AccessControlPolicyEntity)dbs.getDAOFactory().getAccessControlPolicyDAO().find(transaction, (Object)acpAdminId));
        remoteCseEntity.setResourceType(BigInteger.valueOf(16L));
        remoteCseEntity.setHierarchicalURI("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME + "/" + Constants.REMOTE_CSE_NAME);
        String generatedId = Controller.generateId("", "");
        remoteCseEntity.setResourceID("/" + Constants.CSE_ID + "/" + "csr" + Constants.PREFIX_SEPERATOR + generatedId);
        remoteCseEntity.setName(Constants.REMOTE_CSE_NAME);
        UriMapper.addNewUri(remoteCseEntity.getHierarchicalURI(), remoteCseEntity.getResourceID(), 16);
        remoteCseEntity.setRemoteCseId("/" + Constants.REMOTE_CSE_ID);
        remoteCseEntity.setRemoteCseUri("//" + Constants.M2M_SP_ID + remoteCseEntity.getRemoteCseId());
        String poa = "http://" + Constants.REMOTE_CSE_IP + ":" + Constants.REMOTE_CSE_PORT + Constants.REMOTE_CSE_CONTEXT;
        if (Constants.REMOTE_CSE_CONTEXT.length() > 1) {
            poa = String.valueOf(poa) + "/";
        }
        remoteCseEntity.getPointOfAccess().add(poa);
        remoteCseEntity.setRequestReachability(true);
        CSEBaseEntity cseBase = (CSEBaseEntity)dbs.getDAOFactory().getCSEBaseDAO().find(transaction, (Object)("/" + Constants.CSE_ID));
        cseBase.getRemoteCses().add(remoteCseEntity);
        dbs.getDAOFactory().getCSEBaseDAO().update(transaction, (Object)cseBase);
        dbs.getDAOFactory().getRemoteCSEDAO().create(transaction, (Object)remoteCseEntity);
        transaction.commit();
        transaction.close();
        RemoteCseService.getInstance().addRemoteCseAndPublish(remoteCseEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteRegistration() {
        CSEInitializer.unregisterCse();
        Object object = MUTEX;
        synchronized (object) {
            currentRegistrationToIn = null;
        }
        DBService dbs = PersistenceService.getInstance().getDbService();
        DBTransaction transaction = dbs.getDbTransaction();
        transaction.open();
        RemoteCSEEntity remoteCse = (RemoteCSEEntity)dbs.getDAOFactory().getRemoteCSEbyCseIdDAO().find(transaction, (Object)("/" + Constants.REMOTE_CSE_ID));
        if (remoteCse != null) {
            dbs.getDAOFactory().getRemoteCSEDAO().delete(transaction, (Object)remoteCse);
            UriMapper.deleteUri("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME + "/" + Constants.REMOTE_CSE_NAME);
            LOGGER.info((Object)"remove remoteCSE from database");
            RemoteCseService.getInstance().removeRemoteCseAndPublish(remoteCse.getName());
        } else {
            LOGGER.warn((Object)"No remoteCSE to remove from database");
        }
        transaction.commit();
        transaction.close();
    }

    private static void initACP() {
        AccessControlPolicyEntity acp = new AccessControlPolicyEntity();
        acp.setParentID("/" + Constants.CSE_ID);
        acp.setCreationTime(Util.DateUtil.now());
        acp.setLastModifiedTime(Util.DateUtil.now());
        acp.setResourceID("/" + Constants.CSE_ID + "/" + "acp" + Constants.PREFIX_SEPERATOR + Controller.generateId());
        acp.setName("acp_admin");
        acp.setResourceType(BigInteger.valueOf(1L));
        acp.setHierarchicalURI("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME + "/" + acp.getName());
        acp.setResourceType(1);
        UriMapper.addNewUri(acp.getHierarchicalURI(), acp.getResourceID(), 1);
        AccessControlRuleEntity ruleEntity = new AccessControlRuleEntity();
        AccessControlOriginatorEntity originatorEntity = new AccessControlOriginatorEntity(Constants.ADMIN_REQUESTING_ENTITY);
        ruleEntity.getAccessControlOriginators().add(originatorEntity);
        ruleEntity.setCreate(true);
        ruleEntity.setRetrieve(true);
        ruleEntity.setUpdate(true);
        ruleEntity.setDelete(true);
        ruleEntity.setNotify(true);
        ruleEntity.setDiscovery(true);
        acp.getSelfPrivileges().add(ruleEntity);
        ruleEntity = new AccessControlRuleEntity();
        ruleEntity.setCreate(true);
        ruleEntity.setRetrieve(true);
        ruleEntity.setUpdate(true);
        ruleEntity.setDelete(true);
        ruleEntity.setNotify(true);
        ruleEntity.setDiscovery(true);
        ruleEntity.getAccessControlOriginators().add(new AccessControlOriginatorEntity(Constants.ADMIN_REQUESTING_ENTITY));
        ruleEntity.getAccessControlOriginators().add(new AccessControlOriginatorEntity("/" + Constants.CSE_ID));
        acp.getPrivileges().add(ruleEntity);
        ruleEntity = new AccessControlRuleEntity();
        ruleEntity.setRetrieve(true);
        ruleEntity.setDiscovery(true);
        ruleEntity.getAccessControlOriginators().add(new AccessControlOriginatorEntity(Constants.GUEST_REQUESTING_ENTITY));
        ruleEntity.getAccessControlOriginators().add(new AccessControlOriginatorEntity("*"));
        acp.getPrivileges().add(ruleEntity);
        acpAdminId = acp.getResourceID();
        DBService db = PersistenceService.getInstance().getDbService();
        DBTransaction transaction = db.getDbTransaction();
        transaction.open();
        if (db.getDAOFactory().getAccessControlPolicyDAO().find(transaction, (Object)acp.getResourceID()) == null) {
            db.getDAOFactory().getAccessControlPolicyDAO().create(transaction, (Object)acp);
        } else {
            db.getDAOFactory().getAccessControlPolicyDAO().update(transaction, (Object)acp);
        }
        transaction.commit();
        transaction.close();
    }

    public static void unregisterCse() {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setOperation(Operation.DELETE);
        String remotePoa = "http://" + Constants.REMOTE_CSE_IP + ":" + Constants.REMOTE_CSE_PORT + "/~";
        if (Constants.REMOTE_CSE_CONTEXT.length() > 1) {
            remotePoa = String.valueOf(remotePoa) + "/" + Constants.REMOTE_CSE_CONTEXT;
        }
        remotePoa = String.valueOf(remotePoa) + "/" + REMOTE_CSE_ID + "/" + REMOTE_CSE_NAME + "/" + CSE_NAME;
        request.setTo(remotePoa);
        request.setResultContent(ResultContent.NOTHING);
        LOGGER.info((Object)"Sending unregistration request");
        ResponsePrimitive response = RestClient.sendRequest(request);
        LOGGER.info((Object)("Unregistration response:\n" + response));
    }

    private static void checkPeriodicallyCSERegistration() {
        scheduler.scheduleWithFixedDelay(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LOGGER.info((Object)"check CSE registration");
                RemoteCSE registration = null;
                Object object = MUTEX;
                synchronized (object) {
                    registration = currentRegistrationToIn;
                }
                if (registration != null) {
                    RemoteCSE remoteCSEFromIN = CSEInitializer.retrieveCSERegistration();
                    if (!CSEInitializer.compareRemoteCSE(registration, remoteCSEFromIN)) {
                        CSEInitializer.deleteRegistration();
                        CSEInitializer.registerCSE();
                    } else {
                        LOGGER.info((Object)"registration is good");
                    }
                } else {
                    LOGGER.info((Object)"registration is null --> registration process on going");
                }
            }
        }, 3L, 3L, TimeUnit.MINUTES);
    }

    protected static boolean compareRemoteCSE(RemoteCSE registration, RemoteCSE remoteCSEFromIN) {
        if (remoteCSEFromIN == null) {
            LOGGER.info((Object)"compareRemoteCSE() - remoteCSEFromIN is null");
            return false;
        }
        if (!remoteCSEFromIN.getResourceID().equals(registration.getResourceID())) {
            LOGGER.info((Object)("compareRemoteCSE() - remoteCSEFromIN.resourceID(" + remoteCSEFromIN.getResourceID() + ")!=registration.resourceID(" + registration.getResourceID() + ")"));
            return false;
        }
        return true;
    }

    protected static RemoteCSE retrieveCSERegistration() {
        String contentFormat = System.getProperty("org.eclipse.om2m.registration.contentFormat", "application/xml");
        try {
            RequestPrimitive request = new RequestPrimitive();
            request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
            request.setOperation(Operation.RETRIEVE);
            String remotePoa = "http://" + Constants.REMOTE_CSE_IP + ":" + Constants.REMOTE_CSE_PORT + "/~";
            if (Constants.REMOTE_CSE_CONTEXT.length() > 1) {
                remotePoa = String.valueOf(remotePoa) + "/" + Constants.REMOTE_CSE_CONTEXT;
            }
            remotePoa = String.valueOf(remotePoa) + "/" + Constants.REMOTE_CSE_ID + "/" + Constants.REMOTE_CSE_NAME + "/" + Constants.CSE_NAME;
            request.setTo(remotePoa);
            request.setResultContent(ResultContent.ATTRIBUTES);
            request.setReturnContentType(contentFormat);
            ResponsePrimitive response = RestClient.sendRequest(request);
            if (ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
                return (RemoteCSE)DataMapperSelector.getDataMapperList().get(contentFormat).stringToObj((String)response.getContent());
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

