/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sample;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.interworking.service.InterworkingService;
import org.eclipse.om2m.ipe.sample.constants.Operations;
import org.eclipse.om2m.ipe.sample.controller.SampleController;

public class SampleRouter
implements InterworkingService {
    private static Log LOGGER = LogFactory.getLog(SampleRouter.class);

    public ResponsePrimitive doExecute(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        if (request.getQueryStrings().containsKey("op")) {
            String operation = (String)((List)request.getQueryStrings().get("op")).get(0);
            Operations op = Operations.getOperationFromString(operation);
            String lampid = null;
            if (request.getQueryStrings().containsKey("lampid")) {
                lampid = (String)((List)request.getQueryStrings().get("lampid")).get(0);
            }
            LOGGER.info((Object)("Received request in Sample IPE: op=" + operation + " ; lampid=" + lampid));
            switch (op) {
                case SET_ON: {
                    SampleController.setLampState(lampid, true);
                    response.setResponseStatusCode(ResponseStatusCode.OK);
                    break;
                }
                case SET_OFF: {
                    SampleController.setLampState(lampid, false);
                    response.setResponseStatusCode(ResponseStatusCode.OK);
                    break;
                }
                case TOGGLE: {
                    SampleController.toggleLamp(lampid);
                    response.setResponseStatusCode(ResponseStatusCode.OK);
                    break;
                }
                case ALL_ON: {
                    SampleController.setAllOn();
                    response.setResponseStatusCode(ResponseStatusCode.OK);
                    break;
                }
                case ALL_OFF: {
                    SampleController.setAllOff();
                    response.setResponseStatusCode(ResponseStatusCode.OK);
                    break;
                }
                case ALL_TOGGLE: {
                    SampleController.toogleAll();
                    response.setResponseStatusCode(ResponseStatusCode.OK);
                    break;
                }
                case GET_STATE: {
                    throw new BadRequestException();
                }
                case GET_STATE_DIRECT: {
                    String content = SampleController.getFormatedLampState(lampid);
                    response.setContent((Object)content);
                    request.setReturnContentType("application/obix");
                    response.setResponseStatusCode(ResponseStatusCode.OK);
                    break;
                }
                default: {
                    throw new BadRequestException();
                }
            }
        }
        if (response.getResponseStatusCode() == null) {
            response.setResponseStatusCode(ResponseStatusCode.BAD_REQUEST);
        }
        return response;
    }

    public String getAPOCPath() {
        return "sample";
    }
}

