/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.persistence.eclipselink.internal.dao;

import java.util.List;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AccessControlRuleEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.FlexContainerEntity;
import org.eclipse.om2m.commons.entities.LabelEntity;
import org.eclipse.om2m.persistence.eclipselink.internal.DBTransactionJPAImpl;
import org.eclipse.om2m.persistence.eclipselink.internal.dao.AbstractDAO;
import org.eclipse.om2m.persistence.service.DBTransaction;

public class AccessControlPolicyDAO
extends AbstractDAO<AccessControlPolicyEntity> {
    @Override
    public void create(DBTransaction dbTransaction, AccessControlPolicyEntity resource) {
        DBTransactionJPAImpl transaction = (DBTransactionJPAImpl)dbTransaction;
        List<LabelEntity> lbls = this.processLabels(dbTransaction, resource.getLabelsEntities());
        resource.setLabelsEntities(lbls);
        for (AccessControlRuleEntity acre : resource.getSelfPrivileges()) {
            acre.setSelfAccessControlPolicy(resource);
            transaction.getEm().persist((Object)acre);
        }
        for (AccessControlRuleEntity acre : resource.getPrivileges()) {
            acre.setAccessControlPolicy(resource);
            transaction.getEm().persist((Object)acre);
        }
        transaction.getEm().persist((Object)resource);
    }

    @Override
    public AccessControlPolicyEntity find(DBTransaction dbTransaction, Object id) {
        DBTransactionJPAImpl transaction = (DBTransactionJPAImpl)dbTransaction;
        return (AccessControlPolicyEntity)transaction.getEm().find(AccessControlPolicyEntity.class, id);
    }

    @Override
    public void update(DBTransaction dbTransaction, AccessControlPolicyEntity resource) {
        DBTransactionJPAImpl transaction = (DBTransactionJPAImpl)dbTransaction;
        List<LabelEntity> lbls = this.processLabels(dbTransaction, resource.getLabelsEntities());
        resource.setLabelsEntities(lbls);
        transaction.getEm().merge((Object)resource);
    }

    @Override
    public void delete(DBTransaction dbTransaction, AccessControlPolicyEntity resource) {
        DBTransactionJPAImpl transaction = (DBTransactionJPAImpl)dbTransaction;
        for (AeEntity ae : resource.getLinkedAes()) {
            ae.getAccessControlPolicies().remove(resource);
        }
        for (FlexContainerEntity entity : resource.getLinkedFlexContainers()) {
            entity.getAccessControlPolicies().remove(resource);
        }
        for (FlexContainerEntity entity : resource.getLinkedFlexContainerAs()) {
            entity.getAccessControlPolicies().remove(resource);
        }
        if (resource.getParentAE() != null) {
            resource.getParentAE().getChildAccessControlPolicies().remove(resource);
        }
        if (resource.getParentCse() != null) {
            resource.getParentCse().getChildAccessControlPolicies().remove(resource);
        }
        if (resource.getParentCsr() != null) {
            resource.getParentCsr().getChildAcps().remove(resource);
        }
        transaction.getEm().remove((Object)resource);
    }
}

