/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.persistence.mongodb.resource;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeAnncEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.FlexContainerAnncEntity;
import org.eclipse.om2m.commons.entities.FlexContainerEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.persistence.mongodb.resource.MongoChildLoader;

public class ResourceSerializerDeserializer<T extends ResourceEntity>
implements JsonSerializer<T>,
JsonDeserializer<T> {
    private static final Log LOGGER = LogFactory.getLog(ResourceSerializerDeserializer.class);

    public JsonElement serialize(T arg0, Type arg1, JsonSerializationContext arg2) {
        JsonObject cseBaseEntityObject = new JsonObject();
        Method[] methodArray = arg0.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            LOGGER.debug((Object)("serialize (method=" + method.getName() + ")"));
            if ((method.getName().startsWith("get") || method.getName().startsWith("is")) && !method.getName().equals("getClass")) {
                Object result;
                LOGGER.debug((Object)("serialize (method=" + method.getName() + ") - is a getter"));
                String propertyName = null;
                propertyName = method.getName().startsWith("get") ? method.getName().substring(3) : method.getName().substring(2);
                boolean isPrimitive = ResourceSerializerDeserializer.isSuperPrimitive(method.getReturnType());
                LOGGER.debug((Object)("serialize (method=" + method.getName() + ") - returnType=" + method.getReturnType()));
                LOGGER.debug((Object)("serialize (method=" + method.getName() + ") - isPrimitive=" + isPrimitive));
                if (isPrimitive) {
                    try {
                        result = method.invoke(arg0, new Object[0]);
                        LOGGER.debug((Object)("serialize (method=" + method.getName() + ") - invoke result=" + result));
                        cseBaseEntityObject.add(propertyName, arg2.serialize(result));
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                } else if (List.class.equals(method.getReturnType())) {
                    LOGGER.debug((Object)"!!!!!!! list");
                    try {
                        ParameterizedType pt;
                        result = (List)method.invoke(arg0, new Object[0]);
                        JsonArray jsonArray = new JsonArray();
                        LOGGER.debug((Object)("!!!! List serialize (method=" + method.getName() + ") - invoke result=" + result));
                        Type type = method.getGenericReturnType();
                        if (ParameterizedType.class.isAssignableFrom(type.getClass()) && (pt = (ParameterizedType)type).getActualTypeArguments().length != 0) {
                            if (ResourceEntity.class.isAssignableFrom((Class)pt.getActualTypeArguments()[0])) {
                                LOGGER.debug((Object)("____________________________________________________ComponentType =" + pt.getActualTypeArguments()[0]));
                                if (result != null) {
                                    Iterator iterator = result.iterator();
                                    while (iterator.hasNext()) {
                                        Object o = iterator.next();
                                        if (o == null) continue;
                                        ResourceEntity resourceEntity = (ResourceEntity)o;
                                        String resourceId = resourceEntity.getResourceID();
                                        JsonObject jsonObject = new JsonObject();
                                        jsonObject.add("ResourceID", (JsonElement)new JsonPrimitive(resourceId));
                                        jsonObject.add("ResourceType", (JsonElement)new JsonPrimitive((Number)resourceEntity.getResourceType()));
                                        jsonArray.add((JsonElement)jsonObject);
                                    }
                                }
                                propertyName = "#" + propertyName;
                            } else {
                                jsonArray = (JsonArray)arg2.serialize(result);
                            }
                            cseBaseEntityObject.add(propertyName, (JsonElement)jsonArray);
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                } else if (ResourceEntity.class.isAssignableFrom(method.getReturnType())) {
                    LOGGER.debug((Object)"!!!! assignable to ResourceEntity");
                }
            }
            ++n2;
        }
        return cseBaseEntityObject;
    }

    private static boolean isSuperPrimitive(Class clazz) {
        return clazz.isPrimitive() || clazz.getName().startsWith("java.lang.") || clazz.getName().startsWith("java.math.");
    }

    public T deserialize(JsonElement arg0, Type arg1, JsonDeserializationContext arg2) throws JsonParseException {
        Object t = null;
        JsonObject jsonObject = (JsonObject)arg0;
        BigInteger resourceType = jsonObject.get("ResourceType").getAsBigInteger();
        t = this.create(resourceType);
        if (t == null) {
            return t;
        }
        t.setResourceType(resourceType);
        for (Map.Entry entry : jsonObject.entrySet()) {
            Method setterMethod;
            String propertyName = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (propertyName.equals("ResourceType")) continue;
            if (value.isJsonPrimitive()) {
                JsonPrimitive jsonPrimitive = (JsonPrimitive)value;
                Object valueObject = null;
                Method setterMethod2 = ResourceSerializerDeserializer.getSetter(propertyName, (Class)arg1);
                if (setterMethod2 == null) continue;
                if (jsonPrimitive.isBoolean()) {
                    valueObject = jsonPrimitive.getAsBoolean();
                } else if (jsonPrimitive.isString()) {
                    valueObject = jsonPrimitive.getAsString();
                } else if (jsonPrimitive.isNumber()) {
                    valueObject = arg2.deserialize((JsonElement)jsonPrimitive, setterMethod2.getGenericParameterTypes()[0]);
                }
                try {
                    setterMethod2.invoke(t, valueObject);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    LOGGER.debug((Object)("Exception setter=" + setterMethod2.getName() + " - " + setterMethod2.getParameterTypes()[0] + "- valueObject.getClass:" + valueObject.getClass()));
                    e.printStackTrace();
                }
                continue;
            }
            if (!value.isJsonArray()) continue;
            JsonArray jsonArray = (JsonArray)value;
            List<Object> list = new ArrayList();
            String initialPropertyName = propertyName;
            if (initialPropertyName.startsWith("#")) {
                initialPropertyName = initialPropertyName.substring(1);
            }
            if ((setterMethod = ResourceSerializerDeserializer.getSetter(initialPropertyName, (Class)arg1)) == null) continue;
            if (propertyName.startsWith("#")) {
                MongoChildLoader<Object> m = new MongoChildLoader<Object>();
                list = m.loadChilds(t, jsonArray);
            } else {
                LOGGER.debug((Object)("jsonArray=" + jsonArray.toString()));
                Object subObject = arg2.deserialize((JsonElement)jsonArray, setterMethod.getGenericParameterTypes()[0]);
                LOGGER.debug((Object)("##############################subObject=" + subObject));
                list = (List)subObject;
            }
            try {
                setterMethod.invoke(t, list);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return t;
    }

    private static Method getSetter(String propertyName, Class clazz) {
        String setterName = "set" + propertyName;
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (setterName.equals(method.getName())) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private final T create(BigInteger type) {
        AeEntity t = null;
        switch (type.intValue()) {
            case 2: {
                t = new AeEntity();
                break;
            }
            case 5: {
                t = new CSEBaseEntity();
                break;
            }
            case 1: {
                t = new AccessControlPolicyEntity();
                break;
            }
            case 28: {
                t = new FlexContainerEntity();
                break;
            }
            case 3: {
                t = new ContainerEntity();
                break;
            }
            case 16: {
                t = new RemoteCSEEntity();
                break;
            }
            case 10002: {
                t = new AeAnncEntity();
                break;
            }
            case 10028: {
                t = new FlexContainerAnncEntity();
                break;
            }
            case 34: {
                t = new DynamicAuthorizationConsultationEntity();
            }
        }
        return (T)t;
    }
}

