/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.testsuite.flexcontainer;

import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.AlarmSpeakerFlexContainer;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.testsuite.flexcontainer.FlexContainerTestSuite;
import org.eclipse.om2m.testsuite.flexcontainer.TestReport;

public class AlarmSpeakerFlexContainerTest
extends FlexContainerTestSuite {
    public AlarmSpeakerFlexContainerTest(CseService pCseService) {
        super(pCseService);
    }

    @Override
    protected String getTestSuiteName() {
        return "AlarmSpeakerFlexContainerTest";
    }

    public void testCreateAndRetrieveAlarmSpeakerFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "AlarmSpeakerFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        AlarmSpeakerFlexContainer flexContainer = new AlarmSpeakerFlexContainer();
        flexContainer.setName(flexContainerName);
        flexContainer.setOntologyRef("OrangeOntology");
        flexContainer.setCreator("Greg");
        CustomAttribute toneCustomAttribute = new CustomAttribute();
        toneCustomAttribute.setCustomAttributeName("tone");
        toneCustomAttribute.setCustomAttributeValue("1");
        flexContainer.getCustomAttributes().add(toneCustomAttribute);
        CustomAttribute alarmStatusCustomAttribute = new CustomAttribute();
        alarmStatusCustomAttribute.setCustomAttributeName("alaSs");
        alarmStatusCustomAttribute.setCustomAttributeValue("true");
        flexContainer.getCustomAttributes().add(alarmStatusCustomAttribute);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        AlarmSpeakerFlexContainer createdFlexContainer = null;
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testCreateAndRetrieveAlarmSpeakerFlexContainer", TestReport.Status.KO, "unable to create AlarmSpeaker FlexContainer:" + response.getContent(), null);
            return;
        }
        createdFlexContainer = (AlarmSpeakerFlexContainer)response.getContent();
        if (!flexContainerName.equals(createdFlexContainer.getName())) {
            this.createTestReport("testCreateAndRetrieveAlarmSpeakerFlexContainer", TestReport.Status.KO, "invalid name. Expecting:" + flexContainerName + ", found:" + createdFlexContainer.getName(), null);
            return;
        }
        try {
            this.checkFlexContainerCreator((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
            this.checkFlexContainerOntologyRef((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
            this.checkFlexContainerCustomAttribute((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
            this.checkFlexContainerDefinition((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
            this.checkFlexContainerOntologyRef((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveAlarmSpeakerFlexContainer", TestReport.Status.KO, e.getMessage(), e);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            this.createTestReport("testCreateAndRetrieveAlarmSpeakerFlexContainer", TestReport.Status.KO, "unable to retrieve AlarmSpeaker FlexContainer:" + response.getContent(), null);
            return;
        }
        AlarmSpeakerFlexContainer retrievedFlexContainer = (AlarmSpeakerFlexContainer)response.getContent();
        try {
            this.checkFlexContainer((AbstractFlexContainer)createdFlexContainer, (AbstractFlexContainer)retrievedFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveAlarmSpeakerFlexContainer", TestReport.Status.KO, e.getMessage(), e);
            return;
        }
        this.createTestReport("testCreateAndRetrieveAlarmSpeakerFlexContainer", TestReport.Status.OK, null, null);
    }

    public void testDeleteAlarmSpeakerFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "AlarmSpeakerFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        AlarmSpeakerFlexContainer flexContainer = new AlarmSpeakerFlexContainer();
        flexContainer.setName(flexContainerName);
        flexContainer.setOntologyRef("OrangeOntology");
        flexContainer.setCreator("Greg");
        CustomAttribute toneCustomAttribute = new CustomAttribute();
        toneCustomAttribute.setCustomAttributeName("tone");
        toneCustomAttribute.setCustomAttributeValue("1");
        flexContainer.getCustomAttributes().add(toneCustomAttribute);
        CustomAttribute alarmStatusCustomAttribute = new CustomAttribute();
        alarmStatusCustomAttribute.setCustomAttributeName("alaSs");
        alarmStatusCustomAttribute.setCustomAttributeValue("true");
        flexContainer.getCustomAttributes().add(alarmStatusCustomAttribute);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        Object createdFlexContainer = null;
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testDeleteAlarmSpeakerFlexContainer", TestReport.Status.KO, "unable to create AlarmSpeaker FlexContainer:" + response.getContent(), null);
            return;
        }
        response = this.sendDeleteRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.DELETED)) {
            this.createTestReport("testDeleteAlarmSpeakerFlexContainer", TestReport.Status.KO, "unable to delete AlarmSpeaker FlexContainer:" + response.getContent(), null);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.NOT_FOUND)) {
            this.createTestReport("testDeleteAlarmSpeakerFlexContainer", TestReport.Status.KO, "Expecting:" + ResponseStatusCode.NOT_FOUND + ", received:" + response.getResponseStatusCode(), null);
            return;
        }
        this.createTestReport("testDeleteAlarmSpeakerFlexContainer", TestReport.Status.OK, null, null);
    }

    public void testUpdateAlarmSpeakerFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "AlarmSpeakerFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        AlarmSpeakerFlexContainer flexContainer = new AlarmSpeakerFlexContainer();
        flexContainer.setName(flexContainerName);
        flexContainer.setOntologyRef("OrangeOntology");
        flexContainer.setCreator("Greg");
        CustomAttribute toneCustomAttribute = new CustomAttribute();
        toneCustomAttribute.setCustomAttributeName("tone");
        toneCustomAttribute.setCustomAttributeValue("1");
        flexContainer.getCustomAttributes().add(toneCustomAttribute);
        CustomAttribute alarmStatusCustomAttribute = new CustomAttribute();
        alarmStatusCustomAttribute.setCustomAttributeName("alaSs");
        alarmStatusCustomAttribute.setCustomAttributeValue("true");
        flexContainer.getCustomAttributes().add(alarmStatusCustomAttribute);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        AlarmSpeakerFlexContainer createdFlexContainer = null;
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testUpdateAlarmSpeakerFlexContainer", TestReport.Status.KO, "unable to create AlarmSpeaker FlexContainer:" + response.getContent(), null);
            return;
        }
        createdFlexContainer = (AlarmSpeakerFlexContainer)response.getContent();
        AlarmSpeakerFlexContainer toBeUpdated = new AlarmSpeakerFlexContainer();
        CustomAttribute updatedTone = new CustomAttribute();
        updatedTone.setCustomAttributeName("tone");
        updatedTone.setCustomAttributeValue("1");
        toBeUpdated.getCustomAttributes().add(updatedTone);
        response = this.sendUpdateFlexContainerRequest(flexContainerLocation, (AbstractFlexContainer)toBeUpdated);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.UPDATED)) {
            this.createTestReport("testUpdateAlarmSpeakerFlexContainer", TestReport.Status.KO, "unable to update AlarmSpeaker FlexContainer:" + response.getContent(), null);
            return;
        }
        AlarmSpeakerFlexContainer updatedFlexContainer = (AlarmSpeakerFlexContainer)response.getContent();
        if (updatedFlexContainer.getCustomAttributes().size() != 1) {
            this.createTestReport("testUpdateAlarmSpeakerFlexContainer", TestReport.Status.KO, "Expecting 1 customAttribute, found " + updatedFlexContainer.getCustomAttributes().size() + " customAttributes", null);
            return;
        }
        if (!updatedTone.getCustomAttributeValue().equals(updatedFlexContainer.getCustomAttribute("tone").getCustomAttributeValue())) {
            this.createTestReport("testUpdateAlarmSpeakerFlexContainer", TestReport.Status.KO, "Wrong tone attribute value. Expecting:" + updatedTone.getCustomAttributeValue() + ", received:" + updatedFlexContainer.getCustomAttribute("tone").getCustomAttributeValue(), null);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            this.createTestReport("testUpdateAlarmSpeakerFlexContainer", TestReport.Status.KO, "unable to retrieve AlarmSpeaker FlexContainer:" + response.getContent(), null);
            return;
        }
        AlarmSpeakerFlexContainer retrievedFlexContainer = (AlarmSpeakerFlexContainer)response.getContent();
        createdFlexContainer.getCustomAttribute("tone").setCustomAttributeValue(updatedTone.getCustomAttributeValue());
        try {
            this.checkFlexContainer((AbstractFlexContainer)createdFlexContainer, (AbstractFlexContainer)retrievedFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testUpdateAlarmSpeakerFlexContainer", TestReport.Status.KO, e.getMessage(), e);
            return;
        }
        this.createTestReport("testUpdateAlarmSpeakerFlexContainer", TestReport.Status.OK, null, null);
    }
}

