/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.testsuite.flexcontainer;

import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.RunModeFlexContainer;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.testsuite.flexcontainer.FlexContainerTestSuite;
import org.eclipse.om2m.testsuite.flexcontainer.TestReport;

public class RunModeFlexContainerTest
extends FlexContainerTestSuite {
    public RunModeFlexContainerTest(CseService pCseService) {
        super(pCseService);
    }

    @Override
    protected String getTestSuiteName() {
        return "RunModeFlexContainerTest";
    }

    public void testCreateAndRetrieveRunModeFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "RunModeFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        RunModeFlexContainer flexContainer = new RunModeFlexContainer();
        flexContainer.setName(flexContainerName);
        flexContainer.setCreator("Greg");
        flexContainer.setOntologyRef("OrangeOntology");
        CustomAttribute operationModeCustomAttribute = new CustomAttribute();
        operationModeCustomAttribute.setCustomAttributeName("opeMe");
        operationModeCustomAttribute.setCustomAttributeValue("ON");
        flexContainer.getCustomAttributes().add(operationModeCustomAttribute);
        CustomAttribute supportedModesCustomAttribute = new CustomAttribute();
        supportedModesCustomAttribute.setCustomAttributeName("supMs");
        supportedModesCustomAttribute.setCustomAttributeValue("ON,OFF,UNKNOWN");
        flexContainer.getCustomAttributes().add(supportedModesCustomAttribute);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        RunModeFlexContainer createdFlexContainer = null;
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testCreateAndRetrieveRunModeFlexContainer", TestReport.Status.KO, "unable to create RunModeFlexContainer :" + response.getContent(), null);
            return;
        }
        createdFlexContainer = (RunModeFlexContainer)response.getContent();
        if (!flexContainerName.equals(createdFlexContainer.getName())) {
            this.createTestReport("testCreateAndRetrieveRunModeFlexContainer", TestReport.Status.KO, "name are differents (expected:" + flexContainerName + ", found:" + createdFlexContainer.getName() + ")", null);
            return;
        }
        try {
            this.checkFlexContainerCreator((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveRunModeFlexContainer", TestReport.Status.KO, "creator are differents (expected:" + flexContainer.getCreator() + ", found:" + createdFlexContainer.getCreator() + ")", e);
            return;
        }
        try {
            this.checkFlexContainerCustomAttribute((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveRunModeFlexContainer", TestReport.Status.KO, "customAttributes are differents (expected:" + flexContainer.getCustomAttributes() + ", found:" + createdFlexContainer.getCustomAttributes() + ")", e);
            return;
        }
        try {
            this.checkFlexContainerDefinition((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveRunModeFlexContainer", TestReport.Status.KO, "containerDefinition are differents (expected:" + flexContainer.getContainerDefinition() + ", found:" + createdFlexContainer.getContainerDefinition() + ")", e);
            return;
        }
        try {
            this.checkFlexContainerOntologyRef((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveRunModeFlexContainer", TestReport.Status.KO, "ontologyRef are differents (expected:" + flexContainer.getOntologyRef() + ", found:" + createdFlexContainer.getOntologyRef() + ")", e);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            this.createTestReport("testCreateAndRetrieveRunModeFlexContainer", TestReport.Status.KO, "unable to retrieve RunModeFlexContainer (expected:" + ResponseStatusCode.OK + ", found:" + response.getResponseStatusCode() + ")", null);
        } else {
            RunModeFlexContainer retrievedFlexContainer = (RunModeFlexContainer)response.getContent();
            try {
                this.checkFlexContainer((AbstractFlexContainer)createdFlexContainer, (AbstractFlexContainer)retrievedFlexContainer);
            }
            catch (Exception e) {
                this.createTestReport("testCreateAndRetrieveRunModeFlexContainer", TestReport.Status.KO, "flexContainers are differents:" + e.getMessage(), e);
            }
        }
        this.createTestReport("testCreateAndRetrieveRunModeFlexContainer", TestReport.Status.OK, null, null);
    }

    public void testUpdateRunModeFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "RunModeFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        RunModeFlexContainer flexContainer = new RunModeFlexContainer();
        flexContainer.setName(flexContainerName);
        flexContainer.setCreator("Greg");
        flexContainer.setOntologyRef("OrangeOntology");
        CustomAttribute operationModeCustomAttribute = new CustomAttribute();
        operationModeCustomAttribute.setCustomAttributeName("opeMe");
        operationModeCustomAttribute.setCustomAttributeValue("ON");
        flexContainer.getCustomAttributes().add(operationModeCustomAttribute);
        CustomAttribute supportedModesCustomAttribute = new CustomAttribute();
        supportedModesCustomAttribute.setCustomAttributeName("supMs");
        supportedModesCustomAttribute.setCustomAttributeValue("ON,OFF,UNKNOWN");
        flexContainer.getCustomAttributes().add(supportedModesCustomAttribute);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        Object createdFlexContainer = null;
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testUpdateRunModeFlexContainer", TestReport.Status.KO, "unable to create RunModeFlexContainer :" + response.getContent(), null);
            return;
        }
        RunModeFlexContainer toBeUpdated = new RunModeFlexContainer();
        CustomAttribute operationModeToBeUpdated = new CustomAttribute();
        operationModeToBeUpdated.setCustomAttributeValue("OFF");
        operationModeToBeUpdated.setCustomAttributeName("opeMe");
        toBeUpdated.getCustomAttributes().add(operationModeToBeUpdated);
        response = this.sendUpdateFlexContainerRequest(flexContainerLocation, (AbstractFlexContainer)toBeUpdated);
        RunModeFlexContainer updatedFlexContainer = null;
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.UPDATED)) {
            this.createTestReport("testUpdateRunModeFlexContainer", TestReport.Status.KO, "unable to update RunModeFlexContainer (expected " + ResponseStatusCode.UPDATED + ", received: " + response.getResponseStatusCode() + ")", null);
            return;
        }
        updatedFlexContainer = (RunModeFlexContainer)response.getContent();
        if (updatedFlexContainer.getCustomAttributes().size() != 1) {
            this.createTestReport("testUpdateRunModeFlexContainer", TestReport.Status.KO, "expecting 1 custom attribute, found " + updatedFlexContainer.getCustomAttributes().size(), null);
            return;
        }
        if (!updatedFlexContainer.getCustomAttribute("opeMe").getCustomAttributeValue().equals("OFF")) {
            this.createTestReport("testUpdateRunModeFlexContainer", TestReport.Status.KO, "invalid operationMode customAttribute value (expected: OFF, received: " + updatedFlexContainer.getCustomAttribute("opeMe").getCustomAttributeValue() + ")", null);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            this.createTestReport("testUpdateRunModeFlexContainer", TestReport.Status.KO, "unable to retrieve RunModeFlexContainer (expected " + ResponseStatusCode.OK + ", received: " + response.getResponseStatusCode() + ")", null);
            return;
        }
        RunModeFlexContainer retrievedFlexContainer = (RunModeFlexContainer)response.getContent();
        if (retrievedFlexContainer.getCustomAttributes().size() != 2) {
            this.createTestReport("testUpdateRunModeFlexContainer", TestReport.Status.KO, "expecting 2 custom attribute, found " + updatedFlexContainer.getCustomAttributes().size(), null);
            return;
        }
        if (!retrievedFlexContainer.getCustomAttribute("opeMe").getCustomAttributeValue().equals("OFF")) {
            this.createTestReport("testUpdateRunModeFlexContainer", TestReport.Status.KO, "invalid operationMode customAttribute value (expected: OFF, received: " + retrievedFlexContainer.getCustomAttribute("opeMe").getCustomAttributeValue() + ")", null);
            return;
        }
        if (!retrievedFlexContainer.getCustomAttribute("supMs").getCustomAttributeValue().equals("ON,OFF,UNKNOWN")) {
            this.createTestReport("testUpdateRunModeFlexContainer", TestReport.Status.KO, "invalid supportedModes customAttribute value (expected: ON,OFF,UNKNOWN, received: " + retrievedFlexContainer.getCustomAttribute("supMs").getCustomAttributeValue() + ")", null);
            return;
        }
        this.createTestReport("testUpdateRunModeFlexContainer", TestReport.Status.OK, null, null);
    }

    public void testDeleteRunModeFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "RunModeFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        RunModeFlexContainer flexContainer = new RunModeFlexContainer();
        flexContainer.setName(flexContainerName);
        flexContainer.setCreator("Greg");
        flexContainer.setOntologyRef("OrangeOntology");
        CustomAttribute operationModeCustomAttribute = new CustomAttribute();
        operationModeCustomAttribute.setCustomAttributeName("opeMe");
        operationModeCustomAttribute.setCustomAttributeValue("ON");
        flexContainer.getCustomAttributes().add(operationModeCustomAttribute);
        CustomAttribute supportedModesCustomAttribute = new CustomAttribute();
        supportedModesCustomAttribute.setCustomAttributeName("supMs");
        supportedModesCustomAttribute.setCustomAttributeValue("ON,OFF,UNKNOWN");
        flexContainer.getCustomAttributes().add(supportedModesCustomAttribute);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        Object createdFlexContainer = null;
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testDeleteRunModeFlexContainer", TestReport.Status.KO, "unable to create RunModeFlexContainer :" + response.getContent(), null);
            return;
        }
        response = this.sendDeleteRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.DELETED)) {
            this.createTestReport("testDeleteRunModeFlexContainer", TestReport.Status.KO, "unable to delete RunModeFlexContainer :" + response.getContent(), null);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.NOT_FOUND)) {
            this.createTestReport("testDeleteRunModeFlexContainer", TestReport.Status.KO, "expected errorCode:" + ResponseStatusCode.NOT_FOUND + ", found:" + response.getResponseStatusCode(), null);
            return;
        }
        this.createTestReport("testDeleteRunModeFlexContainer", TestReport.Status.OK, null, null);
    }
}

