/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.om2m.sdt.Action;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Device;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.events.SDTEventListener;
import org.eclipse.om2m.sdt.rights.RightsManager;
import org.eclipse.om2m.sdt.utils.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static final String STAR = "*";
    private static final int iDOM = 0;
    private static final int iDEV = 1;
    private static final int iDEV_ID = 2;
    private static final int iMOD = 3;
    private static final int iMOD_ID = 4;
    private static final int iDP = 5;
    private static Map<SDTEventListener, List<String[]>> listeners;
    private static Map<String, Domain> domains;
    private static RightsManager rightsManager;
    private BundleContext context;

    static {
        domains = new HashMap<String, Domain>();
        listeners = new HashMap<SDTEventListener, List<String[]>>();
    }

    public Activator() {
        Logger.info("ctor");
    }

    public void start(BundleContext bc) throws Exception {
        Logger.info("Activation");
        this.context = bc;
        ServiceTracker rmTracker = new ServiceTracker(this.context, RightsManager.class.getName(), null){

            public Object addingService(ServiceReference ref) {
                Activator.rightsManager = (RightsManager)this.context.getService(ref);
                Logger.info("Got Rights Manager " + rightsManager);
                return rightsManager;
            }

            public void removedService(ServiceReference ref, Object service) {
                Activator.rightsManager = null;
            }
        };
        rmTracker.open();
        ServiceTracker log = new ServiceTracker(this.context, LogService.class.getName(), null){

            public Object addingService(ServiceReference ref) {
                LogService logService = (LogService)this.context.getService(ref);
                Logger.setLogService(logService);
                Logger.info("LogService OK");
                return logService;
            }

            public void removedService(ServiceReference ref, Object service) {
                Logger.unsetLogService();
            }
        };
        log.open();
        ServiceTracker listenersTracker = new ServiceTracker(this.context, SDTEventListener.class.getName(), null){

            public Object addingService(ServiceReference ref) {
                SDTEventListener l = (SDTEventListener)this.context.getService(ref);
                String[] props = new String[]{Activator.getProp(ref.getProperty("sdt.domains.ids")), Activator.getProp(ref.getProperty("sdt.devices.definitions")), Activator.getProp(ref.getProperty("sdt.devices.ids")), Activator.getProp(ref.getProperty("sdt.modules.definitions")), Activator.getProp(ref.getProperty("sdt.modules.names")), Activator.getProp(ref.getProperty("sdt.datapoints.names"))};
                Logger.info("Adding listener " + l.getClass() + " for " + props[0] + "/" + props[1] + "/" + props[2] + "/" + props[3] + "/" + props[4] + "/" + props[5]);
                ArrayList<String[]> lp = (ArrayList<String[]>)listeners.get(l);
                if (lp == null) {
                    lp = new ArrayList<String[]>();
                    listeners.put(l, lp);
                }
                lp.add(props);
                return l;
            }

            public void removedService(ServiceReference ref, Object service) {
                SDTEventListener l = (SDTEventListener)this.context.getService(ref);
                Logger.info("Remove listener " + l);
                listeners.remove(l);
            }
        };
        listenersTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        Logger.info("Deactivation");
        listeners.clear();
    }

    public static Collection<SDTEventListener> getListeners(Module module, DataPoint datapoint) {
        Logger.info("get listeners for " + module + " / " + datapoint + " in " + listeners);
        HashSet<SDTEventListener> ret = new HashSet<SDTEventListener>();
        block0: for (Map.Entry<SDTEventListener, List<String[]>> entry : listeners.entrySet()) {
            for (String[] props : entry.getValue()) {
                ArrayList<Domain> doms = new ArrayList<Domain>();
                ArrayList<Device> devices = new ArrayList<Device>();
                ArrayList<Module> modules = new ArrayList<Module>();
                Logger.info("listener props " + props[0] + "/" + props[1] + "/" + props[2] + "/" + props[3] + "/" + props[4] + "/" + props[5]);
                Device owner = module.getOwner();
                if (props[0].equals(STAR)) {
                    doms.addAll(domains.values());
                } else {
                    String[] stringArray = props[0].split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String d = stringArray[n2];
                        doms.add(domains.get(d.trim()));
                        ++n2;
                    }
                }
                for (Domain dom : doms) {
                    if (props[1].equals(STAR) && props[2].equals(STAR)) {
                        devices.addAll(dom.getDevices());
                        continue;
                    }
                    if (props[2].equals(STAR)) {
                        Activator.findDevices(props[1], dom, owner.getDefinition(), true, devices);
                        continue;
                    }
                    if (props[1].equals(STAR)) {
                        Activator.findDevices(props[2], dom, owner.getId(), false, devices);
                        continue;
                    }
                    Activator.findDevices(props[1], props[2], dom, owner, devices);
                }
                Logger.debug("Associated devices " + devices);
                for (Device dev : devices) {
                    if (props[3].equals(STAR) && props[4].equals(STAR)) {
                        modules.addAll(dev.getModules());
                        continue;
                    }
                    if (props[4].equals(STAR)) {
                        Activator.findModules(props[3], dev, module.getDefinition(), true, modules);
                        continue;
                    }
                    if (props[3].equals(STAR)) {
                        Activator.findModules(props[4], dev, module.getName(), false, modules);
                        continue;
                    }
                    Activator.findModules(props[3], props[4], dev, module, modules);
                }
                Logger.info("Associated modules " + modules);
                if ((!props[5].equals(STAR) || modules.isEmpty()) && !Activator.findDatapoints(props[5], modules, datapoint.getName())) continue;
                ret.add(entry.getKey());
                continue block0;
            }
        }
        return ret;
    }

    private static void findDevices(String props, Domain dom, String key, boolean def, Collection<Device> devices) {
        String[] stringArray = props.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String d = stringArray[n2];
            String dt = d.trim();
            if (dt.equalsIgnoreCase(key)) {
                for (Device dev : dom.getDevices()) {
                    if (!dt.equalsIgnoreCase(def ? dev.getDefinition() : dev.getId())) continue;
                    devices.add(dev);
                }
            }
            ++n2;
        }
    }

    private static void findDevices(String defs, String names, Domain dom, Device owner, Collection<Device> devices) {
        String[] stringArray = defs.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String d1 = stringArray[n2];
            String dt1 = d1.trim();
            for (Device dev : dom.getDevices()) {
                if (!dt1.equalsIgnoreCase(owner.getDefinition()) || !dt1.equalsIgnoreCase(dev.getDefinition())) continue;
                String[] stringArray2 = names.split(",");
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String d2 = stringArray2[n4];
                    String dt2 = d2.trim();
                    if (dt2.equalsIgnoreCase(owner.getId()) && dt2.equalsIgnoreCase(dev.getId())) {
                        devices.add(dev);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private static void findModules(String props, Device dev, String key, boolean def, Collection<Module> modules) {
        String[] stringArray = props.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String d = stringArray[n2];
            String dt = d.trim();
            if (dt.equalsIgnoreCase(key)) {
                for (Module mod : dev.getModules()) {
                    if (!dt.equalsIgnoreCase(def ? mod.getDefinition() : mod.getName())) continue;
                    modules.add(mod);
                }
            }
            ++n2;
        }
    }

    private static void findModules(String defs, String names, Device dev, Module module, Collection<Module> modules) {
        String[] stringArray = defs.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String d1 = stringArray[n2];
            String dt1 = d1.trim();
            for (Module mod : dev.getModules()) {
                if (!dt1.equalsIgnoreCase(module.getDefinition()) || !dt1.equalsIgnoreCase(mod.getDefinition())) continue;
                String[] stringArray2 = names.split(",");
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String d2 = stringArray2[n4];
                    String dt2 = d2.trim();
                    if (dt2.equalsIgnoreCase(module.getName()) && dt2.equalsIgnoreCase(mod.getName())) {
                        modules.add(mod);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private static boolean findDatapoints(String names, Collection<Module> modules, String dpName) {
        String[] stringArray = names.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String d = stringArray[n2];
            String dt = d.trim();
            for (Module mod : modules) {
                if (!dt.equalsIgnoreCase(dpName)) continue;
                for (DataPoint dp : mod.getDataPoints()) {
                    if (!dt.equalsIgnoreCase(dp.getName())) continue;
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public static final boolean isGrantedReadAccess(DataPoint dp) {
        return rightsManager == null ? true : rightsManager.isGrantedReadAccess(dp);
    }

    public static final boolean isGrantedWriteAccess(DataPoint dp) {
        return rightsManager == null ? true : rightsManager.isGrantedWriteAccess(dp);
    }

    public static final boolean isGrantedEventAccess(SDTEventListener l, DataPoint dp) {
        return rightsManager == null ? true : rightsManager.isGrantedEventAccess(l, dp);
    }

    public static final boolean isGrantedAccess(Action action) {
        return rightsManager == null ? true : rightsManager.isGrantedAccess(action);
    }

    public static final void addDomain(Domain domain) {
        domains.put(domain.getName(), domain);
    }

    private static final String getProp(Object o) {
        if (o == null) {
            return STAR;
        }
        String s = o.toString().trim();
        return s.isEmpty() || s.equals(STAR) ? STAR : s;
    }
}

