/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.util.List;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.NodeEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.exceptions.ConflictException;
import org.eclipse.om2m.commons.exceptions.ResourceNotFoundException;
import org.eclipse.om2m.commons.resource.AnnounceableResource;
import org.eclipse.om2m.commons.resource.Node;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.utils.Util;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.datamapper.DataMapperSelector;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.notifier.Notifier;
import org.eclipse.om2m.core.router.Patterns;
import org.eclipse.om2m.core.urimapper.UriMapper;
import org.eclipse.om2m.core.util.ControllerUtil;
import org.eclipse.om2m.persistence.service.DAO;

public class NodeController
extends Controller {
    @Override
    public ResponsePrimitive doCreate(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        DAO<?> dao = Patterns.getDAO(request.getTargetId(), this.dbs);
        if (dao == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        LOGGER.trace((Object)("Target ID in controller: " + request.getTargetId()));
        ResourceEntity parentEntity = (ResourceEntity)dao.find(this.transaction, (Object)request.getTargetId());
        if (parentEntity == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        List childNodes = null;
        List acpsToCheck = null;
        List subscriptions = null;
        if (parentEntity.getResourceType().intValue() == 5) {
            CSEBaseEntity csb = (CSEBaseEntity)parentEntity;
            childNodes = csb.getChildNodes();
            acpsToCheck = csb.getAccessControlPolicies();
            subscriptions = csb.getSubscriptions();
        }
        if (parentEntity.getResourceType().intValue() == 16) {
            RemoteCSEEntity remoteCse = (RemoteCSEEntity)parentEntity;
            childNodes = remoteCse.getChildNodes();
            acpsToCheck = remoteCse.getAccessControlPolicies();
            subscriptions = remoteCse.getSubscriptions();
        }
        this.checkACP(acpsToCheck, request.getFrom(), Operation.CREATE);
        response = new ResponsePrimitive(request);
        if (request.getContent() == null) {
            throw new BadRequestException("A content is required for Container creation");
        }
        Node node = null;
        try {
            node = request.getRequestContentType().equals("application/obj") ? (Node)request.getContent() : (Node)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
        }
        catch (ClassCastException e) {
            throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
        }
        if (node == null) {
            throw new BadRequestException("Error in provided content");
        }
        NodeEntity nodeEntity = new NodeEntity();
        ControllerUtil.CreateUtil.fillEntityFromAnnounceableResource((AnnounceableResource)node, (AnnounceableSubordinateEntity)nodeEntity);
        if (node.getNodeID() == null) {
            throw new BadRequestException("Node ID is Mandatory");
        }
        nodeEntity.setNodeID(node.getNodeID());
        if (node.getHostedCSELink() != null) {
            nodeEntity.setHostedCSELink(node.getHostedCSELink());
        }
        String generatedId = NodeController.generateId();
        nodeEntity.setResourceID("/" + Constants.CSE_ID + "/" + "nod" + Constants.PREFIX_SEPERATOR + generatedId);
        nodeEntity.setCreationTime(Util.DateUtil.now());
        nodeEntity.setLastModifiedTime(Util.DateUtil.now());
        nodeEntity.setParentID(parentEntity.getResourceID());
        nodeEntity.setResourceType(14);
        if (node.getName() != null) {
            if (!Patterns.checkResourceName(node.getName())) {
                throw new BadRequestException("Name provided is incorrect. Must be:([A-Za-z0-9_\\-~#]|\\.)+");
            }
            nodeEntity.setName(node.getName());
        } else {
            nodeEntity.setName("nod_" + generatedId);
        }
        nodeEntity.setHierarchicalURI(String.valueOf(parentEntity.getHierarchicalURI()) + "/" + nodeEntity.getName());
        if (!node.getAccessControlPolicyIDs().isEmpty()) {
            nodeEntity.setAccessControlPolicies(ControllerUtil.buildAcpEntityList(node.getAccessControlPolicyIDs(), this.transaction));
        } else {
            nodeEntity.getAccessControlPolicies().addAll(acpsToCheck);
        }
        if (!UriMapper.addNewUri(nodeEntity.getHierarchicalURI(), nodeEntity.getResourceID(), 14)) {
            throw new ConflictException("Name already present in the parent collection.");
        }
        this.dbs.getDAOFactory().getNodeEntityDAO().create(this.transaction, (Object)nodeEntity);
        NodeEntity nodeDB = (NodeEntity)this.dbs.getDAOFactory().getNodeEntityDAO().find(this.transaction, (Object)nodeEntity.getResourceID());
        childNodes.add(nodeDB);
        dao.update(this.transaction, (Object)parentEntity);
        this.transaction.commit();
        Notifier.notify(subscriptions, (ResourceEntity)nodeDB, 1);
        response.setResponseStatusCode(ResponseStatusCode.CREATED);
        this.setLocationAndCreationContent(request, response, (ResourceEntity)nodeDB);
        return response;
    }

    @Override
    public ResponsePrimitive doRetrieve(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        NodeEntity nodeEntity = (NodeEntity)this.dbs.getDAOFactory().getNodeEntityDAO().find(this.transaction, (Object)request.getTargetId());
        if (nodeEntity == null) {
            throw new ResourceNotFoundException();
        }
        List acps = nodeEntity.getAccessControlPolicies();
        this.checkACP(acps, request.getFrom(), request.getOperation());
        response = new ResponsePrimitive(request);
        Node node = EntityMapperFactory.getNodeMapper().mapEntityToResource(nodeEntity, request);
        response.setContent((Object)node);
        response.setResponseStatusCode(ResponseStatusCode.OK);
        return response;
    }

    @Override
    public ResponsePrimitive doUpdate(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        NodeEntity nodeEntity = (NodeEntity)this.dbs.getDAOFactory().getNodeEntityDAO().find(this.transaction, (Object)request.getTargetId());
        if (nodeEntity == null) {
            throw new ResourceNotFoundException();
        }
        this.checkACP(nodeEntity.getAccessControlPolicies(), request.getFrom(), Operation.UPDATE);
        if (request.getContent() == null) {
            throw new BadRequestException("A content is required for node update");
        }
        Node node = null;
        try {
            node = request.getRequestContentType().equals("application/obj") ? (Node)request.getContent() : (Node)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
        }
        catch (ClassCastException e) {
            throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
        }
        if (node == null) {
            throw new BadRequestException("Error in provided content");
        }
        ControllerUtil.UpdateUtil.checkNotPermittedParameters((Resource)node);
        if (node.getHostedCSELink() != null) {
            throw new BadRequestException("HostedCSELink is NP");
        }
        Node modifiedAttributes = new Node();
        if (!node.getLabels().isEmpty()) {
            nodeEntity.setLabelsEntitiesFromSring(node.getLabels());
            modifiedAttributes.getLabels().addAll(node.getLabels());
        }
        if (!node.getAccessControlPolicyIDs().isEmpty()) {
            for (AccessControlPolicyEntity acpe : nodeEntity.getAccessControlPolicies()) {
                this.checkSelfACP(acpe, request.getFrom(), Operation.UPDATE);
            }
            nodeEntity.getAccessControlPolicies().clear();
            nodeEntity.setAccessControlPolicies(ControllerUtil.buildAcpEntityList(node.getAccessControlPolicyIDs(), this.transaction));
            modifiedAttributes.getAccessControlPolicyIDs().addAll(node.getAccessControlPolicyIDs());
        }
        if (node.getExpirationTime() != null) {
            nodeEntity.setExpirationTime(node.getExpirationTime());
            modifiedAttributes.setExpirationTime(node.getExpirationTime());
        }
        if (!node.getAnnounceTo().isEmpty()) {
            nodeEntity.getAnnounceTo().clear();
            nodeEntity.getAnnounceTo().addAll(node.getAnnounceTo());
            modifiedAttributes.getAnnounceTo().addAll(node.getAnnounceTo());
        }
        if (!node.getAnnouncedAttribute().isEmpty()) {
            nodeEntity.getAnnouncedAttribute().clear();
            nodeEntity.getAnnouncedAttribute().addAll(node.getAnnouncedAttribute());
            modifiedAttributes.getAnnouncedAttribute().addAll(node.getAnnouncedAttribute());
        }
        if (node.getNodeID() != null) {
            nodeEntity.setNodeID(node.getNodeID());
            modifiedAttributes.setNodeID(node.getNodeID());
        }
        nodeEntity.setLastModifiedTime(Util.DateUtil.now());
        modifiedAttributes.setLastModifiedTime(nodeEntity.getLastModifiedTime());
        response.setContent((Object)modifiedAttributes);
        this.dbs.getDAOFactory().getNodeEntityDAO().update(this.transaction, (Object)nodeEntity);
        this.transaction.commit();
        Notifier.notify(nodeEntity.getChildSubscriptions(), (ResourceEntity)nodeEntity, 3);
        response.setResponseStatusCode(ResponseStatusCode.UPDATED);
        return response;
    }

    @Override
    public ResponsePrimitive doDelete(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        NodeEntity nodeEntity = (NodeEntity)this.dbs.getDAOFactory().getNodeEntityDAO().find(this.transaction, (Object)request.getTargetId());
        if (nodeEntity == null) {
            throw new ResourceNotFoundException();
        }
        this.checkACP(nodeEntity.getAccessControlPolicies(), request.getFrom(), Operation.DELETE);
        UriMapper.deleteUri(nodeEntity.getHierarchicalURI());
        Notifier.notifyDeletion(nodeEntity.getChildSubscriptions(), (ResourceEntity)nodeEntity);
        this.dbs.getDAOFactory().getNodeEntityDAO().delete(this.transaction, (Object)nodeEntity);
        this.transaction.commit();
        response.setResponseStatusCode(ResponseStatusCode.DELETED);
        return response;
    }
}

