/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.devices;

import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.modules.AbstractAlarmSensor;
import org.eclipse.om2m.sdt.home.modules.ContactSensor;
import org.eclipse.om2m.sdt.home.modules.FaultDetection;
import org.eclipse.om2m.sdt.home.modules.MotionSensor;
import org.eclipse.om2m.sdt.home.modules.SmokeSensor;
import org.eclipse.om2m.sdt.home.modules.WaterSensor;
import org.eclipse.om2m.sdt.home.types.DeviceType;

public class GenericSensor
extends GenericDevice {
    protected AbstractAlarmSensor sensor;
    protected FaultDetection faultDetection;

    public GenericSensor(String id, String serial, Domain domain) {
        super(id, serial, domain);
    }

    public GenericSensor(String id, String serial, DeviceType type, Domain domain) {
        super(id, serial, type, domain);
    }

    public void addModule(Module module) {
        if (module instanceof FaultDetection) {
            this.addModule((FaultDetection)module);
        } else if (module instanceof AbstractAlarmSensor) {
            this.addModule((AbstractAlarmSensor)module);
        } else {
            super.addModule(module);
        }
    }

    public void addModule(AbstractAlarmSensor sensor) {
        this.sensor = sensor;
        super.addModule((Module)sensor);
        if (sensor instanceof SmokeSensor) {
            this.setDeviceType(DeviceType.deviceSmokeDetector);
        } else if (sensor instanceof MotionSensor) {
            this.setDeviceType(DeviceType.deviceMotionDetector);
        } else if (sensor instanceof WaterSensor) {
            this.setDeviceType(DeviceType.deviceFloodDetector);
        } else if (sensor instanceof ContactSensor) {
            this.setDeviceType(DeviceType.deviceContactDetector);
        }
    }

    public void addModule(FaultDetection faultDetection) {
        this.faultDetection = faultDetection;
        super.addModule((Module)faultDetection);
    }

    public AbstractAlarmSensor getSensor() {
        return this.sensor;
    }

    public FaultDetection getFaultDetection() {
        return this.faultDetection;
    }
}

