/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.entitymapper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.resource.AccessControlPolicy;
import org.eclipse.om2m.commons.resource.AnnounceableSubordinateResource;
import org.eclipse.om2m.commons.resource.ChildResourceRef;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.commons.utils.AcpUtils;
import org.eclipse.om2m.core.entitymapper.EntityMapper;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.entitymapper.SubscriptionMapper;

public class AcpMapper
extends EntityMapper<AccessControlPolicyEntity, AccessControlPolicy> {
    @Override
    protected void mapAttributes(AccessControlPolicyEntity entity, AccessControlPolicy resource, int level, int offset) {
        if (level < 0) {
            return;
        }
        EntityMapperFactory.getAnnounceableSubordinateMapper().mapAttributes((AnnounceableSubordinateEntity)entity, (AnnounceableSubordinateResource)resource, level, offset);
        resource.setPrivileges(AcpUtils.getSetOfArcsFromACRE((List)entity.getPrivileges()));
        resource.setSelfPrivileges(AcpUtils.getSetOfArcsFromACRE((List)entity.getSelfPrivileges()));
    }

    @Override
    protected List<ChildResourceRef> getChildResourceRef(AccessControlPolicyEntity entity, int level, int offset) {
        ArrayList<ChildResourceRef> childRefs = new ArrayList<ChildResourceRef>();
        if (level == 0) {
            return childRefs;
        }
        for (SubscriptionEntity sub : entity.getChildSubscriptions()) {
            ChildResourceRef child = new ChildResourceRef();
            child.setValue(sub.getResourceID());
            child.setType(23);
            child.setResourceName(sub.getName());
            childRefs.add(child);
            childRefs.addAll(new SubscriptionMapper().getChildResourceRef(sub, level - 1, offset - 1));
        }
        return childRefs;
    }

    @Override
    protected void mapChildResourceRef(AccessControlPolicyEntity entity, AccessControlPolicy resource, int level, int offset) {
        resource.getChildResource().addAll(this.getChildResourceRef(entity, level, offset));
    }

    @Override
    protected void mapChildResources(AccessControlPolicyEntity entity, AccessControlPolicy resource, int level, int offset) {
        if (level == 0) {
            return;
        }
        for (SubscriptionEntity sub : entity.getChildSubscriptions()) {
            Subscription subRes = (Subscription)new SubscriptionMapper().mapEntityToResource(sub, ResultContent.ATTRIBUTES, level - 1, offset - 1);
            resource.getSubscription().add(subRes);
        }
    }

    @Override
    protected AccessControlPolicy createResource() {
        return new AccessControlPolicy();
    }
}

