/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.util.List;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.PollingChannelEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.exceptions.ConflictException;
import org.eclipse.om2m.commons.exceptions.ResourceNotFoundException;
import org.eclipse.om2m.commons.resource.PollingChannel;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.utils.Util;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.datamapper.DataMapperSelector;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.notifier.Notifier;
import org.eclipse.om2m.core.router.Patterns;
import org.eclipse.om2m.core.urimapper.UriMapper;
import org.eclipse.om2m.core.util.ControllerUtil;
import org.eclipse.om2m.persistence.service.DAO;

public class PollingChannelController
extends Controller {
    @Override
    public ResponsePrimitive doCreate(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        DAO<?> dao = Patterns.getDAO(request.getTargetId(), this.dbs);
        if (dao == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        LOGGER.info((Object)("Target ID in controller: " + request.getTargetId()));
        ResourceEntity parentEntity = (ResourceEntity)dao.find(this.transaction, (Object)request.getTargetId());
        if (parentEntity == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        List childPollings = null;
        List acpsToCheck = null;
        String originatorToCheck = null;
        List subscriptions = null;
        if (parentEntity.getResourceType().intValue() == 2) {
            AeEntity ae = (AeEntity)parentEntity;
            childPollings = ae.getPollingChannels();
            originatorToCheck = ae.getAeid();
            acpsToCheck = ae.getAccessControlPolicies();
            subscriptions = ae.getSubscriptions();
        }
        if (parentEntity.getResourceType().intValue() == 16) {
            RemoteCSEEntity remoteCse = (RemoteCSEEntity)parentEntity;
            childPollings = remoteCse.getPollingChannels();
            originatorToCheck = remoteCse.getRemoteCseId();
            acpsToCheck = remoteCse.getAccessControlPolicies();
            subscriptions = remoteCse.getSubscriptions();
        }
        if (request.getFrom() == null) {
            response.setResponseStatusCode(ResponseStatusCode.ACCESS_DENIED);
            return response;
        }
        this.checkACP(acpsToCheck, request.getFrom(), Operation.CREATE);
        if (request.getContent() == null) {
            throw new BadRequestException("A content is requiered for PollingChannel creation");
        }
        PollingChannel pollingChannel = null;
        try {
            pollingChannel = request.getRequestContentType().equals("application/obj") ? (PollingChannel)request.getContent() : (PollingChannel)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
        }
        catch (ClassCastException e) {
            throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
        }
        if (pollingChannel == null) {
            throw new BadRequestException("Error in provided content");
        }
        PollingChannelEntity pollingChannelEntity = new PollingChannelEntity();
        ControllerUtil.CreateUtil.fillEntityFromGenericResource((Resource)pollingChannel, (ResourceEntity)pollingChannelEntity);
        if (pollingChannel.getExpirationTime() != null) {
            pollingChannelEntity.setExpirationTime(pollingChannel.getExpirationTime());
        }
        if (!pollingChannel.getAccessControlPolicyIDs().isEmpty()) {
            pollingChannelEntity.setLinkedAcps(ControllerUtil.buildAcpEntityList(pollingChannel.getAccessControlPolicyIDs(), this.transaction));
        } else {
            pollingChannelEntity.getLinkedAcps().addAll(acpsToCheck);
        }
        String generatedId = PollingChannelController.generateId();
        pollingChannelEntity.setResourceID("/" + Constants.CSE_ID + "/" + "pch" + Constants.PREFIX_SEPERATOR + generatedId);
        if (pollingChannel.getName() != null) {
            if (!Patterns.checkResourceName(pollingChannel.getName())) {
                throw new BadRequestException("Name provided is incorrect. Must be:([A-Za-z0-9_\\-~#]|\\.)+");
            }
            pollingChannelEntity.setName(pollingChannel.getName());
        } else {
            pollingChannelEntity.setName("pch_" + generatedId);
        }
        pollingChannelEntity.setHierarchicalURI(String.valueOf(parentEntity.getHierarchicalURI()) + "/" + pollingChannelEntity.getName());
        pollingChannelEntity.setParentID(parentEntity.getResourceID());
        pollingChannelEntity.setResourceType(15);
        pollingChannelEntity.setLastModifiedTime(Util.DateUtil.now());
        pollingChannelEntity.setCreationTime(Util.DateUtil.now());
        if (!UriMapper.addNewUri(pollingChannelEntity.getHierarchicalURI(), pollingChannelEntity.getResourceID(), 15)) {
            throw new ConflictException("Name already present in the parent collection.");
        }
        pollingChannelEntity.setPollingChannelUri("/" + Constants.CSE_ID + "/" + "pcu" + Constants.PREFIX_SEPERATOR + generatedId);
        this.dbs.getDAOFactory().getPollingChannelDAO().create(this.transaction, (Object)pollingChannelEntity);
        PollingChannelEntity pollingChannelFromDB = (PollingChannelEntity)this.dbs.getDAOFactory().getPollingChannelDAO().find(this.transaction, (Object)pollingChannelEntity.getResourceID());
        childPollings.add(pollingChannelFromDB);
        dao.update(this.transaction, (Object)parentEntity);
        this.transaction.commit();
        Notifier.notify(subscriptions, (ResourceEntity)pollingChannelFromDB, 1);
        this.setLocationAndCreationContent(request, response, (ResourceEntity)pollingChannelFromDB);
        response.setResponseStatusCode(ResponseStatusCode.CREATED);
        return response;
    }

    @Override
    public ResponsePrimitive doRetrieve(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        PollingChannelEntity pollingChannelEntity = (PollingChannelEntity)this.dbs.getDAOFactory().getPollingChannelDAO().find(this.transaction, (Object)request.getTargetId());
        if (pollingChannelEntity == null) {
            throw new ResourceNotFoundException();
        }
        List acpList = pollingChannelEntity.getLinkedAcps();
        this.checkACP(acpList, request.getFrom(), Operation.RETRIEVE);
        PollingChannel pollingChannelResource = EntityMapperFactory.getPollingChannelMapper().mapEntityToResource(pollingChannelEntity, request);
        response.setContent((Object)pollingChannelResource);
        response.setResponseStatusCode(ResponseStatusCode.OK);
        return response;
    }

    @Override
    public ResponsePrimitive doUpdate(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        PollingChannelEntity pollingChannelEntity = (PollingChannelEntity)this.dbs.getDAOFactory().getPollingChannelDAO().find(this.transaction, (Object)request.getTargetId());
        if (pollingChannelEntity == null) {
            throw new ResourceNotFoundException();
        }
        this.checkACP(pollingChannelEntity.getLinkedAcps(), request.getFrom(), Operation.UPDATE);
        if (request.getContent() == null) {
            throw new BadRequestException("A content is requiered for AccessControlPolicy update");
        }
        PollingChannel pollingChannel = null;
        try {
            pollingChannel = request.getRequestContentType().equals("application/obj") ? (PollingChannel)request.getContent() : (PollingChannel)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
        }
        catch (ClassCastException e) {
            throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
        }
        if (pollingChannel == null) {
            throw new BadRequestException("Error in provided content");
        }
        ControllerUtil.UpdateUtil.checkNotPermittedParameters((Resource)pollingChannel);
        PollingChannel modifiedAttributes = new PollingChannel();
        if (pollingChannel.getExpirationTime() != null) {
            pollingChannelEntity.setExpirationTime(pollingChannel.getExpirationTime());
            modifiedAttributes.setExpirationTime(pollingChannel.getExpirationTime());
        }
        if (!pollingChannel.getLabels().isEmpty()) {
            pollingChannelEntity.setLabelsEntitiesFromSring(pollingChannel.getLabels());
            modifiedAttributes.getLabels().addAll(pollingChannel.getLabels());
        }
        pollingChannelEntity.setLastModifiedTime(Util.DateUtil.now());
        modifiedAttributes.setLastModifiedTime(pollingChannelEntity.getLastModifiedTime());
        response.setContent((Object)modifiedAttributes);
        this.dbs.getDAOFactory().getPollingChannelDAO().update(this.transaction, (Object)pollingChannelEntity);
        this.transaction.commit();
        response.setResponseStatusCode(ResponseStatusCode.UPDATED);
        return response;
    }

    @Override
    public ResponsePrimitive doDelete(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        PollingChannelEntity pollingChannelEntity = (PollingChannelEntity)this.dbs.getDAOFactory().getPollingChannelDAO().find(this.transaction, (Object)request.getTargetId());
        if (pollingChannelEntity == null) {
            throw new ResourceNotFoundException();
        }
        this.checkACP(pollingChannelEntity.getLinkedAcps(), request.getFrom(), Operation.DELETE);
        UriMapper.deleteUri(pollingChannelEntity.getHierarchicalURI());
        Notifier.notifyDeletion(null, (ResourceEntity)pollingChannelEntity);
        this.dbs.getDAOFactory().getPollingChannelDAO().delete(this.transaction, (Object)pollingChannelEntity);
        this.transaction.commit();
        response.setResponseStatusCode(ResponseStatusCode.DELETED);
        return response;
    }
}

