/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.util.List;
import org.eclipse.om2m.commons.constants.ConsistencyStrategy;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.MemberType;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.GroupEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.exceptions.ConflictException;
import org.eclipse.om2m.commons.exceptions.NotImplementedException;
import org.eclipse.om2m.commons.exceptions.NotPermittedAttrException;
import org.eclipse.om2m.commons.exceptions.Om2mException;
import org.eclipse.om2m.commons.exceptions.ResourceNotFoundException;
import org.eclipse.om2m.commons.resource.AnnounceableResource;
import org.eclipse.om2m.commons.resource.Group;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.utils.Util;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.datamapper.DataMapperSelector;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.notifier.Notifier;
import org.eclipse.om2m.core.persistence.PersistenceService;
import org.eclipse.om2m.core.router.Patterns;
import org.eclipse.om2m.core.urimapper.UriMapper;
import org.eclipse.om2m.core.util.ControllerUtil;
import org.eclipse.om2m.core.util.GroupUtil;
import org.eclipse.om2m.persistence.service.DAO;
import org.eclipse.om2m.persistence.service.DBService;
import org.eclipse.om2m.persistence.service.DBTransaction;

public class GroupController
extends Controller {
    @Override
    public ResponsePrimitive doCreate(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        DAO<?> dao = Patterns.getDAO(request.getTargetId(), this.dbs);
        if (dao == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        ResourceEntity parentEntity = (ResourceEntity)dao.find(this.transaction, (Object)request.getTargetId());
        if (parentEntity == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        List acpsToCheck = null;
        List childGroups = null;
        List subscriptions = null;
        if (parentEntity.getResourceType().intValue() == 5) {
            CSEBaseEntity cseBase = (CSEBaseEntity)parentEntity;
            acpsToCheck = cseBase.getAccessControlPolicies();
            childGroups = cseBase.getGroups();
            subscriptions = cseBase.getSubscriptions();
        }
        if (parentEntity.getResourceType().intValue() == 2) {
            AeEntity ae = (AeEntity)parentEntity;
            acpsToCheck = ae.getAccessControlPolicies();
            childGroups = ae.getChildGroups();
            subscriptions = ae.getSubscriptions();
        }
        if (parentEntity.getResourceType().intValue() == 16) {
            RemoteCSEEntity remoteCSE = (RemoteCSEEntity)parentEntity;
            acpsToCheck = remoteCSE.getAccessControlPolicies();
            childGroups = remoteCSE.getChildGrps();
            subscriptions = remoteCSE.getSubscriptions();
        }
        if (parentEntity.getResourceType().intValue() == 10016) {
            throw new NotImplementedException("remote cse announcer not implemented");
        }
        if (parentEntity.getResourceType().intValue() == 10002) {
            throw new NotImplementedException("ae annc not implemented");
        }
        this.checkACP(acpsToCheck, request.getFrom(), Operation.CREATE);
        if (request.getContent() == null) {
            throw new BadRequestException("A content is requiered for Group creation");
        }
        Group group = null;
        try {
            group = request.getRequestContentType().equals("application/obj") ? (Group)request.getContent() : (Group)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
        }
        catch (ClassCastException e) {
            throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
        }
        if (group == null) {
            throw new BadRequestException("Error in provided content");
        }
        GroupEntity groupEntity = new GroupEntity();
        ControllerUtil.CreateUtil.fillEntityFromAnnounceableResource((AnnounceableResource)group, (AnnounceableSubordinateEntity)groupEntity);
        if (group.getCurrentNrOfMembers() != null) {
            throw new NotPermittedAttrException("CurrentNrOfMembers is Not Permitted");
        }
        if (group.getMemberTypeValidated() != null) {
            throw new NotPermittedAttrException("MemberTypeValidated is Not Permitted");
        }
        if (group.getMaxNrOfMembers() == null) {
            throw new BadRequestException("MaxNrOfMembers is Mandatory");
        }
        groupEntity.setMaxNrOfMembers(group.getMaxNrOfMembers());
        if (group.getMemberType() == null) {
            groupEntity.setMemberType(MemberType.MIXED);
        } else {
            groupEntity.setMemberType(group.getMemberType());
        }
        if (group.getMemberIDs().isEmpty()) {
            throw new BadRequestException("MemberIDs is Mandatory");
        }
        if (group.getMemberIDs().size() > group.getMaxNrOfMembers().intValue()) {
            throw new Om2mException("Max number of member exceeded", ResponseStatusCode.MAX_NUMBER_OF_MEMBER_EXCEEDED);
        }
        groupEntity.getMemberIDs().addAll(group.getMemberIDs());
        if (group.getConsistencyStrategy() != null) {
            groupEntity.setConsistencyStrategy(group.getConsistencyStrategy());
        } else {
            groupEntity.setConsistencyStrategy(ConsistencyStrategy.ABANDON_MEMBER);
        }
        if (!group.getAccessControlPolicyIDs().isEmpty()) {
            groupEntity.setAccessControlPolicies(ControllerUtil.buildAcpEntityList(group.getAccessControlPolicyIDs(), this.transaction));
        } else {
            groupEntity.getAccessControlPolicies().addAll(acpsToCheck);
        }
        if (group.getCreator() != null) {
            groupEntity.setCreator(group.getCreator());
        }
        if (!group.getMembersAccessControlPolicyIDs().isEmpty()) {
            groupEntity.getMemberAcpIds().addAll(group.getMembersAccessControlPolicyIDs());
        }
        if (group.getGroupName() != null) {
            groupEntity.setGroupName(group.getGroupName());
        }
        String generatedId = GroupController.generateId();
        groupEntity.setResourceID("/" + Constants.CSE_ID + "/" + "grp" + Constants.PREFIX_SEPERATOR + generatedId);
        groupEntity.setCreationTime(Util.DateUtil.now());
        groupEntity.setLastModifiedTime(Util.DateUtil.now());
        groupEntity.setParentID(parentEntity.getResourceID());
        groupEntity.setResourceType(9);
        if (group.getName() != null) {
            if (!Patterns.checkResourceName(group.getName())) {
                throw new BadRequestException("Name provided is incorrect. Must be:([A-Za-z0-9_\\-~#]|\\.)+");
            }
            groupEntity.setName(group.getName());
        } else {
            groupEntity.setName("grp_" + generatedId);
        }
        groupEntity.setHierarchicalURI(String.valueOf(parentEntity.getHierarchicalURI()) + "/" + groupEntity.getName());
        GroupUtil.validateGroupMember(groupEntity);
        if (!UriMapper.addNewUri(groupEntity.getHierarchicalURI(), groupEntity.getResourceID(), 9)) {
            throw new ConflictException("Name already present in the parent collection.");
        }
        this.dbs.getDAOFactory().getGroupDAO().create(this.transaction, (Object)groupEntity);
        GroupEntity groupDB = (GroupEntity)this.dbs.getDAOFactory().getGroupDAO().find(this.transaction, (Object)groupEntity.getResourceID());
        childGroups.add(groupDB);
        dao.update(this.transaction, (Object)parentEntity);
        this.transaction.commit();
        Notifier.notify(subscriptions, (ResourceEntity)groupDB, 1);
        response.setResponseStatusCode(ResponseStatusCode.CREATED);
        this.setLocationAndCreationContent(request, response, (ResourceEntity)groupDB);
        return response;
    }

    @Override
    public ResponsePrimitive doRetrieve(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        GroupEntity groupEntity = (GroupEntity)this.dbs.getDAOFactory().getGroupDAO().find(this.transaction, (Object)request.getTargetId());
        if (groupEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        this.checkACP(groupEntity.getAccessControlPolicies(), request.getFrom(), Operation.RETRIEVE);
        Group group = EntityMapperFactory.getGroupMapper().mapEntityToResource(groupEntity, request);
        response.setContent((Object)group);
        response.setResponseStatusCode(ResponseStatusCode.OK);
        return response;
    }

    @Override
    public ResponsePrimitive doUpdate(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        DBService dbs = PersistenceService.getInstance().getDbService();
        DBTransaction transaction = dbs.getDbTransaction();
        transaction.open();
        GroupEntity groupEntity = (GroupEntity)dbs.getDAOFactory().getGroupDAO().find(transaction, (Object)request.getTargetId());
        if (groupEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        this.checkACP(groupEntity.getAccessControlPolicies(), request.getFrom(), Operation.UPDATE);
        if (request.getContent() == null) {
            throw new BadRequestException("A content is requiered for Group update");
        }
        Group group = null;
        try {
            group = request.getRequestContentType().equals("application/obj") ? (Group)request.getContent() : (Group)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
        }
        catch (ClassCastException e) {
            throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
        }
        if (group == null) {
            throw new BadRequestException("Error in provided content");
        }
        ControllerUtil.UpdateUtil.checkNotPermittedParameters((Resource)group);
        if (group.getCreator() != null) {
            throw new BadRequestException("Creator is NP");
        }
        if (group.getCurrentNrOfMembers() != null) {
            throw new BadRequestException("CurrentNrOfMembers is NP");
        }
        if (group.getMemberTypeValidated() != null) {
            throw new BadRequestException("MemberTypeValidated is NP");
        }
        if (group.getConsistencyStrategy() != null) {
            throw new BadRequestException("ConsistencyStrategy is NP");
        }
        Group modifiedAttributes = new Group();
        if (group.getExpirationTime() != null) {
            groupEntity.setExpirationTime(group.getExpirationTime());
            modifiedAttributes.setExpirationTime(group.getExpirationTime());
        }
        if (!group.getLabels().isEmpty()) {
            groupEntity.getLabelsEntities().clear();
            groupEntity.setLabelsEntitiesFromSring(group.getLabels());
            modifiedAttributes.getLabels().addAll(group.getLabels());
        }
        if (!group.getAnnounceTo().isEmpty()) {
            groupEntity.getAnnounceTo().clear();
            groupEntity.getAnnounceTo().addAll(group.getAnnounceTo());
            modifiedAttributes.getAnnounceTo().addAll(group.getAnnounceTo());
        }
        if (!group.getAnnouncedAttribute().isEmpty()) {
            groupEntity.getAnnouncedAttribute().clear();
            groupEntity.getAnnouncedAttribute().addAll(group.getAnnouncedAttribute());
            modifiedAttributes.getAnnouncedAttribute().addAll(group.getAnnouncedAttribute());
        }
        if (group.getMemberType() != null) {
            groupEntity.setMemberType(group.getMemberType());
            modifiedAttributes.setMemberType(group.getMemberType());
        }
        if (group.getMaxNrOfMembers() != null) {
            groupEntity.setMaxNrOfMembers(group.getMaxNrOfMembers());
            modifiedAttributes.setMaxNrOfMembers(group.getMaxNrOfMembers());
        }
        if (!group.getMemberIDs().isEmpty()) {
            groupEntity.getMemberIDs().clear();
            groupEntity.getMemberIDs().addAll(group.getMemberIDs());
            modifiedAttributes.getMemberIDs().addAll(group.getMemberIDs());
        }
        if (!group.getMembersAccessControlPolicyIDs().isEmpty()) {
            for (AccessControlPolicyEntity acpe : groupEntity.getAccessControlPolicies()) {
                this.checkSelfACP(acpe, request.getFrom(), Operation.UPDATE);
            }
            groupEntity.getMemberAcpIds().clear();
            groupEntity.getMemberAcpIds().addAll(group.getMembersAccessControlPolicyIDs());
            modifiedAttributes.getMembersAccessControlPolicyIDs().addAll(group.getMembersAccessControlPolicyIDs());
        }
        if (group.getGroupName() != null) {
            groupEntity.setGroupName(group.getGroupName());
            modifiedAttributes.setGroupName(group.getGroupName());
        }
        groupEntity.setLastModifiedTime(Util.DateUtil.now());
        modifiedAttributes.setLastModifiedTime(groupEntity.getLastModifiedTime());
        response.setContent((Object)modifiedAttributes);
        GroupUtil.validateGroupMember(groupEntity);
        dbs.getDAOFactory().getGroupDAO().update(transaction, (Object)groupEntity);
        transaction.commit();
        Notifier.notify(groupEntity.getSubscriptions(), (ResourceEntity)groupEntity, 3);
        response.setResponseStatusCode(ResponseStatusCode.UPDATED);
        return response;
    }

    @Override
    public ResponsePrimitive doDelete(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        GroupEntity groupEntity = (GroupEntity)this.dbs.getDAOFactory().getGroupDAO().find(this.transaction, (Object)request.getTargetId());
        if (groupEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        this.checkACP(groupEntity.getAccessControlPolicies(), request.getFrom(), Operation.DELETE);
        UriMapper.deleteUri(groupEntity.getHierarchicalURI());
        Notifier.notifyDeletion(groupEntity.getSubscriptions(), (ResourceEntity)groupEntity);
        this.dbs.getDAOFactory().getGroupDAO().delete(this.transaction, (Object)groupEntity);
        this.transaction.commit();
        response.setResponseStatusCode(ResponseStatusCode.DELETED);
        return response;
    }
}

