/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.das.testsuite.ae;

import java.util.ArrayList;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AE;
import org.eclipse.om2m.commons.resource.DynamicAuthorizationConsultation;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.das.testsuite.Test;
import org.eclipse.om2m.das.testsuite.ae.AbstractDASServiceTest;
import org.eclipse.om2m.interworking.service.InterworkingService;
import org.osgi.framework.ServiceRegistration;

public class DASServiceTest_TwoDAS
extends AbstractDASServiceTest {
    private int nbOfCallDas1 = 0;
    private int nbOfCallDas2 = 0;

    public DASServiceTest_TwoDAS(CseService pCseService) {
        super("DasService Two services", pCseService);
    }

    @Override
    public void performTest() {
        final AE dasAe1 = this.createAe();
        final AE dasAe2 = this.createAe();
        ArrayList<String> poas = new ArrayList<String>();
        poas.add(dasAe1.getResourceID());
        poas.add(dasAe2.getResourceID());
        DynamicAuthorizationConsultation dac = this.createDAS(poas);
        if (dac == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create dac");
            return;
        }
        ServiceRegistration<InterworkingService> interworkingServiceRegistration = this.registerInterworkingService(new InterworkingService(){

            public String getAPOCPath() {
                return (String)dasAe1.getPointOfAccess().get(0);
            }

            public ResponsePrimitive doExecute(RequestPrimitive RequestPrimitive2) {
                DASServiceTest_TwoDAS dASServiceTest_TwoDAS = DASServiceTest_TwoDAS.this;
                dASServiceTest_TwoDAS.nbOfCallDas1 = dASServiceTest_TwoDAS.nbOfCallDas1 + 1;
                ResponsePrimitive response = new ResponsePrimitive(RequestPrimitive2);
                response.setResponseStatusCode(ResponseStatusCode.ACCESS_DENIED);
                return response;
            }
        });
        ServiceRegistration<InterworkingService> interworkingServiceRegistration2 = this.registerInterworkingService(new InterworkingService(){

            public String getAPOCPath() {
                return (String)dasAe2.getPointOfAccess().get(0);
            }

            public ResponsePrimitive doExecute(RequestPrimitive RequestPrimitive2) {
                DASServiceTest_TwoDAS dASServiceTest_TwoDAS = DASServiceTest_TwoDAS.this;
                dASServiceTest_TwoDAS.nbOfCallDas2 = dASServiceTest_TwoDAS.nbOfCallDas2 + 1;
                ResponsePrimitive response = new ResponsePrimitive(RequestPrimitive2);
                response.setResponseStatusCode(ResponseStatusCode.ACCESS_DENIED);
                return response;
            }
        });
        ArrayList<String> dacis = new ArrayList<String>();
        dacis.add(dac.getResourceID());
        AE ae = this.createAE(dacis);
        if (ae == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create AE");
            return;
        }
        ResponsePrimitive response = this.retrieveEntity(ae.getResourceID(), "nom:password");
        if (!ResponseStatusCode.ACCESS_DENIED.equals(response.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("expecting " + ResponseStatusCode.ACCESS_DENIED + ", found =" + response.getResponseStatusCode());
            return;
        }
        this.unregisterInterworkingService(interworkingServiceRegistration);
        this.unregisterInterworkingService(interworkingServiceRegistration2);
        this.deleteEntity(dasAe1.getResourceID());
        this.deleteEntity(dasAe2.getResourceID());
        if (this.nbOfCallDas1 != 1) {
            this.setState(Test.State.KO);
            this.setMessage("expect 1 call on ae1, received " + this.nbOfCallDas1 + " call");
            return;
        }
        if (this.nbOfCallDas2 != 1) {
            this.setState(Test.State.KO);
            this.setMessage("expect 1 call on ae2, received " + this.nbOfCallDas2 + " call");
            return;
        }
        this.setState(Test.State.OK);
    }
}

